# Generated by Django 3.0.7 on 2020-09-14 08:40

from django.db import migrations


def fix_rename_changes(apps, schema_editor):
    Change = apps.get_model("trans", "Change")
    db_alias = schema_editor.connection.alias
    for change in (
        Change.objects.using(db_alias)
        .filter(action__in=[41, 42, 43])
        .select_related("project", "component")
    ):
        change.old = change.target
        if change.action in (43, 41):
            # Move component, rename project
            change.target = change.project.slug
        elif change.action == 42:
            # Rename component
            change.target = change.component.slug
        change.save(update_fields=["target", "old"])


class Migration(migrations.Migration):

    dependencies = [
        ("trans", "0100_auto_20200912_1131"),
    ]

    operations = [migrations.RunPython(fix_rename_changes, elidable=True)]
