# Generated by Django 3.1.3 on 2020-12-10 09:56

from django.db import migrations

from weblate.addons.events import EVENT_PRE_COMMIT
from weblate.addons.utils import adjust_addon_events


def update_cleanup_addon(apps, schema_editor):
    """Update events setup for weblate.git.squash addon."""
    adjust_addon_events(
        apps,
        schema_editor,
        ["weblate.cleanup.generic"],
        [EVENT_PRE_COMMIT],
        [],
    )


class Migration(migrations.Migration):

    dependencies = [
        ("addons", "0001_squashed_0021_linguas_daily"),
    ]

    operations = [migrations.RunPython(update_cleanup_addon, elidable=True)]
