"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TooManyExternalConnections = exports.RepositoryNameTooLong = exports.RepositoryNameInvalid = exports.DomainNameInvalid = exports.DomainNameTooLong = void 0;
/**
 * Excpetion thrown when Domain Name is too long
 */
class DomainNameTooLong extends Error {
    constructor(msg = 'Domain name too long.  Must be no more than 50 characters in length.') {
        super(msg);
        Object.setPrototypeOf(this, DomainNameTooLong.prototype);
    }
}
exports.DomainNameTooLong = DomainNameTooLong;
/**
 * Exception thrown when Domain Name is not valid.
 */
class DomainNameInvalid extends Error {
    constructor(msg = 'Domain name is not valid.  Name must contain lowercase letters, numbers and "-" characters only.') {
        super(msg);
        Object.setPrototypeOf(this, DomainNameInvalid.prototype);
    }
}
exports.DomainNameInvalid = DomainNameInvalid;
/**
 * Excpetion thrown when Repository Name is not valid
 */
class RepositoryNameInvalid extends Error {
    constructor(msg = 'Repository name is not valid.  Name must contain alphabetic letters of any case, numbers, "-", "." and "_" characters only.') {
        super(msg);
        Object.setPrototypeOf(this, RepositoryNameInvalid.prototype);
    }
}
exports.RepositoryNameInvalid = RepositoryNameInvalid;
/**
 * Exception thrown when the Repository Name is too long
 */
class RepositoryNameTooLong extends Error {
    constructor(msg = 'Repository name too long.  Must be no more than 100 characters in length.') {
        super(msg);
        Object.setPrototypeOf(this, RepositoryNameTooLong.prototype);
    }
}
exports.RepositoryNameTooLong = RepositoryNameTooLong;
/**
 * Exception thrown when too many external connections are listed in the Repository props.
 */
class TooManyExternalConnections extends Error {
    constructor(msg = 'Too Many external connections.  Can only configure one external connection.') {
        super(msg);
        Object.setPrototypeOf(this, TooManyExternalConnections.prototype);
    }
}
exports.TooManyExternalConnections = TooManyExternalConnections;
//# sourceMappingURL=data:application/json;base64,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