"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeArtifact = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_codeartifact_1 = require("aws-cdk-lib/aws-codeartifact");
const constructs_1 = require("constructs");
const validations = require("./validations");
/**
 * A Construct that will allow easy setup of an AWS CodeArtifact Repository within a domain
 */
class CodeArtifact extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.repositories = [];
        this.props = props;
        validations.validateDomainNameLength(props.domainName);
        validations.validateDomainName(props.domainName);
        this.domain = new aws_codeartifact_1.CfnDomain(scope, props.domainName, props);
        if (props.repositories) {
            for (const repoProps of props.repositories) {
                validations.validateRepoNameLength(repoProps.repositoryName);
                validations.validateRepoName(repoProps.repositoryName);
                validations.validateExternalConnections(repoProps.externalConnections);
                const repo = new aws_codeartifact_1.CfnRepository(scope, repoProps.repositoryName, {
                    domainName: this.props.domainName,
                    ...repoProps,
                });
                repo.node.addDependency(this.domain);
                this.repositories.push(repo);
            }
        }
    }
}
exports.CodeArtifact = CodeArtifact;
_a = JSII_RTTI_SYMBOL_1;
CodeArtifact[_a] = { fqn: "cdk-codeartifact.CodeArtifact", version: "0.0.9" };
//# sourceMappingURL=data:application/json;base64,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