# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sklearn_instrumentation', 'sklearn_instrumentation.instruments']

package_data = \
{'': ['*']}

install_requires = \
['scikit-learn']

extras_require = \
{'all': ['prometheus-client>=0.10.1,<0.11.0',
         'ddtrace>=0.48.0,<0.49.0',
         'opentelemetry-api>=1.0.0,<2.0.0',
         'pyinstrument>=3.4.1,<4.0.0',
         'memory-profiler>=0.58.0,<0.59.0',
         'statsd>=3.3.0,<4.0.0'],
 'datadog': ['ddtrace>=0.48.0,<0.49.0'],
 'memory-profiler': ['memory-profiler>=0.58.0,<0.59.0'],
 'opentelemetry': ['opentelemetry-api>=1.0.0,<2.0.0'],
 'prometheus': ['prometheus-client>=0.10.1,<0.11.0'],
 'pyinstrument': ['pyinstrument>=3.4.1,<4.0.0'],
 'statsd': ['statsd>=3.3.0,<4.0.0']}

setup_kwargs = {
    'name': 'sklearn-instrumentation',
    'version': '0.8.0',
    'description': 'scikit-learn instrumentation tooling',
    'long_description': 'sklearn-instrumentation\n=======================\n\n|actions| |rtd| |pypi| |pyversions|\n\n.. |actions| image:: https://github.com/crflynn/sklearn-instrumentation/workflows/build/badge.svg\n    :target: https://github.com/crflynn/sklearn-instrumentation/actions\n\n.. |rtd| image:: https://img.shields.io/readthedocs/sklearn-instrumentation.svg\n    :target: http://sklearn-instrumentation.readthedocs.io/en/latest/\n\n.. |pypi| image:: https://img.shields.io/pypi/v/sklearn-instrumentation.svg\n    :target: https://pypi.python.org/pypi/sklearn-instrumentation\n\n.. |pyversions| image:: https://img.shields.io/pypi/pyversions/sklearn-instrumentation.svg\n    :target: https://pypi.python.org/pypi/sklearn-instrumentation\n\n\nGeneralized instrumentation tooling for scikit-learn models. ``sklearn_instrumentation`` allows instrumenting the ``sklearn`` package and any scikit-learn compatible packages with estimators and transformers inheriting from ``sklearn.base.BaseEstimator``.\n\nInstrumentation applies decorators to methods of ``BaseEstimator``-derived classes or instances. By default the instrumentor applies instrumentation to the following methods (except when they are properties of instances):\n\n* fit\n* predict\n* predict_log_proba\n* predict_proba\n* transform\n* _fit\n* _predict\n* _predict_log_proba\n* _predict_proba\n* _transform\n\n**sklearn-instrumentation** supports instrumentation of full sklearn-compatible packages, as well as recursive instrumentation of models (metaestimators like ``Pipeline``, or even single estimators like ``RandomForestClassifier``)\n\nInstallation\n------------\n\nThe sklearn-instrumentation package is available on pypi and can be installed using pip\n\n.. code-block:: bash\n\n    pip install sklearn-instrumentation\n\n\nPackage instrumentation\n-----------------------\n\nInstrument any sklearn compatible package that has ``BaseEstimator``-derived classes.\n\n.. code-block:: python\n\n    from sklearn_instrumentation import SklearnInstrumentor\n\n    instrumentor = SklearnInstrumentor(instrument=my_instrument)\n    instrumentor.instrument_packages(["sklearn", "xgboost", "lightgbm"])\n\n\nFull example:\n\n.. code-block:: python\n\n    import logging\n\n    from sklearn.datasets import load_iris\n    from sklearn.decomposition import PCA\n    from sklearn.ensemble import RandomForestClassifier\n    from sklearn.pipeline import FeatureUnion\n    from sklearn.pipeline import Pipeline\n    from sklearn.preprocessing import StandardScaler\n\n    from sklearn_instrumentation import SklearnInstrumentor\n    from sklearn_instrumentation.instruments.logging import TimeElapsedLogger\n\n    logging.basicConfig(level=logging.INFO)\n\n    # Create an instrumentor and instrument sklearn\n    instrumentor = SklearnInstrumentor(instrument=TimeElapsedLogger())\n    instrumentor.instrument_packages(["sklearn"])\n\n    # Create a toy model for classification\n    ss = StandardScaler()\n    pca = PCA(n_components=3)\n    rf = RandomForestClassifier()\n    classification_model = Pipeline(\n        steps=[\n            (\n                "fu",\n                FeatureUnion(\n                    transformer_list=[\n                        ("ss", ss),\n                        ("pca", pca),\n                    ]\n                ),\n            ),\n            ("rf", rf),\n        ]\n    )\n    X, y = load_iris(return_X_y=True)\n\n    # Observe logging\n    classification_model.fit(X, y)\n    # INFO:sklearn_instrumentation.instruments.logging:Pipeline.fit starting.\n    # INFO:sklearn_instrumentation.instruments.logging:Pipeline._fit starting.\n    # INFO:sklearn_instrumentation.instruments.logging:StandardScaler.fit starting.\n    # INFO:sklearn_instrumentation.instruments.logging:StandardScaler.fit elapsed time: 0.0006406307220458984 seconds\n    # INFO:sklearn_instrumentation.instruments.logging:StandardScaler.transform starting.\n    # INFO:sklearn_instrumentation.instruments.logging:StandardScaler.transform elapsed time: 0.0001430511474609375 seconds\n    # INFO:sklearn_instrumentation.instruments.logging:PCA._fit starting.\n    # INFO:sklearn_instrumentation.instruments.logging:PCA._fit elapsed time: 0.0006711483001708984 seconds\n    # INFO:sklearn_instrumentation.instruments.logging:Pipeline._fit elapsed time: 0.0026731491088867188 seconds\n    # INFO:sklearn_instrumentation.instruments.logging:BaseForest.fit starting.\n    # INFO:sklearn_instrumentation.instruments.logging:BaseForest.fit elapsed time: 0.1768970489501953 seconds\n    # INFO:sklearn_instrumentation.instruments.logging:Pipeline.fit elapsed time: 0.17983102798461914 seconds\n\n    # Observe logging\n    classification_model.predict(X)\n    # INFO:sklearn_instrumentation.instruments.logging:Pipeline.predict starting.\n    # INFO:sklearn_instrumentation.instruments.logging:FeatureUnion.transform starting.\n    # INFO:sklearn_instrumentation.instruments.logging:StandardScaler.transform starting.\n    # INFO:sklearn_instrumentation.instruments.logging:StandardScaler.transform elapsed time: 0.00024509429931640625 seconds\n    # INFO:sklearn_instrumentation.instruments.logging:_BasePCA.transform starting.\n    # INFO:sklearn_instrumentation.instruments.logging:_BasePCA.transform elapsed time: 0.0002181529998779297 seconds\n    # INFO:sklearn_instrumentation.instruments.logging:FeatureUnion.transform elapsed time: 0.0012080669403076172 seconds\n    # INFO:sklearn_instrumentation.instruments.logging:ForestClassifier.predict starting.\n    # INFO:sklearn_instrumentation.instruments.logging:ForestClassifier.predict_proba starting.\n    # INFO:sklearn_instrumentation.instruments.logging:ForestClassifier.predict_proba elapsed time: 0.013531208038330078 seconds\n    # INFO:sklearn_instrumentation.instruments.logging:ForestClassifier.predict elapsed time: 0.013692140579223633 seconds\n    # INFO:sklearn_instrumentation.instruments.logging:Pipeline.predict elapsed time: 0.015219926834106445 seconds\n\n    # Remove instrumentation\n    instrumentor.uninstrument_packages(["sklearn"])\n\n    # Observe no logging\n    classification_model.predict(X)\n\n\nMachine learning model instrumentation\n--------------------------------------\n\nInstrument any sklearn compatible trained estimator or metaestimator.\n\n.. code-block:: python\n\n    from sklearn_instrumentation import SklearnInstrumentor\n\n    instrumentor = SklearnInstrumentor(instrument=my_instrument)\n    instrumentor.instrument_estimator(estimator=my_ml_pipeline)\n\n\nExample:\n\n.. code-block:: python\n\n    import logging\n\n    from sklearn.datasets import load_iris\n    from sklearn_instrumentation import SklearnInstrumentor\n    from sklearn_instrumentation.instruments.logging import TimeElapsedLogger\n    from sklearn.ensemble import RandomForestClassifier\n\n    logging.basicConfig(level=logging.INFO)\n\n    # Train a classifier\n    X, y = load_iris(return_X_y=True)\n    rf = RandomForestClassifier()\n\n    rf.fit(X, y)\n\n    # Create an instrumentor which decorates BaseEstimator methods with\n    # logging output when entering and exiting methods, with time elapsed logged\n    # on exit.\n    instrumentor = SklearnInstrumentor(instrument=TimeElapsedLogger())\n\n    # Apply the decorator to all BaseEstimators in each of these libraries\n    instrumentor.instrument_estimator(rf)\n\n    # Observe the logging output\n    rf.predict(X)\n    # INFO:sklearn_instrumentation.instruments.logging:ForestClassifier.predict starting.\n    # INFO:sklearn_instrumentation.instruments.logging:ForestClassifier.predict_proba starting.\n    # INFO:sklearn_instrumentation.instruments.logging:ForestClassifier.predict_proba elapsed time: 0.014165163040161133 seconds\n    # INFO:sklearn_instrumentation.instruments.logging:ForestClassifier.predict elapsed time: 0.014327764511108398 seconds\n\n    # Remove the decorator from all BaseEstimators in each of these libraries\n    instrumentor.uninstrument_estimator(rf)\n\n    # No more logging\n    rf.predict(X)\n\n\nInstrumentation\n---------------\n\nThe package comes with a handful of instruments which log information about ``X`` or timing of execution. You can create your own instrumentation just by creating a decorator, following this pattern\n\n.. code-block:: python\n\n    from functools import wraps\n\n\n    def my_instrumentation(func, **dkwargs):\n        """Wrap an estimator method with instrumentation.\n\n        :param func: The method to be instrumented.\n        :param dkwargs: Decorator kwargs, which can be passed to the\n            decorator at decoration time. For estimator instrumentation\n            this allows different parametrizations for each ml model.\n        """\n        @wraps(func)\n        def wrapper(*args, **kwargs):\n            """Wrapping function.\n\n            :param args: The args passed to methods, typically\n                just ``X`` and/or ``y``\n            :param kwargs: The kwargs passed to methods, usually\n                weights or other params\n            """\n            # Code goes here before execution of the estimator method\n            retval = func(*args, **kwargs)\n            # Code goes here after execution of the estimator method\n            return retval\n\n        return wrapper\n\n\nTo create a stateful instrument, use a class with the ``__call__`` method for implementing the decorator:\n\n.. code-block:: python\n\n    from functools import wraps\n\n    from sklearn_instrumentation.instruments.base import BaseInstrument\n\n\n    class MyInstrument(BaseInstrument)\n\n        def __init__(self, *args, **kwargs):\n            # handle any statefulness here\n            pass\n\n        def __call__(self, func, **dkwargs):\n            """Wrap an estimator method with instrumentation.\n\n            :param func: The method to be instrumented.\n            :param dkwargs: Decorator kwargs, which can be passed to the\n                decorator at decoration time. For estimator instrumentation\n                this allows different parametrizations for each ml model.\n            """\n            @wraps(func)\n            def wrapper(*args, **kwargs):\n                """Wrapping function.\n\n                :param args: The args passed to methods, typically\n                    just ``X`` and/or ``y``\n                :param kwargs: The kwargs passed to methods, usually\n                    weights or other params\n                """\n                # Code goes here before execution of the estimator method\n                retval = func(*args, **kwargs)\n                # Code goes here after execution of the estimator method\n                return retval\n\n            return wrapper\n\n\nTo pass kwargs for different ml models:\n\n.. code-block:: python\n\n    instrumentor = SklearnInstrumentor(instrument=my_instrument)\n\n    instrumentor.instrument_estimator(estimator=ml_model_1, instrument_kwargs={"name": "awesome_model"})\n    instrumentor.instrument_estimator(estimator=ml_model_2, instrument_kwargs={"name": "better_model"})\n\n',
    'author': 'flynn',
    'author_email': 'crf204@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/crflynn/sklearn-instrumentation',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
