from typing import Any

from pydantic.json_schema import GenerateJsonSchema
from typing_extensions import override


class JsonSchemaGenerator(GenerateJsonSchema):
    """A schema generator that simplifies the schemas generated by pydantic."""

    @override
    def generate(self, *args: Any, **kwargs: Any):
        generated = super().generate(*args, **kwargs)
        # Remove the title from the schema
        generated.pop("title", None)
        return generated

    @override
    def field_title_should_be_set(self, *args: Any, **kwargs: Any) -> bool:
        return False
