# Python SDK for WorkflowAI

[![WorkflowAI](./examples/assets/readme-header.png)](https://workflowai.com)

[![PyPI version](https://img.shields.io/pypi/v/workflowai.svg)](https://pypi.org/project/workflowai/)
[![License: Apache 2.0](https://img.shields.io/badge/License-Apache_2.0-blue.svg)](https://opensource.org/licenses/Apache-2.0)

Official SDK from [WorkflowAI](https://workflowai.com) for Python.

## WorkflowAI

[WorkflowAI](https://workflowai.com) is a low-code tool for product managers and software engineers
that makes it easier to ship features powered by AI.

This SDK is designed for Python teams who prefer code-first development. It provides greater control through direct code integration while still leveraging the full power of the WorkflowAI platform, complementing the web-app experience.

## Installation

`workflowai` requires a python >= 3.9.

```sh
pip install workflowai
```

## Get Started

Follow the steps in our [Getting Started Guide](https://docs.workflowai.com/python-sdk/get-started).

## Documentation

Complete documentation is available at [docs.workflowai.com/python-sdk](https://docs.workflowai.com/python-sdk).

## Example

Examples are available in the [examples](./examples/) directory.

## Workflows

For advanced workflow patterns and examples, please refer to the [Workflows README](examples/workflows/README.md) for more details.

## Contributing

See the [CONTRIBUTING.md](./CONTRIBUTING.md) file for more details. Thank you!
