# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ReportingTurnAction(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ReportingTurnAction - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'action_id': 'str',
            'action_name': 'str',
            'action_number': 'int',
            'action_type': 'str'
        }

        self.attribute_map = {
            'action_id': 'actionId',
            'action_name': 'actionName',
            'action_number': 'actionNumber',
            'action_type': 'actionType'
        }

        self._action_id = None
        self._action_name = None
        self._action_number = None
        self._action_type = None

    @property
    def action_id(self):
        """
        Gets the action_id of this ReportingTurnAction.
        The ID of the action in the bot flow.

        :return: The action_id of this ReportingTurnAction.
        :rtype: str
        """
        return self._action_id

    @action_id.setter
    def action_id(self, action_id):
        """
        Sets the action_id of this ReportingTurnAction.
        The ID of the action in the bot flow.

        :param action_id: The action_id of this ReportingTurnAction.
        :type: str
        """
        
        self._action_id = action_id

    @property
    def action_name(self):
        """
        Gets the action_name of this ReportingTurnAction.
        The name of the action in the bot flow.

        :return: The action_name of this ReportingTurnAction.
        :rtype: str
        """
        return self._action_name

    @action_name.setter
    def action_name(self, action_name):
        """
        Sets the action_name of this ReportingTurnAction.
        The name of the action in the bot flow.

        :param action_name: The action_name of this ReportingTurnAction.
        :type: str
        """
        
        self._action_name = action_name

    @property
    def action_number(self):
        """
        Gets the action_number of this ReportingTurnAction.
        The number of the action in the bot flow.

        :return: The action_number of this ReportingTurnAction.
        :rtype: int
        """
        return self._action_number

    @action_number.setter
    def action_number(self, action_number):
        """
        Sets the action_number of this ReportingTurnAction.
        The number of the action in the bot flow.

        :param action_number: The action_number of this ReportingTurnAction.
        :type: int
        """
        
        self._action_number = action_number

    @property
    def action_type(self):
        """
        Gets the action_type of this ReportingTurnAction.


        :return: The action_type of this ReportingTurnAction.
        :rtype: str
        """
        return self._action_type

    @action_type.setter
    def action_type(self, action_type):
        """
        Sets the action_type of this ReportingTurnAction.


        :param action_type: The action_type of this ReportingTurnAction.
        :type: str
        """
        allowed_values = ["AskForNLUIntentAction", "AskForBooleanAction", "AskForSlotAction", "AskForNLUNextIntentAction", "BotState", "DisconnectAction", "ExitBotFlowAction", "CallTaskAction", "EndTaskAction", "UpdateVariableAction", "CommunicateAction", "DecisionAction", "SwitchAction", "DataAction", "DataTableLookupAction", "GetExternalContactAction", "GetExternalOrganizationAction", "LoopAction", "ExitLoopAction", "NextLoopAction", "LoopUntilAction", "SetActiveIntentAction", "ClearSlotAction", "SetFlowOutcomeAction", "InitializeFlowOutcomeAction", "AddFlowMilestoneAction", "AskForStringAction", "SendResponseAction", "GetResponseAction", "ExtractSecureDataAction", "SecureAction", "TransferTaskAction", "DigitalMenuAction", "WaitForInputAction", "Unknown"]
        if action_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for action_type -> " + action_type)
            self._action_type = "outdated_sdk_version"
        else:
            self._action_type = action_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

