# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class LearningModuleReassignSummary(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        LearningModuleReassignSummary - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'total_reassigned': 'int',
            'completed_count': 'int',
            'in_progress_count': 'int',
            'assigned_count': 'int',
            'not_completed_count': 'int'
        }

        self.attribute_map = {
            'total_reassigned': 'totalReassigned',
            'completed_count': 'completedCount',
            'in_progress_count': 'inProgressCount',
            'assigned_count': 'assignedCount',
            'not_completed_count': 'notCompletedCount'
        }

        self._total_reassigned = None
        self._completed_count = None
        self._in_progress_count = None
        self._assigned_count = None
        self._not_completed_count = None

    @property
    def total_reassigned(self):
        """
        Gets the total_reassigned of this LearningModuleReassignSummary.
        The total number of users for whom assignment is reassigned

        :return: The total_reassigned of this LearningModuleReassignSummary.
        :rtype: int
        """
        return self._total_reassigned

    @total_reassigned.setter
    def total_reassigned(self, total_reassigned):
        """
        Sets the total_reassigned of this LearningModuleReassignSummary.
        The total number of users for whom assignment is reassigned

        :param total_reassigned: The total_reassigned of this LearningModuleReassignSummary.
        :type: int
        """
        
        self._total_reassigned = total_reassigned

    @property
    def completed_count(self):
        """
        Gets the completed_count of this LearningModuleReassignSummary.
        The total number of users who have the assignment in Completed state

        :return: The completed_count of this LearningModuleReassignSummary.
        :rtype: int
        """
        return self._completed_count

    @completed_count.setter
    def completed_count(self, completed_count):
        """
        Sets the completed_count of this LearningModuleReassignSummary.
        The total number of users who have the assignment in Completed state

        :param completed_count: The completed_count of this LearningModuleReassignSummary.
        :type: int
        """
        
        self._completed_count = completed_count

    @property
    def in_progress_count(self):
        """
        Gets the in_progress_count of this LearningModuleReassignSummary.
        The total number of users who have the assignment in InProgress state

        :return: The in_progress_count of this LearningModuleReassignSummary.
        :rtype: int
        """
        return self._in_progress_count

    @in_progress_count.setter
    def in_progress_count(self, in_progress_count):
        """
        Sets the in_progress_count of this LearningModuleReassignSummary.
        The total number of users who have the assignment in InProgress state

        :param in_progress_count: The in_progress_count of this LearningModuleReassignSummary.
        :type: int
        """
        
        self._in_progress_count = in_progress_count

    @property
    def assigned_count(self):
        """
        Gets the assigned_count of this LearningModuleReassignSummary.
        The total number of users who have the assignment in Assigned state

        :return: The assigned_count of this LearningModuleReassignSummary.
        :rtype: int
        """
        return self._assigned_count

    @assigned_count.setter
    def assigned_count(self, assigned_count):
        """
        Sets the assigned_count of this LearningModuleReassignSummary.
        The total number of users who have the assignment in Assigned state

        :param assigned_count: The assigned_count of this LearningModuleReassignSummary.
        :type: int
        """
        
        self._assigned_count = assigned_count

    @property
    def not_completed_count(self):
        """
        Gets the not_completed_count of this LearningModuleReassignSummary.
        The total number of users who have their assignment overdue

        :return: The not_completed_count of this LearningModuleReassignSummary.
        :rtype: int
        """
        return self._not_completed_count

    @not_completed_count.setter
    def not_completed_count(self, not_completed_count):
        """
        Sets the not_completed_count of this LearningModuleReassignSummary.
        The total number of users who have their assignment overdue

        :param not_completed_count: The not_completed_count of this LearningModuleReassignSummary.
        :type: int
        """
        
        self._not_completed_count = not_completed_count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

