# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class Education(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Education - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'school': 'str',
            'field_of_study': 'str',
            'notes': 'str',
            'date_start': 'date',
            'date_end': 'date'
        }

        self.attribute_map = {
            'school': 'school',
            'field_of_study': 'fieldOfStudy',
            'notes': 'notes',
            'date_start': 'dateStart',
            'date_end': 'dateEnd'
        }

        self._school = None
        self._field_of_study = None
        self._notes = None
        self._date_start = None
        self._date_end = None

    @property
    def school(self):
        """
        Gets the school of this Education.


        :return: The school of this Education.
        :rtype: str
        """
        return self._school

    @school.setter
    def school(self, school):
        """
        Sets the school of this Education.


        :param school: The school of this Education.
        :type: str
        """
        
        self._school = school

    @property
    def field_of_study(self):
        """
        Gets the field_of_study of this Education.


        :return: The field_of_study of this Education.
        :rtype: str
        """
        return self._field_of_study

    @field_of_study.setter
    def field_of_study(self, field_of_study):
        """
        Sets the field_of_study of this Education.


        :param field_of_study: The field_of_study of this Education.
        :type: str
        """
        
        self._field_of_study = field_of_study

    @property
    def notes(self):
        """
        Gets the notes of this Education.
        Notes about education has a 2000 character limit

        :return: The notes of this Education.
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """
        Sets the notes of this Education.
        Notes about education has a 2000 character limit

        :param notes: The notes of this Education.
        :type: str
        """
        
        self._notes = notes

    @property
    def date_start(self):
        """
        Gets the date_start of this Education.
        Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_start of this Education.
        :rtype: date
        """
        return self._date_start

    @date_start.setter
    def date_start(self, date_start):
        """
        Sets the date_start of this Education.
        Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_start: The date_start of this Education.
        :type: date
        """
        
        self._date_start = date_start

    @property
    def date_end(self):
        """
        Gets the date_end of this Education.
        Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_end of this Education.
        :rtype: date
        """
        return self._date_end

    @date_end.setter
    def date_end(self, date_end):
        """
        Sets the date_end of this Education.
        Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_end: The date_end of this Education.
        :type: date
        """
        
        self._date_end = date_end

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

