import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 * @external
 */
export interface CfnScalingPlanProps {
    /**
     * `AWS::AutoScalingPlans::ScalingPlan.ApplicationSource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-applicationsource
     * @external
     */
    readonly applicationSource: CfnScalingPlan.ApplicationSourceProperty | cdk.IResolvable;
    /**
     * `AWS::AutoScalingPlans::ScalingPlan.ScalingInstructions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-scalinginstructions
     * @external
     */
    readonly scalingInstructions: Array<CfnScalingPlan.ScalingInstructionProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 * @external
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 */
export declare class CfnScalingPlan extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AutoScalingPlans::ScalingPlan";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnScalingPlan;
    /**
     * @external
     * @cloudformationAttribute ScalingPlanName
     */
    readonly attrScalingPlanName: string;
    /**
     * @external
     * @cloudformationAttribute ScalingPlanVersion
     */
    readonly attrScalingPlanVersion: string;
    /**
     * `AWS::AutoScalingPlans::ScalingPlan.ApplicationSource`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-applicationsource
     * @external
     */
    applicationSource: CfnScalingPlan.ApplicationSourceProperty | cdk.IResolvable;
    /**
     * `AWS::AutoScalingPlans::ScalingPlan.ScalingInstructions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html#cfn-autoscalingplans-scalingplan-scalinginstructions
     * @external
     */
    scalingInstructions: Array<CfnScalingPlan.ScalingInstructionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * Create a new `AWS::AutoScalingPlans::ScalingPlan`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnScalingPlanProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 * @external
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 */
export declare namespace CfnScalingPlan {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-applicationsource.html
     * @external
     */
    interface ApplicationSourceProperty {
        /**
         * `CfnScalingPlan.ApplicationSourceProperty.CloudFormationStackARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-applicationsource.html#cfn-autoscalingplans-scalingplan-applicationsource-cloudformationstackarn
         * @external
         */
        readonly cloudFormationStackArn?: string;
        /**
         * `CfnScalingPlan.ApplicationSourceProperty.TagFilters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-applicationsource.html#cfn-autoscalingplans-scalingplan-applicationsource-tagfilters
         * @external
         */
        readonly tagFilters?: Array<CfnScalingPlan.TagFilterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 * @external
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 */
export declare namespace CfnScalingPlan {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html
     * @external
     */
    interface CustomizedLoadMetricSpecificationProperty {
        /**
         * `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Dimensions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-dimensions
         * @external
         */
        readonly dimensions?: Array<CfnScalingPlan.MetricDimensionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.MetricName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-metricname
         * @external
         */
        readonly metricName: string;
        /**
         * `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Namespace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-namespace
         * @external
         */
        readonly namespace: string;
        /**
         * `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Statistic`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-statistic
         * @external
         */
        readonly statistic: string;
        /**
         * `CfnScalingPlan.CustomizedLoadMetricSpecificationProperty.Unit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedloadmetricspecification-unit
         * @external
         */
        readonly unit?: string;
    }
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 * @external
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 */
export declare namespace CfnScalingPlan {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html
     * @external
     */
    interface CustomizedScalingMetricSpecificationProperty {
        /**
         * `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Dimensions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-dimensions
         * @external
         */
        readonly dimensions?: Array<CfnScalingPlan.MetricDimensionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.MetricName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-metricname
         * @external
         */
        readonly metricName: string;
        /**
         * `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Namespace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-namespace
         * @external
         */
        readonly namespace: string;
        /**
         * `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Statistic`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-statistic
         * @external
         */
        readonly statistic: string;
        /**
         * `CfnScalingPlan.CustomizedScalingMetricSpecificationProperty.Unit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-customizedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-customizedscalingmetricspecification-unit
         * @external
         */
        readonly unit?: string;
    }
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 * @external
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 */
export declare namespace CfnScalingPlan {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-metricdimension.html
     * @external
     */
    interface MetricDimensionProperty {
        /**
         * `CfnScalingPlan.MetricDimensionProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-metricdimension.html#cfn-autoscalingplans-scalingplan-metricdimension-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnScalingPlan.MetricDimensionProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-metricdimension.html#cfn-autoscalingplans-scalingplan-metricdimension-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 * @external
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 */
export declare namespace CfnScalingPlan {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedloadmetricspecification.html
     * @external
     */
    interface PredefinedLoadMetricSpecificationProperty {
        /**
         * `CfnScalingPlan.PredefinedLoadMetricSpecificationProperty.PredefinedLoadMetricType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedloadmetricspecification-predefinedloadmetrictype
         * @external
         */
        readonly predefinedLoadMetricType: string;
        /**
         * `CfnScalingPlan.PredefinedLoadMetricSpecificationProperty.ResourceLabel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedloadmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedloadmetricspecification-resourcelabel
         * @external
         */
        readonly resourceLabel?: string;
    }
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 * @external
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 */
export declare namespace CfnScalingPlan {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedscalingmetricspecification.html
     * @external
     */
    interface PredefinedScalingMetricSpecificationProperty {
        /**
         * `CfnScalingPlan.PredefinedScalingMetricSpecificationProperty.PredefinedScalingMetricType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedscalingmetricspecification-predefinedscalingmetrictype
         * @external
         */
        readonly predefinedScalingMetricType: string;
        /**
         * `CfnScalingPlan.PredefinedScalingMetricSpecificationProperty.ResourceLabel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-predefinedscalingmetricspecification.html#cfn-autoscalingplans-scalingplan-predefinedscalingmetricspecification-resourcelabel
         * @external
         */
        readonly resourceLabel?: string;
    }
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 * @external
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 */
export declare namespace CfnScalingPlan {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html
     * @external
     */
    interface ScalingInstructionProperty {
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.CustomizedLoadMetricSpecification`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-customizedloadmetricspecification
         * @external
         */
        readonly customizedLoadMetricSpecification?: CfnScalingPlan.CustomizedLoadMetricSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.DisableDynamicScaling`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-disabledynamicscaling
         * @external
         */
        readonly disableDynamicScaling?: boolean | cdk.IResolvable;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.MaxCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-maxcapacity
         * @external
         */
        readonly maxCapacity: number;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.MinCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-mincapacity
         * @external
         */
        readonly minCapacity: number;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.PredefinedLoadMetricSpecification`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predefinedloadmetricspecification
         * @external
         */
        readonly predefinedLoadMetricSpecification?: CfnScalingPlan.PredefinedLoadMetricSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.PredictiveScalingMaxCapacityBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predictivescalingmaxcapacitybehavior
         * @external
         */
        readonly predictiveScalingMaxCapacityBehavior?: string;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.PredictiveScalingMaxCapacityBuffer`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predictivescalingmaxcapacitybuffer
         * @external
         */
        readonly predictiveScalingMaxCapacityBuffer?: number;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.PredictiveScalingMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-predictivescalingmode
         * @external
         */
        readonly predictiveScalingMode?: string;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.ResourceId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-resourceid
         * @external
         */
        readonly resourceId: string;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.ScalableDimension`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-scalabledimension
         * @external
         */
        readonly scalableDimension: string;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.ScalingPolicyUpdateBehavior`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-scalingpolicyupdatebehavior
         * @external
         */
        readonly scalingPolicyUpdateBehavior?: string;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.ScheduledActionBufferTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-scheduledactionbuffertime
         * @external
         */
        readonly scheduledActionBufferTime?: number;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.ServiceNamespace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-servicenamespace
         * @external
         */
        readonly serviceNamespace: string;
        /**
         * `CfnScalingPlan.ScalingInstructionProperty.TargetTrackingConfigurations`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-scalinginstruction.html#cfn-autoscalingplans-scalingplan-scalinginstruction-targettrackingconfigurations
         * @external
         */
        readonly targetTrackingConfigurations: Array<CfnScalingPlan.TargetTrackingConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 * @external
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 */
export declare namespace CfnScalingPlan {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-tagfilter.html
     * @external
     */
    interface TagFilterProperty {
        /**
         * `CfnScalingPlan.TagFilterProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-tagfilter.html#cfn-autoscalingplans-scalingplan-tagfilter-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnScalingPlan.TagFilterProperty.Values`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-tagfilter.html#cfn-autoscalingplans-scalingplan-tagfilter-values
         * @external
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::AutoScalingPlans::ScalingPlan`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-autoscalingplans-scalingplan.html
 * @external
 * @cloudformationResource AWS::AutoScalingPlans::ScalingPlan
 */
export declare namespace CfnScalingPlan {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html
     * @external
     */
    interface TargetTrackingConfigurationProperty {
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.CustomizedScalingMetricSpecification`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-customizedscalingmetricspecification
         * @external
         */
        readonly customizedScalingMetricSpecification?: CfnScalingPlan.CustomizedScalingMetricSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.DisableScaleIn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-disablescalein
         * @external
         */
        readonly disableScaleIn?: boolean | cdk.IResolvable;
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.EstimatedInstanceWarmup`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-estimatedinstancewarmup
         * @external
         */
        readonly estimatedInstanceWarmup?: number;
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.PredefinedScalingMetricSpecification`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-predefinedscalingmetricspecification
         * @external
         */
        readonly predefinedScalingMetricSpecification?: CfnScalingPlan.PredefinedScalingMetricSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.ScaleInCooldown`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-scaleincooldown
         * @external
         */
        readonly scaleInCooldown?: number;
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.ScaleOutCooldown`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-scaleoutcooldown
         * @external
         */
        readonly scaleOutCooldown?: number;
        /**
         * `CfnScalingPlan.TargetTrackingConfigurationProperty.TargetValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-autoscalingplans-scalingplan-targettrackingconfiguration.html#cfn-autoscalingplans-scalingplan-targettrackingconfiguration-targetvalue
         * @external
         */
        readonly targetValue: number;
    }
}
