# Delphi Python Utilities

This package provides various utilities used by the [Delphi group](https://delphi.cmu.edu/) at [Carnegie Mellon
University](https://www.cmu.edu) for its data pipelines and analyses.

Submodules:
- `archive`: Diffing and archiving CSV files.
- `export`: DataFrame to CSV export.
- `geomap`: Mappings between geographic resolutions.
- `logger`: Structured JSON logger.
- `nancodes`: Enum constants encoding not-a-number cases.
- `runner`: Orchestrator for running an indicator pipeline.
- `signal`: Indicator (signal) naming.
- `slack_notifier`:  Slack notification integration.
- `smooth`: Data smoothing functions.
- `utils`: JSON parameter interactions.
- `validator`: Data sanity checks and anomaly detection.


Source code can be found here: 
[https://github.com/cmu-delphi/covidcast-indicators/](https://github.com/cmu-delphi/covidcast-indicators/)