/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.pgsimple.common.BaseDao;
import org.openstreetmap.osmosis.pgsimple.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsimple.common.NoSuchRecordException;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.ActionDao;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.ActionDataType;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.ChangesetAction;

public class UserDao
extends BaseDao {
    private static final Logger LOG = Logger.getLogger(UserDao.class.getName());
    private static final String SELECT_USER = "SELECT id, name FROM users WHERE id = ?";
    private static final String INSERT_USER = "INSERT INTO users(id, name) VALUES(?, ?)";
    private static final String UPDATE_USER = "UPDATE users SET name = ? WHERE id = ?";
    private PreparedStatement selectUserStatement;
    private PreparedStatement insertUserStatement;
    private PreparedStatement updateUserStatement;
    private ActionDao actionDao;

    public UserDao(DatabaseContext dbCtx, ActionDao actionDao) {
        super(dbCtx);
        this.actionDao = actionDao;
    }

    private OsmUser buildUser(ResultSet resultSet) {
        try {
            return new OsmUser(resultSet.getInt("id"), resultSet.getString("name"));
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to build a user from the current recordset row.", (Throwable)e);
        }
    }

    public OsmUser getUser(long userId) {
        ResultSet resultSet = null;
        if (this.selectUserStatement == null) {
            this.selectUserStatement = this.prepareStatement(SELECT_USER);
        }
        try {
            this.selectUserStatement.setLong(1, userId);
            resultSet = this.selectUserStatement.executeQuery();
            if (!resultSet.next()) {
                throw new NoSuchRecordException("User " + userId + " doesn't exist.");
            }
            OsmUser user = this.buildUser(resultSet);
            resultSet.close();
            resultSet = null;
            OsmUser osmUser = user;
            return osmUser;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Query failed for user " + userId + ".");
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    LOG.log(Level.WARNING, "Unable to close the result set.", e);
                }
            }
        }
    }

    public void addUser(OsmUser user) {
        if (this.insertUserStatement == null) {
            this.insertUserStatement = this.prepareStatement(INSERT_USER);
        }
        int prmIndex = 1;
        try {
            this.insertUserStatement.setInt(prmIndex++, user.getId());
            this.insertUserStatement.setString(prmIndex++, user.getName());
            this.insertUserStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to insert user " + user.getId() + ".", (Throwable)e);
        }
        this.actionDao.addAction(ActionDataType.USER, ChangesetAction.CREATE, user.getId());
    }

    public void updateUser(OsmUser user) {
        if (this.updateUserStatement == null) {
            this.updateUserStatement = this.prepareStatement(UPDATE_USER);
        }
        int prmIndex = 1;
        try {
            this.updateUserStatement.setString(prmIndex++, user.getName());
            this.updateUserStatement.setInt(prmIndex++, user.getId());
            this.updateUserStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to update user " + user.getId() + ".", (Throwable)e);
        }
        this.actionDao.addAction(ActionDataType.USER, ChangesetAction.MODIFY, user.getId());
    }
}

