/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.sort.v0_6;

import java.util.Comparator;
import java.util.Map;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.sort.common.FileBasedSort;
import org.openstreetmap.osmosis.core.store.SingleClassObjectSerializationFactory;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSinkChangeSource;

public class ChangeSorter
implements ChangeSinkChangeSource {
    private FileBasedSort<ChangeContainer> fileBasedSort;
    private ChangeSink changeSink;

    public ChangeSorter(Comparator<ChangeContainer> comparator) {
        this.fileBasedSort = new FileBasedSort<ChangeContainer>(new SingleClassObjectSerializationFactory(ChangeContainer.class), comparator, true);
    }

    @Override
    public void initialize(Map<String, Object> metaData) {
        this.changeSink.initialize(metaData);
    }

    @Override
    public void process(ChangeContainer change) {
        this.fileBasedSort.add(change);
    }

    @Override
    public void setChangeSink(ChangeSink changeSink) {
        this.changeSink = changeSink;
    }

    @Override
    public void complete() {
        try (ReleasableIterator<ChangeContainer> iterator = this.fileBasedSort.iterate();){
            while (iterator.hasNext()) {
                this.changeSink.process((ChangeContainer)iterator.next());
            }
            this.changeSink.complete();
        }
    }

    @Override
    public void close() {
        this.fileBasedSort.close();
        this.changeSink.close();
    }
}

