/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.List;
import org.openstreetmap.osmosis.apidb.common.DatabaseContext;
import org.openstreetmap.osmosis.apidb.v0_6.impl.ChangesetManager;
import org.openstreetmap.osmosis.apidb.v0_6.impl.MemberTypeRenderer;
import org.openstreetmap.osmosis.apidb.v0_6.impl.UserManager;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.ReleasableStatementContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.lifecycle.Completable;
import org.openstreetmap.osmosis.core.task.common.ChangeAction;
import org.openstreetmap.osmosis.core.util.FixedPrecisionCoordinateConvertor;
import org.openstreetmap.osmosis.core.util.TileCalculator;

public class ChangeWriter
implements Completable {
    private static final String INSERT_SQL_NODE = "INSERT INTO nodes (node_id, version, timestamp, visible, changeset_id, latitude, longitude, tile) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_SQL_NODE = "UPDATE nodes SET timestamp = ?, visible = ?, changeset_id = ?, latitude = ?, longitude = ?, tile = ? WHERE node_id = ? AND version = ?";
    private static final String SELECT_SQL_NODE_COUNT = "SELECT Count(node_id) AS rowCount FROM nodes WHERE node_id = ? AND version = ?";
    private static final String INSERT_SQL_NODE_CURRENT = "INSERT INTO current_nodes (id, version, timestamp, visible, changeset_id, latitude, longitude, tile) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE_SQL_NODE_CURRENT = "UPDATE current_nodes SET version = ?, timestamp = ?, visible = ?, changeset_id = ?, latitude = ?, longitude = ?, tile = ? WHERE id = ?";
    private static final String SELECT_SQL_NODE_CURRENT_COUNT = "SELECT Count(id) AS rowCount FROM current_nodes WHERE id = ?";
    private static final String INSERT_SQL_NODE_TAG = "INSERT INTO node_tags (node_id, version, k, v) VALUES (?, ?, ?, ?)";
    private static final String DELETE_SQL_NODE_TAG = "DELETE FROM node_tags WHERE node_id = ? AND version = ?";
    private static final String INSERT_SQL_NODE_TAG_CURRENT = "INSERT INTO current_node_tags (node_id, k, v) VALUES (?, ?, ?)";
    private static final String DELETE_SQL_NODE_TAG_CURRENT = "DELETE FROM current_node_tags WHERE node_id = ?";
    private static final String INSERT_SQL_WAY = "INSERT INTO ways (way_id, version, timestamp, visible, changeset_id) VALUES (?, ?, ?, ?, ?)";
    private static final String UPDATE_SQL_WAY = "UPDATE ways SET timestamp = ?, visible = ?, changeset_id = ? WHERE way_id = ? AND version = ?";
    private static final String SELECT_SQL_WAY_COUNT = "SELECT Count(way_id) AS rowCount FROM ways WHERE way_id = ? AND version = ?";
    private static final String INSERT_SQL_WAY_CURRENT = "INSERT INTO current_ways (id, version, timestamp, visible, changeset_id) VALUES (?, ?, ?, ?, ?)";
    private static final String UPDATE_SQL_WAY_CURRENT = "UPDATE current_ways SET version = ?, timestamp = ?, visible = ?, changeset_id = ? WHERE id = ?";
    private static final String SELECT_SQL_WAY_CURRENT_COUNT = "SELECT Count(id) AS rowCount FROM current_ways WHERE id = ?";
    private static final String INSERT_SQL_WAY_TAG = "INSERT INTO way_tags (way_id, version, k, v) VALUES (?, ?, ?, ?)";
    private static final String DELETE_SQL_WAY_TAG = "DELETE FROM way_tags WHERE way_id = ? AND version = ?";
    private static final String INSERT_SQL_WAY_TAG_CURRENT = "INSERT INTO current_way_tags (way_id, k, v) VALUES (?, ?, ?)";
    private static final String DELETE_SQL_WAY_TAG_CURRENT = "DELETE FROM current_way_tags WHERE way_id = ?";
    private static final String INSERT_SQL_WAY_NODE = "INSERT INTO way_nodes (way_id, version, node_id, sequence_id) VALUES (?, ?, ?, ?)";
    private static final String DELETE_SQL_WAY_NODE = "DELETE FROM way_nodes WHERE way_id = ? AND version = ?";
    private static final String INSERT_SQL_WAY_NODE_CURRENT = "INSERT INTO current_way_nodes (way_id, node_id, sequence_id) VALUES (?, ?, ?)";
    private static final String DELETE_SQL_WAY_NODE_CURRENT = "DELETE FROM current_way_nodes WHERE way_id = ?";
    private static final String INSERT_SQL_RELATION = "INSERT INTO relations (relation_id, version, timestamp, visible, changeset_id) VALUES (?, ?, ?, ?, ?)";
    private static final String UPDATE_SQL_RELATION = "UPDATE relations SET timestamp = ?, visible = ?, changeset_id = ? WHERE relation_id = ? AND version = ?";
    private static final String SELECT_SQL_RELATION_COUNT = "SELECT Count(id) AS rowCount FROM current_relations WHERE id = ? AND version = ?";
    private static final String INSERT_SQL_RELATION_CURRENT = "INSERT INTO current_relations (id, version, timestamp, visible, changeset_id) VALUES (?, ?, ?, ?, ?)";
    private static final String UPDATE_SQL_RELATION_CURRENT = "UPDATE current_relations SET version = ?, timestamp = ?, visible = ?, changeset_id = ? WHERE id = ?";
    private static final String SELECT_SQL_RELATION_CURRENT_COUNT = "SELECT Count(id) AS rowCount FROM current_relations WHERE id = ?";
    private static final String INSERT_SQL_RELATION_TAG = "INSERT INTO relation_tags (relation_id, version, k, v) VALUES (?, ?, ?, ?)";
    private static final String DELETE_SQL_RELATION_TAG = "DELETE FROM relation_tags WHERE relation_id = ? AND version = ?";
    private static final String INSERT_SQL_RELATION_TAG_CURRENT = "INSERT INTO current_relation_tags (relation_id, k, v) VALUES (?, ?, ?)";
    private static final String DELETE_SQL_RELATION_TAG_CURRENT = "DELETE FROM current_relation_tags WHERE relation_id = ?";
    private static final String INSERT_SQL_RELATION_MEMBER_MYSQL = "INSERT INTO relation_members (relation_id, version, member_type, member_id, member_role, sequence_id) VALUES (?, ?, ?, ?, ?, ?)";
    private static final String INSERT_SQL_RELATION_MEMBER_PGSQL = "INSERT INTO relation_members (relation_id, version, member_type, member_id, member_role, sequence_id) VALUES (?, ?, ?::nwr_enum, ?, ?, ?)";
    private static final String DELETE_SQL_RELATION_MEMBER = "DELETE FROM relation_members WHERE relation_id = ? AND version = ?";
    private static final String INSERT_SQL_RELATION_MEMBER_CURRENT_MYSQL = "INSERT INTO current_relation_members (relation_id, member_type, member_id, member_role, sequence_id) VALUES (?, ?, ?, ?, ?)";
    private static final String INSERT_SQL_RELATION_MEMBER_CURRENT_PGSQL = "INSERT INTO current_relation_members (relation_id, member_type, member_id, member_role, sequence_id) VALUES (?, ?::nwr_enum, ?, ?, ?)";
    private static final String DELETE_SQL_RELATION_MEMBER_CURRENT = "DELETE FROM current_relation_members WHERE relation_id = ?";
    private final DatabaseContext dbCtx;
    private final UserManager userManager;
    private final ChangesetManager changesetManager;
    private final boolean populateCurrentTables;
    private final ReleasableStatementContainer statementContainer;
    private PreparedStatement insertNodeStatement;
    private PreparedStatement updateNodeStatement;
    private PreparedStatement selectNodeCountStatement;
    private PreparedStatement insertNodeCurrentStatement;
    private PreparedStatement updateNodeCurrentStatement;
    private PreparedStatement selectNodeCurrentCountStatement;
    private PreparedStatement insertNodeTagStatement;
    private PreparedStatement deleteNodeTagStatement;
    private PreparedStatement insertNodeTagCurrentStatement;
    private PreparedStatement deleteNodeTagCurrentStatement;
    private PreparedStatement insertWayStatement;
    private PreparedStatement updateWayStatement;
    private PreparedStatement selectWayCountStatement;
    private PreparedStatement insertWayCurrentStatement;
    private PreparedStatement updateWayCurrentStatement;
    private PreparedStatement selectWayCurrentCountStatement;
    private PreparedStatement insertWayTagStatement;
    private PreparedStatement deleteWayTagStatement;
    private PreparedStatement insertWayTagCurrentStatement;
    private PreparedStatement deleteWayTagCurrentStatement;
    private PreparedStatement insertWayNodeStatement;
    private PreparedStatement deleteWayNodeStatement;
    private PreparedStatement insertWayNodeCurrentStatement;
    private PreparedStatement deleteWayNodeCurrentStatement;
    private PreparedStatement insertRelationStatement;
    private PreparedStatement updateRelationStatement;
    private PreparedStatement selectRelationCountStatement;
    private PreparedStatement insertRelationCurrentStatement;
    private PreparedStatement updateRelationCurrentStatement;
    private PreparedStatement selectRelationCurrentCountStatement;
    private PreparedStatement insertRelationTagStatement;
    private PreparedStatement deleteRelationTagStatement;
    private PreparedStatement insertRelationTagCurrentStatement;
    private PreparedStatement deleteRelationTagCurrentStatement;
    private PreparedStatement insertRelationMemberStatement;
    private PreparedStatement deleteRelationMemberStatement;
    private PreparedStatement insertRelationMemberCurrentStatement;
    private PreparedStatement deleteRelationMemberCurrentStatement;
    private final MemberTypeRenderer memberTypeRenderer;
    private final TileCalculator tileCalculator;

    public ChangeWriter(DatabaseLoginCredentials loginCredentials, boolean populateCurrentTables) {
        this.dbCtx = new DatabaseContext(loginCredentials);
        this.statementContainer = new ReleasableStatementContainer();
        this.userManager = new UserManager(this.dbCtx);
        this.changesetManager = new ChangesetManager(this.dbCtx);
        this.populateCurrentTables = populateCurrentTables;
        this.tileCalculator = new TileCalculator();
        this.memberTypeRenderer = new MemberTypeRenderer();
    }

    private boolean checkIfEntityExists(PreparedStatement statement, long id) throws SQLException {
        statement.setLong(1, id);
        try (ResultSet resultSet = statement.executeQuery();){
            resultSet.next();
            boolean bl = resultSet.getInt("rowCount") != 0;
            return bl;
        }
    }

    private boolean checkIfEntityHistoryExists(PreparedStatement statement, long id, int version) throws SQLException {
        int prmIndex = 1;
        statement.setLong(prmIndex++, id);
        statement.setInt(prmIndex++, version);
        try (ResultSet resultSet = statement.executeQuery();){
            resultSet.next();
            boolean bl = resultSet.getInt("rowCount") != 0;
            return bl;
        }
    }

    private void assertEntityHasTimestamp(Entity entity) {
        if (entity.getTimestamp() == null) {
            throw new OsmosisRuntimeException(entity.getType().toString() + " " + entity.getId() + " does not have a timestamp set.");
        }
    }

    public void write(Node node, ChangeAction action) {
        boolean exists;
        int prmIndex;
        boolean visible;
        this.assertEntityHasTimestamp((Entity)node);
        this.userManager.addOrUpdateUser(node.getUser());
        this.changesetManager.addChangesetIfRequired(node.getChangesetId(), node.getUser());
        boolean bl = visible = !action.equals((Object)ChangeAction.Delete);
        if (this.insertNodeStatement == null) {
            this.insertNodeStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(INSERT_SQL_NODE));
            this.updateNodeStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(UPDATE_SQL_NODE));
            this.selectNodeCountStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(SELECT_SQL_NODE_COUNT));
            this.insertNodeCurrentStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(INSERT_SQL_NODE_CURRENT));
            this.updateNodeCurrentStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(UPDATE_SQL_NODE_CURRENT));
            this.selectNodeCurrentCountStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(SELECT_SQL_NODE_CURRENT_COUNT));
            this.insertNodeTagStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(INSERT_SQL_NODE_TAG));
            this.deleteNodeTagStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(DELETE_SQL_NODE_TAG));
            this.insertNodeTagCurrentStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(INSERT_SQL_NODE_TAG_CURRENT));
            this.deleteNodeTagCurrentStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(DELETE_SQL_NODE_TAG_CURRENT));
        }
        try {
            prmIndex = 1;
            this.deleteNodeTagStatement.setLong(prmIndex++, node.getId());
            this.deleteNodeTagStatement.setInt(prmIndex++, node.getVersion());
            this.deleteNodeTagStatement.execute();
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to delete node history tags for node with id=" + node.getId() + ".", (Throwable)e);
        }
        try {
            exists = this.checkIfEntityHistoryExists(this.selectNodeCountStatement, node.getId(), node.getVersion());
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to check if current node with id=" + node.getId() + " exists.", (Throwable)e);
        }
        if (exists) {
            try {
                prmIndex = 1;
                this.updateNodeStatement.setTimestamp(prmIndex++, new Timestamp(node.getTimestamp().getTime()));
                this.updateNodeStatement.setBoolean(prmIndex++, visible);
                this.updateNodeStatement.setLong(prmIndex++, node.getChangesetId());
                this.updateNodeStatement.setInt(prmIndex++, FixedPrecisionCoordinateConvertor.convertToFixed((double)node.getLatitude()));
                this.updateNodeStatement.setInt(prmIndex++, FixedPrecisionCoordinateConvertor.convertToFixed((double)node.getLongitude()));
                this.updateNodeStatement.setLong(prmIndex++, this.tileCalculator.calculateTile(node.getLatitude(), node.getLongitude()));
                this.updateNodeStatement.setLong(prmIndex++, node.getId());
                this.updateNodeStatement.setInt(prmIndex++, node.getVersion());
                this.updateNodeStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to update history node with id=" + node.getId() + ".", (Throwable)e);
            }
        }
        try {
            prmIndex = 1;
            this.insertNodeStatement.setLong(prmIndex++, node.getId());
            this.insertNodeStatement.setInt(prmIndex++, node.getVersion());
            this.insertNodeStatement.setTimestamp(prmIndex++, new Timestamp(node.getTimestamp().getTime()));
            this.insertNodeStatement.setBoolean(prmIndex++, visible);
            this.insertNodeStatement.setLong(prmIndex++, node.getChangesetId());
            this.insertNodeStatement.setInt(prmIndex++, FixedPrecisionCoordinateConvertor.convertToFixed((double)node.getLatitude()));
            this.insertNodeStatement.setInt(prmIndex++, FixedPrecisionCoordinateConvertor.convertToFixed((double)node.getLongitude()));
            this.insertNodeStatement.setLong(prmIndex++, this.tileCalculator.calculateTile(node.getLatitude(), node.getLongitude()));
            this.insertNodeStatement.execute();
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to insert history node with id=" + node.getId() + ".", (Throwable)e);
        }
        for (Tag tag : node.getTags()) {
            try {
                prmIndex = 1;
                this.insertNodeTagStatement.setLong(prmIndex++, node.getId());
                this.insertNodeTagStatement.setInt(prmIndex++, node.getVersion());
                this.insertNodeTagStatement.setString(prmIndex++, tag.getKey());
                this.insertNodeTagStatement.setString(prmIndex++, tag.getValue());
                this.insertNodeTagStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to insert history node tag with id=" + node.getId() + " and key=(" + tag.getKey() + ").", (Throwable)e);
            }
        }
        if (this.populateCurrentTables) {
            try {
                this.deleteNodeTagCurrentStatement.setLong(1, node.getId());
                this.deleteNodeTagCurrentStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to delete current node tags with id=" + node.getId() + ".", (Throwable)e);
            }
            try {
                exists = this.checkIfEntityExists(this.selectNodeCurrentCountStatement, node.getId());
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to check if current node with id=" + node.getId() + " exists.", (Throwable)e);
            }
            if (exists) {
                try {
                    prmIndex = 1;
                    this.updateNodeCurrentStatement.setInt(prmIndex++, node.getVersion());
                    this.updateNodeCurrentStatement.setTimestamp(prmIndex++, new Timestamp(node.getTimestamp().getTime()));
                    this.updateNodeCurrentStatement.setBoolean(prmIndex++, visible);
                    this.updateNodeCurrentStatement.setLong(prmIndex++, node.getChangesetId());
                    this.updateNodeCurrentStatement.setInt(prmIndex++, FixedPrecisionCoordinateConvertor.convertToFixed((double)node.getLatitude()));
                    this.updateNodeCurrentStatement.setInt(prmIndex++, FixedPrecisionCoordinateConvertor.convertToFixed((double)node.getLongitude()));
                    this.updateNodeCurrentStatement.setLong(prmIndex++, this.tileCalculator.calculateTile(node.getLatitude(), node.getLongitude()));
                    this.updateNodeCurrentStatement.setLong(prmIndex++, node.getId());
                    this.updateNodeCurrentStatement.execute();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to update current node with id=" + node.getId() + ".", (Throwable)e);
                }
            }
            try {
                prmIndex = 1;
                this.insertNodeCurrentStatement.setLong(prmIndex++, node.getId());
                this.insertNodeCurrentStatement.setInt(prmIndex++, node.getVersion());
                this.insertNodeCurrentStatement.setTimestamp(prmIndex++, new Timestamp(node.getTimestamp().getTime()));
                this.insertNodeCurrentStatement.setBoolean(prmIndex++, visible);
                this.insertNodeCurrentStatement.setLong(prmIndex++, node.getChangesetId());
                this.insertNodeCurrentStatement.setInt(prmIndex++, FixedPrecisionCoordinateConvertor.convertToFixed((double)node.getLatitude()));
                this.insertNodeCurrentStatement.setInt(prmIndex++, FixedPrecisionCoordinateConvertor.convertToFixed((double)node.getLongitude()));
                this.insertNodeCurrentStatement.setLong(prmIndex++, this.tileCalculator.calculateTile(node.getLatitude(), node.getLongitude()));
                this.insertNodeCurrentStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to insert current node with id=" + node.getId() + ".", (Throwable)e);
            }
            for (Tag tag : node.getTags()) {
                try {
                    prmIndex = 1;
                    this.insertNodeTagCurrentStatement.setLong(prmIndex++, node.getId());
                    this.insertNodeTagCurrentStatement.setString(prmIndex++, tag.getKey());
                    this.insertNodeTagCurrentStatement.setString(prmIndex++, tag.getValue());
                    this.insertNodeTagCurrentStatement.execute();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert current node tag with id=" + node.getId() + " and key=(" + tag.getKey() + ").", (Throwable)e);
                }
            }
        }
    }

    public void write(Way way, ChangeAction action) {
        WayNode nodeReference;
        boolean exists;
        int prmIndex;
        boolean visible;
        this.assertEntityHasTimestamp((Entity)way);
        this.userManager.addOrUpdateUser(way.getUser());
        this.changesetManager.addChangesetIfRequired(way.getChangesetId(), way.getUser());
        List nodeReferenceList = way.getWayNodes();
        boolean bl = visible = !action.equals((Object)ChangeAction.Delete);
        if (this.insertWayStatement == null) {
            this.insertWayStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(INSERT_SQL_WAY));
            this.updateWayStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(UPDATE_SQL_WAY));
            this.selectWayCountStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(SELECT_SQL_WAY_COUNT));
            this.insertWayCurrentStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(INSERT_SQL_WAY_CURRENT));
            this.updateWayCurrentStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(UPDATE_SQL_WAY_CURRENT));
            this.selectWayCurrentCountStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(SELECT_SQL_WAY_CURRENT_COUNT));
            this.insertWayTagStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(INSERT_SQL_WAY_TAG));
            this.deleteWayTagStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(DELETE_SQL_WAY_TAG));
            this.insertWayTagCurrentStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(INSERT_SQL_WAY_TAG_CURRENT));
            this.deleteWayTagCurrentStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(DELETE_SQL_WAY_TAG_CURRENT));
            this.insertWayNodeStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(INSERT_SQL_WAY_NODE));
            this.deleteWayNodeStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(DELETE_SQL_WAY_NODE));
            this.insertWayNodeCurrentStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(INSERT_SQL_WAY_NODE_CURRENT));
            this.deleteWayNodeCurrentStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(DELETE_SQL_WAY_NODE_CURRENT));
        }
        try {
            prmIndex = 1;
            this.deleteWayTagStatement.setLong(prmIndex++, way.getId());
            this.deleteWayTagStatement.setInt(prmIndex++, way.getVersion());
            this.deleteWayTagStatement.execute();
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to delete way history tags for way with id=" + way.getId() + ".", (Throwable)e);
        }
        try {
            prmIndex = 1;
            this.deleteWayNodeStatement.setLong(prmIndex++, way.getId());
            this.deleteWayNodeStatement.setInt(prmIndex++, way.getVersion());
            this.deleteWayNodeStatement.execute();
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to delete way history nodes for way with id=" + way.getId() + ".", (Throwable)e);
        }
        try {
            exists = this.checkIfEntityHistoryExists(this.selectWayCountStatement, way.getId(), way.getVersion());
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to check if current way with id=" + way.getId() + " exists.", (Throwable)e);
        }
        if (exists) {
            try {
                prmIndex = 1;
                this.updateWayStatement.setTimestamp(prmIndex++, new Timestamp(way.getTimestamp().getTime()));
                this.updateWayStatement.setBoolean(prmIndex++, visible);
                this.updateWayStatement.setLong(prmIndex++, way.getChangesetId());
                this.updateWayStatement.setLong(prmIndex++, way.getId());
                this.updateWayStatement.setInt(prmIndex++, way.getVersion());
                this.updateWayStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to update history way with id=" + way.getId() + ".", (Throwable)e);
            }
        }
        try {
            prmIndex = 1;
            this.insertWayStatement.setLong(prmIndex++, way.getId());
            this.insertWayStatement.setInt(prmIndex++, way.getVersion());
            this.insertWayStatement.setTimestamp(prmIndex++, new Timestamp(way.getTimestamp().getTime()));
            this.insertWayStatement.setBoolean(prmIndex++, visible);
            this.insertWayStatement.setLong(prmIndex++, way.getChangesetId());
            this.insertWayStatement.execute();
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to insert history way with id=" + way.getId() + ".", (Throwable)e);
        }
        for (Tag tag : way.getTags()) {
            try {
                prmIndex = 1;
                this.insertWayTagStatement.setLong(prmIndex++, way.getId());
                this.insertWayTagStatement.setInt(prmIndex++, way.getVersion());
                this.insertWayTagStatement.setString(prmIndex++, tag.getKey());
                this.insertWayTagStatement.setString(prmIndex++, tag.getValue());
                this.insertWayTagStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to insert history way tag with id=" + way.getId() + " and key=(" + tag.getKey() + ").", (Throwable)e);
            }
        }
        for (int i = 0; i < nodeReferenceList.size(); ++i) {
            nodeReference = (WayNode)nodeReferenceList.get(i);
            try {
                prmIndex = 1;
                this.insertWayNodeStatement.setLong(prmIndex++, way.getId());
                this.insertWayNodeStatement.setInt(prmIndex++, way.getVersion());
                this.insertWayNodeStatement.setLong(prmIndex++, nodeReference.getNodeId());
                this.insertWayNodeStatement.setLong(prmIndex++, i + 1);
                this.insertWayNodeStatement.execute();
                continue;
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to insert history way node with way id=" + way.getId() + " and node id=" + nodeReference.getNodeId() + ".", (Throwable)e);
            }
        }
        if (this.populateCurrentTables) {
            try {
                this.deleteWayTagCurrentStatement.setLong(1, way.getId());
                this.deleteWayTagCurrentStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to delete current way tags with id=" + way.getId() + ".", (Throwable)e);
            }
            try {
                this.deleteWayNodeCurrentStatement.setLong(1, way.getId());
                this.deleteWayNodeCurrentStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to delete current way nodes with id=" + way.getId() + ".", (Throwable)e);
            }
            try {
                exists = this.checkIfEntityExists(this.selectWayCurrentCountStatement, way.getId());
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to check if current way with id=" + way.getId() + " exists.", (Throwable)e);
            }
            if (exists) {
                try {
                    prmIndex = 1;
                    this.updateWayCurrentStatement.setInt(prmIndex++, way.getVersion());
                    this.updateWayCurrentStatement.setTimestamp(prmIndex++, new Timestamp(way.getTimestamp().getTime()));
                    this.updateWayCurrentStatement.setBoolean(prmIndex++, visible);
                    this.updateWayCurrentStatement.setLong(prmIndex++, way.getChangesetId());
                    this.updateWayCurrentStatement.setLong(prmIndex++, way.getId());
                    this.updateWayCurrentStatement.execute();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to update current way with id=" + way.getId() + ".", (Throwable)e);
                }
            }
            try {
                prmIndex = 1;
                this.insertWayCurrentStatement.setLong(prmIndex++, way.getId());
                this.insertWayCurrentStatement.setInt(prmIndex++, way.getVersion());
                this.insertWayCurrentStatement.setTimestamp(prmIndex++, new Timestamp(way.getTimestamp().getTime()));
                this.insertWayCurrentStatement.setBoolean(prmIndex++, visible);
                this.insertWayCurrentStatement.setLong(prmIndex++, way.getChangesetId());
                this.insertWayCurrentStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to insert current way with id=" + way.getId() + ".", (Throwable)e);
            }
            for (Tag tag : way.getTags()) {
                try {
                    prmIndex = 1;
                    this.insertWayTagCurrentStatement.setLong(prmIndex++, way.getId());
                    this.insertWayTagCurrentStatement.setString(prmIndex++, tag.getKey());
                    this.insertWayTagCurrentStatement.setString(prmIndex++, tag.getValue());
                    this.insertWayTagCurrentStatement.execute();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert current way tag with id=" + way.getId() + " and key=(" + tag.getKey() + ").", (Throwable)e);
                }
            }
            for (int i = 0; i < nodeReferenceList.size(); ++i) {
                nodeReference = (WayNode)nodeReferenceList.get(i);
                try {
                    prmIndex = 1;
                    this.insertWayNodeCurrentStatement.setLong(prmIndex++, way.getId());
                    this.insertWayNodeCurrentStatement.setLong(prmIndex++, nodeReference.getNodeId());
                    this.insertWayNodeCurrentStatement.setLong(prmIndex++, i);
                    this.insertWayNodeCurrentStatement.execute();
                    continue;
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert current way node with way id=" + way.getId() + " and node id=" + nodeReference.getNodeId() + ".", (Throwable)e);
                }
            }
        }
    }

    public void write(Relation relation, ChangeAction action) {
        RelationMember relationMember;
        boolean exists;
        int prmIndex;
        boolean visible;
        this.assertEntityHasTimestamp((Entity)relation);
        this.userManager.addOrUpdateUser(relation.getUser());
        this.changesetManager.addChangesetIfRequired(relation.getChangesetId(), relation.getUser());
        List relationMemberList = relation.getMembers();
        boolean bl = visible = !action.equals((Object)ChangeAction.Delete);
        if (this.insertRelationStatement == null) {
            this.insertRelationStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(INSERT_SQL_RELATION));
            this.updateRelationStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(UPDATE_SQL_RELATION));
            this.selectRelationCountStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(SELECT_SQL_RELATION_COUNT));
            this.insertRelationCurrentStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(INSERT_SQL_RELATION_CURRENT));
            this.updateRelationCurrentStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(UPDATE_SQL_RELATION_CURRENT));
            this.selectRelationCurrentCountStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(SELECT_SQL_RELATION_CURRENT_COUNT));
            this.insertRelationTagStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(INSERT_SQL_RELATION_TAG));
            this.deleteRelationTagStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(DELETE_SQL_RELATION_TAG));
            this.insertRelationTagCurrentStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(INSERT_SQL_RELATION_TAG_CURRENT));
            this.deleteRelationTagCurrentStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(DELETE_SQL_RELATION_TAG_CURRENT));
            switch (this.dbCtx.getDatabaseType()) {
                case POSTGRESQL: {
                    this.insertRelationMemberStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(INSERT_SQL_RELATION_MEMBER_PGSQL));
                    break;
                }
                case MYSQL: {
                    this.insertRelationMemberStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(INSERT_SQL_RELATION_MEMBER_MYSQL));
                    break;
                }
                default: {
                    throw new OsmosisRuntimeException("Unknown database type " + this.dbCtx.getDatabaseType() + ".");
                }
            }
            this.deleteRelationMemberStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(DELETE_SQL_RELATION_MEMBER));
            switch (this.dbCtx.getDatabaseType()) {
                case POSTGRESQL: {
                    this.insertRelationMemberCurrentStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(INSERT_SQL_RELATION_MEMBER_CURRENT_PGSQL));
                    break;
                }
                case MYSQL: {
                    this.insertRelationMemberCurrentStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(INSERT_SQL_RELATION_MEMBER_CURRENT_MYSQL));
                    break;
                }
                default: {
                    throw new OsmosisRuntimeException("Unknown database type " + this.dbCtx.getDatabaseType() + ".");
                }
            }
            this.deleteRelationMemberCurrentStatement = (PreparedStatement)this.statementContainer.add((Statement)this.dbCtx.prepareStatement(DELETE_SQL_RELATION_MEMBER_CURRENT));
        }
        try {
            prmIndex = 1;
            this.deleteRelationTagStatement.setLong(prmIndex++, relation.getId());
            this.deleteRelationTagStatement.setInt(prmIndex++, relation.getVersion());
            this.deleteRelationTagStatement.execute();
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to delete relation history tags for relation with id=" + relation.getId() + ".", (Throwable)e);
        }
        try {
            prmIndex = 1;
            this.deleteRelationMemberStatement.setLong(prmIndex++, relation.getId());
            this.deleteRelationMemberStatement.setInt(prmIndex++, relation.getVersion());
            this.deleteRelationMemberStatement.execute();
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to delete relation history members for relation with id=" + relation.getId() + ".", (Throwable)e);
        }
        try {
            exists = this.checkIfEntityHistoryExists(this.selectRelationCountStatement, relation.getId(), relation.getVersion());
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to check if current relation with id=" + relation.getId() + " exists.", (Throwable)e);
        }
        if (exists) {
            try {
                prmIndex = 1;
                this.updateRelationStatement.setTimestamp(prmIndex++, new Timestamp(relation.getTimestamp().getTime()));
                this.updateRelationStatement.setBoolean(prmIndex++, visible);
                this.updateRelationStatement.setLong(prmIndex++, relation.getChangesetId());
                this.updateRelationStatement.setLong(prmIndex++, relation.getId());
                this.updateRelationStatement.setInt(prmIndex++, relation.getVersion());
                this.updateRelationStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to update history relation with id=" + relation.getId() + ".", (Throwable)e);
            }
        }
        try {
            prmIndex = 1;
            this.insertRelationStatement.setLong(prmIndex++, relation.getId());
            this.insertRelationStatement.setInt(prmIndex++, relation.getVersion());
            this.insertRelationStatement.setTimestamp(prmIndex++, new Timestamp(relation.getTimestamp().getTime()));
            this.insertRelationStatement.setBoolean(prmIndex++, visible);
            this.insertRelationStatement.setLong(prmIndex++, relation.getChangesetId());
            this.insertRelationStatement.execute();
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to insert history relation with id=" + relation.getId() + ".", (Throwable)e);
        }
        for (Tag tag : relation.getTags()) {
            try {
                prmIndex = 1;
                this.insertRelationTagStatement.setLong(prmIndex++, relation.getId());
                this.insertRelationTagStatement.setInt(prmIndex++, relation.getVersion());
                this.insertRelationTagStatement.setString(prmIndex++, tag.getKey());
                this.insertRelationTagStatement.setString(prmIndex++, tag.getValue());
                this.insertRelationTagStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to insert history relation tag with id=" + relation.getId() + " and key=(" + tag.getKey() + ").", (Throwable)e);
            }
        }
        for (int i = 0; i < relationMemberList.size(); ++i) {
            relationMember = (RelationMember)relationMemberList.get(i);
            try {
                prmIndex = 1;
                this.insertRelationMemberStatement.setLong(prmIndex++, relation.getId());
                this.insertRelationMemberStatement.setInt(prmIndex++, relation.getVersion());
                this.insertRelationMemberStatement.setString(prmIndex++, this.memberTypeRenderer.render(relationMember.getMemberType()));
                this.insertRelationMemberStatement.setLong(prmIndex++, relationMember.getMemberId());
                this.insertRelationMemberStatement.setString(prmIndex++, relationMember.getMemberRole());
                this.insertRelationMemberStatement.setInt(prmIndex++, i + 1);
                this.insertRelationMemberStatement.execute();
                continue;
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to insert history relation member with relation id=" + relation.getId() + ", member type=" + relationMember.getMemberId() + " and member id=" + relationMember.getMemberId() + ".", (Throwable)e);
            }
        }
        if (this.populateCurrentTables) {
            try {
                this.deleteRelationTagCurrentStatement.setLong(1, relation.getId());
                this.deleteRelationTagCurrentStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to delete current relation tags with id=" + relation.getId() + ".", (Throwable)e);
            }
            try {
                this.deleteRelationMemberCurrentStatement.setLong(1, relation.getId());
                this.deleteRelationMemberCurrentStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to delete current relation members with id=" + relation.getId() + ".", (Throwable)e);
            }
            try {
                exists = this.checkIfEntityExists(this.selectRelationCurrentCountStatement, relation.getId());
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to check if current relation with id=" + relation.getId() + " exists.", (Throwable)e);
            }
            if (exists) {
                try {
                    prmIndex = 1;
                    this.updateRelationCurrentStatement.setInt(prmIndex++, relation.getVersion());
                    this.updateRelationCurrentStatement.setTimestamp(prmIndex++, new Timestamp(relation.getTimestamp().getTime()));
                    this.updateRelationCurrentStatement.setBoolean(prmIndex++, visible);
                    this.updateRelationCurrentStatement.setLong(prmIndex++, relation.getChangesetId());
                    this.updateRelationCurrentStatement.setLong(prmIndex++, relation.getId());
                    this.updateRelationCurrentStatement.execute();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to update current relation with id=" + relation.getId() + ".", (Throwable)e);
                }
            }
            try {
                prmIndex = 1;
                this.insertRelationCurrentStatement.setLong(prmIndex++, relation.getId());
                this.insertRelationCurrentStatement.setInt(prmIndex++, relation.getVersion());
                this.insertRelationCurrentStatement.setTimestamp(prmIndex++, new Timestamp(relation.getTimestamp().getTime()));
                this.insertRelationCurrentStatement.setBoolean(prmIndex++, visible);
                this.insertRelationCurrentStatement.setLong(prmIndex++, relation.getChangesetId());
                this.insertRelationCurrentStatement.execute();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to insert current relation with id=" + relation.getId() + ".", (Throwable)e);
            }
            for (Tag tag : relation.getTags()) {
                try {
                    prmIndex = 1;
                    this.insertRelationTagCurrentStatement.setLong(prmIndex++, relation.getId());
                    this.insertRelationTagCurrentStatement.setString(prmIndex++, tag.getKey());
                    this.insertRelationTagCurrentStatement.setString(prmIndex++, tag.getValue());
                    this.insertRelationTagCurrentStatement.execute();
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert current relation tag with id=" + relation.getId() + " and key=(" + tag.getKey() + ").", (Throwable)e);
                }
            }
            for (int i = 0; i < relationMemberList.size(); ++i) {
                relationMember = (RelationMember)relationMemberList.get(i);
                try {
                    prmIndex = 1;
                    this.insertRelationMemberCurrentStatement.setLong(prmIndex++, relation.getId());
                    this.insertRelationMemberCurrentStatement.setString(prmIndex++, this.memberTypeRenderer.render(relationMember.getMemberType()));
                    this.insertRelationMemberCurrentStatement.setLong(prmIndex++, relationMember.getMemberId());
                    this.insertRelationMemberCurrentStatement.setString(prmIndex++, relationMember.getMemberRole());
                    this.insertRelationMemberCurrentStatement.setInt(prmIndex++, i + 1);
                    this.insertRelationMemberCurrentStatement.execute();
                    continue;
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to insert current relation member with relation id=" + relation.getId() + ", member type=" + relationMember.getMemberId() + " and member id=" + relationMember.getMemberId() + ".", (Throwable)e);
                }
            }
        }
    }

    public void complete() {
        this.dbCtx.commit();
    }

    public void close() {
        this.statementContainer.close();
        this.userManager.close();
        this.changesetManager.close();
        this.dbCtx.close();
    }
}

