/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.common;

import org.apache.commons.dbcp.BasicDataSource;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;

public final class DataSourceFactory {
    private DataSourceFactory() {
    }

    public static BasicDataSource createDataSource(DatabaseLoginCredentials credentials) {
        BasicDataSource dataSource = new BasicDataSource();
        switch (credentials.getDbType()) {
            case POSTGRESQL: {
                dataSource.setDriverClassName("org.postgresql.Driver");
                dataSource.setUrl("jdbc:postgresql://" + credentials.getHost() + "/" + credentials.getDatabase());
                break;
            }
            case MYSQL: {
                dataSource.setDriverClassName("com.mysql.jdbc.Driver");
                dataSource.setUrl("jdbc:mysql://" + credentials.getHost() + "/" + credentials.getDatabase());
                break;
            }
            default: {
                throw new OsmosisRuntimeException("Unknown database type " + credentials.getDbType() + ".");
            }
        }
        dataSource.setUsername(credentials.getUser());
        dataSource.setPassword(credentials.getPassword());
        return dataSource;
    }
}

