       SUBROUTINE WRKEYM(KFILDO,KFILX,NOPREC,KEYREC,NWDS,
     1                   KSIZE,CFROM,IER)
C 
C        NOVEMBER 1996   GLAHN      TDL   MOS-2000
C        AUGUST   1998   GLAHN      VALUE STORED IN NOPREC(5) CHANGED
C        APRIL    2000   DALLAVALLE MODIFIED FORMAT STATEMENTS TO
C                                   CONFORM TO FORTRAN 90 
C                                   STANDARDS ON THE IBM SP
C        DECEMBER 2006   GLAHN      COMMENT CHANGE  
C 
C        PURPOSE 
C            TO WRITE A KEY RECORD FOR MOS-2000 EXTERNAL DIRECT ACCESS
C            FILE SYSTEM.  IT WILL CONSIST OF KEYREC( ), PRECEEDED BY
C            3 WORDS FROM NOPREC( ).  THE LOGICAL RECORD CAN SPAN MORE
C            THAN ONE PHYSICAL RECORD.  CALLED BY FLOPNM, WRTDLM,
C            AND RDTDLM.
C 
C        DATA SET USE 
C            KFILDO - UNIT NUMBER FOR OUTPUT (PRINT) FILE.  (OUTPUT) 
C            KFILX  - UNIT NUMBER FOR MOS-2000 FILE.  (INPUT) 
C 
C        VARIABLES 
C 
C              KFILDO = UNIT NUMBER FOR OUTPUT (PRINT) FILE.  (INPUT)
C               KFILX = UNIT NUMBER FOR MOS-2000 FILE.  (INPUT) 
C           NOPREC(J) = 6 WORDS (J=1,6) USED BY THE FILE SYSTEM.  WORDS
C                       3, 5, AND 6 ARE WRITTEN AS PART OF THE KEY RECORD.
C                       THE WORDS ARE:
C                       1 = IS THE KEY RECORD IN KEYREC( , , )?  IF NOT,
C                           THIS VALUE IS ZERO.  OTHERWISE, LOCATION 
C                           IN KEYREC( , ,N) OF THE KEY RECORD, RANGE OF
C                           1 TO MAXOPN.
C                       2 = LOCATION OF THIS KEY RECORD IN THE FILE.
C                           MUST HAVE BEEN DEFINED BEFORE ENTERING THIS
c                           ROUTINE.
C                       3 = NUMBER OF SLOTS FILLED IN THIS KEY.
C                       4 = INDICATES WHETHER (1) OR NOT (0) THE KEY
C                           RECORD HAS BEEN MODIFIED AND NEEDS TO BE
C                           WRITTEN.  ZERO INITIALLY.
C                       5 = NUMBER OF PHYSICAL RECORDS IT TAKES TO HOLD
C                           THIS LOGICAL KEY RECORD.   WILL BE DEFINED 
C                           IN THIS ROUTINE ONLY IF NOT ALREADY DEFINED.
C                       6 = THE RECORD NUMBER OF THE NEXT KEY RECORD IN
C                           THE FILE.  EQUALS 99999999 WHEN THIS IS THE
C                           LAST KEY RECORD IN THE FILE.
C                       (INPUT-OUTPUT)
C           KEYREC(J) = KEY RECORD TO WRITE (J=1,NWDS).  (INPUT)
C                NWDS = MAXIMUM SIZE IN WORDS OF KEY RECORD SANS THE 
C                       LEADING 3 WORDS.  ON CREATION IN U350, THIS
C                       WILL BE MAXENT*7.  (INPUT)
C               KSIZE = SIZE OF PHYSICAL RECORD IN WORDS.  (INPUT)
C               CFROM = 6 CHARACTERS TO IDENTIFY CALLING PROGRAM. 
C                       (CHARACTER*6)  (INPUT)
C                 IER = STATUS RETURN.
C                         0 = GOOD RETURN.
C                       152 = RECORD NUMBER OF PHYSICAL RECORD SIZE
C                             INCORRECT.
C                       OTHER VALUES FROM SYSTEM.
C                       (OUTPUT)
C                JREC = RECORD NUMBER TO WRITE TO FILE NUMBER KFILX.
C                       (INTERNAL) 
C               STATE = SET TO A STATEMENT NUMBER FOR USE IN WRITING
C                       DIAGNOSTIC.  (INTERNAL)
C   
C        NONSYSTEM SUBROUTINES CALLED 
C            TDLPRM (/D ONLY) 
C 
      CHARACTER*4 STATE
      CHARACTER*6 CFROM
C
      DIMENSION NOPREC(6),KEYREC(NWDS)
C 
      IER=0
C
      JREC=NOPREC(2)
C        JREC = RECORD NO. OF FIRST PHYSICAL RECORD OF THE LOGICAL
C        KEY RECORD.
C
      IF(JREC.LE.0.OR.
     1   KSIZE.LE.0)THEN
         WRITE(KFILDO,110)JREC,KSIZE,KFILX,CFROM
 110     FORMAT(/,' ****EITHER THE RECORD NUMBER = ',I4,
     1            ' OR THE PHYSICAL RECORD SIZE =',I7,
     2            ' IS IN ERROR IN WRKDYM FOR UNIT NO.',I3,'.',/,
     3            '     WRKEYM CALLED FROM ',A6)
         IER=152
         GO TO 902
C
      ENDIF
C
C***D     WRITE(KFILDO,119)CFROM,KFILX,NWDS,KSIZE,NOPREC
C***D119  FORMAT(/' ENTER WRKEYM FROM'2XA6,'   KFILX ='I3,'   NWDS ='I6,
C***D    1        '   KSIZE ='I4,'  NOPREC ='I3,I5,I5,I3,I4,I6)
C***D     CALL TDLPRM(KFILDO,'WRKEYM1 ')
      IF(NOPREC(5).NE.0)GO TO 129
C
C        THIS IS THE FIRST TIME THIS KEY RECORD HAS BEEN WRITTEN.
C        MUST FILL NOPREC(5) BEFORE THE FIRST WRITE.  
C
      K=0
C        ABOVE STATEMENT CHANGED FROM K=1 AUG 28, 1998
      NREMIN=NWDS
      NEND=MIN(KSIZE-3,NWDS)
      NREMIN=NREMIN-NEND
 125  IF(NEND.GE.NWDS)GO TO 128
C
      K=K+1
      NSTART=K*KSIZE-3+1
      NEND=NSTART-1+MIN(KSIZE,NREMIN)
      NREMIN=NREMIN-KSIZE
      GO TO 125
C
 128  NOPREC(5)=K+1
C        ABOVE STATEMENT CHANGED FROM NOPREC(5)=K AUG 28, 1998
C
C        NOW WRITE THE LOGICAL RECORD IN PHYSICAL RECORDS
C        OF NWDS OR LESS.
C
 129  K=0
      NREMIN=NWDS
      NEND=MIN(KSIZE-3,NWDS)
      STATE='130 '
      WRITE(KFILX,REC=JREC,IOSTAT=IOS,ERR=900)
     1     NOPREC(3),NOPREC(5),NOPREC(6),(KEYREC(J),J=1,NEND)
      NREMIN=NREMIN-NEND
 130  IF(NEND.GE.NWDS)GO TO 150
C
      K=K+1
      NSTART=K*KSIZE-3+1
      NEND=NSTART-1+MIN(KSIZE,NREMIN)
      STATE='140 '
      WRITE(KFILX,REC=JREC+K,IOSTAT=IOS,ERR=900)
     1     (KEYREC(J),J=NSTART,NEND)
      NREMIN=NREMIN-KSIZE
      GO TO 130
C      
 150  CONTINUE 
C***D      CALL TDLPRM(KFILDO,'WRKEYM2 ')
C        THE STATEMENT ABOVE WILL CAUSE NULLS IN THE OUTPUT ON
C        FILE KFILDO IF FLOPNM HAS NOT BEEN CALLED.  NORMALLY,
C        FLOPNM IS CALLED, BUT NOT IN U350.
      GO TO 902 
C 
 900  WRITE(KFILDO,901)KFILX,STATE,CFROM,IOS
 901  FORMAT(/,' ****TROUBLE WRITING KEY RECORD ON UNIT NO. ',I3,
     1         ' AT STATEMENT ',A4,' IN WRKEYM FROM ',A6,
     2         '.  IOSTAT = ',I4)
      IER=IOS
C
 902  RETURN 
C
      END 
