      SUBROUTINE TRAIL(KFILDO,KFILIO,L3264B,L3264W,NTOTBY,NTOTRC,IER)
C
C        JANUARY   1995   GLAHN   TDL   MOS-2000
C        JANUARY   1996   GLAHN   ELIMINATED NBYTES FROM CALL
C        JANUARY   1996   GLAHN   NUMBER OF BYTES WRITTEN CORRECTED
C        FEBRUARY  1996   GLAHN   ADDED /D DIAGNOSTIC STATEMENT 2010
C        SEPTEMBER 1998   GLAHN   ELIMINATED WRITING TO KFILIO = 0
C        APRIL     2000   DALLAVALLE   MODIFIED FORMAT STATEMENTS TO
C                                 CONFORM TO FORTRAN 90 STANDARDS
C                                 ON THE IBM SP
C        MAY       2006   GLAHN   MODIFIED /D STATEMENT 2010 AND 
C                                 STATEMENT 203
C
C        PURPOSE
C           TO WRITE A TRAILER RECORD.  IT IS ASSUMED THE FILE IS 
C           POSITIONED PROPERLY.
C   
C        DATA SET USE
C            KFILDO    - UNIT NUMBER OF OUTPUT (PRINT) FILE.  (OUTPUT)
C            KFILIO    - UNIT NUMBER OF FILE ON WHICH TO WRITE THE
C                        TRAILER.  (OUTPUT)
C
C        VARIABLES
C              KFILDO = UNIT NUMBER OF OUTPUT (PRINT) FILE.  (INPUT)
C              KFILIO = UNIT NUMBER OF FILE ON WHICH TO WRITE THE
C                       TRAILER.  (INPUT)
C              L3264B = WORD LENGTH IN BITS OF MACHINE BEING USED.  (INPUT)
C              L3264W = THE NUMBER OF 32-BIT "WORDS" TO CONTAIN 64 BITS.
C                       2 FOR 32-BIT MACHINE, 1 FOR 64-BIT MACHINE.
C                       (INPUT)
C              NTOTBY = THE TOTAL NUMBER OF BYTES ON THE FILE.  IT IS 
C                       INCREASED BY 32.  (INPUT/OOUTPUT)
C              NTOTRC = THE TOTAL NUMBER OF RECORDS ON THE FILE.  IT IS
C                       INCREASED BY 1.  (INPUT/OUTPUT)
C                 IER = STATUS RETURN.
C                         0 = GOOD RETURN.
C                       VALUE OF IOS WHEN ERROR WRITING TRAILER.
C                       OTHER RETURNS FROM PKBG.
C                       (OUTPUT)
C           NBYTES(L) = USED TO WRITE DATA AS EITHER 2 WORDS FOR A 32-BIT
C                       MACHINE OR 1 WORD FOR A 64-BIT MACHINE (L=2).
C                       (INTERNAL)
C              ISHORT = THE NUMBER OF WORDS TO WRITE IN A TRAILER RECORD,
C                       AFTER THE INITIAL 8 BYTES.  (INTERNAL)
C            IPACK(J) = WORK ARRAY (J=1,6).  6 WORDS ARE REQUIRED FOR
C                       A 32-BIT MACHINE, ONLY 3 FOR A 64-BIT MACHINE.
C                       (INTERNAL)
C
C        NONSYSTEM SUBROUINES USED 
C            PKBG
C
      DIMENSION IPACK(6)
      DIMENSION NBYTES(2)
C
      IER=0
      IF(KFILIO.EQ.0)GO TO 300
C
C        SET NBYTES( )=0.
C
      NBYTES(1)=0
      NBYTES(2)=0
C
C        PREPARE AND WRITE TRAILER RECORD.
C
      LOC=1
      IPOS=1
C
      DO 2005 J=1,6
      IPACK(J)=0
 2005 CONTINUE
C
      DO 201 J=1,6
      NVAL=0
      IF(J.EQ.5)NVAL=9999
      CALL PKBG(KFILDO,IPACK,6,LOC,IPOS,NVAL,32,L3264B,IER,*300)
C        AN ERROR IN PKBG WILL HAVE CAUSED A DIAGNOSTIC.
C        RETURN WITH THE ERROR IN IER.
 201  CONTINUE
C
      ISHORT=192/L3264B
C        ISHORT IS THE NUMBER OF MACHINE WORDS IN A TRAILER,
C        AFTER THE INITIAL 8 BYTES.  WHILE ONLY 20 BYTES ARE
C        NECESSARY TO INCLUDE THE DATE/TIME, USE 24 TO MAKE
C        AN EVEN NUMBER OF 64-BIT WORDS.
      NBYTES(L3264W)=24 
D     WRITE(KFILDO,2010)KFILIO
D2010 FORMAT(' WRITING TRAILER RECORD ON UNIT NO.',I4)
      WRITE(KFILIO,IOSTAT=IOS,ERR=202)(NBYTES(J),J=1,L3264W),
     1                                (IPACK(J),J=1,ISHORT)
      NTOTRC=NTOTRC+1
      NTOTBY=NTOTBY+32
      GO TO 300
C
 202  WRITE(KFILDO,203)KFILIO,IOS
 203  FORMAT(/,' ****ERROR WRITING TRAILER RECORD IN TRAIL,',
     1         ' ON UNIT NO.',I4,' AT 203, IOSTAT =',I5)
      IER=IOS
C 
 300  RETURN
      END
