      SUBROUTINE PSLLIJ(KFILDO,ALAT,ALON,XMESHL,ORIENT,XLAT,
     1                  XLATLL,XLONLL,XI,YJ)
C
C        NOVEMBER 1994   GLAHN   TDL   MOS-2000
C        MAY      2000   GLAHN   COMMAS INSERTED IN FORMAT STATEMENT;
C                                CORRECTED SPELLING
C        JULY     2002   GLAHN   ADDED DIAGNOSTIC PRINT 100
C
C        PURPOSE
C            TO CONVERT FROM LATITUDE, LONGITUDE TO GRID COORDINATES ON
C            A NORTH POLAR STEREOGRAPHIC PROJECTION.  ADAPTED FROM NMC'S 
C            W3FB06.
C
C        DATA SET USE
C            KFILDO - UNIT NUMBER OF OUTPUT (PRINT) FILE.  (OUTPUT)
C
C        VARIABLES
C            INPUT
C              KFILDO = UNIT NUMBER OF OUTPUT (PRINT) FILE.  (INPUT)
C                ALAT = NORTH LATITUDE IN DEGREES OF THE POINT FOR WHICH
C                       THE GRID COORDINATE IS WANTED.
C                ALON = WEST LONGITUDE IN DEGREES OF THE POINT FOR WHICH
C                       THE GRID COORDINATE IS WANTED.  DON'T USE 
C                       NEGATIVE.
C              XMESHL = MESH LENGTH IN METERS AT XLAT DEGREES N LATITUDE.
C              ORIENT = ORIENTATION IN DEGREES WEST LONGITUDE.  DON'T USE 
C                       NEGATIVE.
C                XLAT = NORTH LATITUDE IN DEGREES AT WHICH XMESHL APPLIES.
C              XLATLL = LATITUDE OF LOWER LEFT (1,1) CORNER POINT OF
C                       THE GRID.
C              XLONLL = LONGITUDE OF LOWER LEFT (1,1) CORNER POINT OF
C                       THE GRID.  DON'T USE NEGATIVE.
C
C            OUTPUT
C               XI,YJ = IX (LEFT TO RIGHT) AND JY (BOTTOM TO TOP)
C                       GRIDPOINT NUMBERS OF THE POINT ALAT, ALON,
C                       CONSIDERING THE LOWER LEFT CORNER POINT TO BE (1,1).
C
C            INTERNAL
C                  PI = PI.  (SET BY PARAMETER)
C               RERTH = RADIUS OF THE EARTH IN METERS.  (SET BY PARAMETER)
C              RADPDG = NUMBER OF RADIANS PER DEGREE.  (SET BY PARAMETER)
C               RXLAT = XLAT CONVERTED TO RADIANS.
C              REBYDX = RADIUS OF THE EARTH DIVIDED BY MESH LENGTH.
C              RLATLL = XLATLL CONVERTED TO RADIANS.
C              RLONLL = LONGITUDE IN RADIANS.
C                RLAT = ALAT CONVERTED TO RADIANS.
C                RLON = LONGITUDE IN RADIANS.
C               POLEI = IX N POLE POSITION, RELATIVE TO LL CORNER.
C               POLEJ = JY N POLE POSITION, RELATIVE TO LL CORNER.
C
C        NONSYSTEM ROUTINES CALLED
C            NONE 
C
C        REMARKS
C            FORMULAE AND NOTATION LOOSELY BASED ON HOKE, HAYES,
C            AND RENNINGER'S "MAP PROJECTIONS AND GRID SYSTEMS...",
C            MARCH 1981, AFGWC/TN-79/003.  ADAPTED FROM NMC'S W3FB06.
C            W3FB06 USES EAST LONGITUDE AND IS SUPPOSED TO WORK FOR A
C            SOUTHERN HEMISPHERIC PROJECTION BY USING LATITUDE AND
C            GRIDLENGTH XMESHL AS NEGATIVE.  THIS FEATURE HAS BEEN 
C            ELIMINATED FOR THIS ROUTINE BECAUSE THERE IS NO 
C            REQUIREMENT FOR A SOUTHERN HEMISPHERIC PROJECTION. 
C
      PARAMETER (PI=3.14159,
     1           RERTH=6371200.,
     2           RADPDG=PI/180.)
C
      IF(XMESHL.LE.0..OR.ORIENT.LT.0..OR.XLAT.LT.0..OR.XLONLL.LT.0.)THEN
         WRITE(KFILDO,100)XMESHL,ORIENT,XLAT,XLONLL
 100     FORMAT(/' ****PROBLEM WITH EITHER'/
     1           '     XMESHL =',F12.4,','/
     2           '     ORIENT =',F12.4,','/
     3           '     XLAT   =',F12.4,', OR'/
     4           '     XLONLL =',F12.4,'.'/
     5           '     STOP IN PSLLIJ AT 100.')
         STOP 100
      ENDIF
C
      REBYDX = RERTH/XMESHL
      RXLAT = XLAT * RADPDG
      RLAT =  ALAT * RADPDG
      RLATLL= XLATLL * RADPDG
C
C        RADIUS TO LOWER LEFT (LL) CORNER
C        USE LL POINT INFO TO LOCATE POLE POINT
C
      RMLL=REBYDX * COS(RLATLL) * (1.+SIN(RXLAT))/(1.+SIN(RLATLL))
      RLONLL = (ORIENT-XLONLL+270.) * RADPDG
      POLEI = 1. - RMLL * COS(RLONLL)
      POLEJ = 1. - RMLL * SIN(RLONLL)
C
C        RADIUS TO DESIRED POINT, AND THE XI YJ TOO.
C
      RM = REBYDX * COS(RLAT) * (1.+SIN(RXLAT))/(1.+SIN(RLAT))
      RLON = (ORIENT-ALON+270.) * RADPDG
      XI = POLEI + RM * COS(RLON)
      YJ = POLEJ + RM * SIN(RLON)
C
D     WRITE(KFILDO,900)ALAT,ALON,XMESHL,ORIENT,XLAT,XLATLL,XLONLL,
D    1                 XI,YJ
D900  FORMAT(' PSLLIJ--ALAT,ALON,XMESHL,ORIENT,XLAT,XLATLL,XLONLL,',
D    1       'XI,YJ'/9F10.2)
C
      RETURN
      END
