      SUBROUTINE PSIJLL(KFILDO,XI,YJ,XMESHL,ORIENT,XLAT,
     1                  XLATLL,XLONLL,ALAT,ALON)
C
C        JUNE     2002   GLAHN   MDL   MOS-2000
C        JULY     2002   GLAHN   ADDED DIAGNOSTIC PRINT 100
C
C        PURPOSE
C            TO CONVERT FROM XI, YJ POSITIONS ON A NORTH POLAR
C            STEREOGRAPHIC MAP PROJECTION TO LAT/LON.  ADAPTED FROM
C            NMC'S W3FB07.
C
C        DATA SET USE
C            KFILDO - UNIT NUMBER OF OUTPUT (PRINT) FILE.  (OUTPUT)
C
C        VARIABLES
C            INPUT
C              KFILDO = UNIT NUMBER OF OUTPUT (PRINT) FILE.  (INPUT)
C               XI,YJ = IX (LEFT TO RIGHT) AND JY (BOTTOM TO TOP)
C                       GRIDPOINT NUMBERS OF THE POINT FOR WHICH THE
C                       ALAT, ALON IS WANTED, CONSIDERING THE LOWER
C                       LEFT CORNER POINT TO BE (1,1).
C              XMESHL = MESH LENGTH IN METERS AT XLAT DEGREES NORTH
C                       LATITUDE.
C              ORIENT = ORIENTATION IN DEGREES WEST LONGITUDE.  DO
C                       NOT USE NEGATIVE.
C                XLAT = NORTH LATITUDE IN DEGREES AT WHICH XMESHL
C                       APPLIES.  DO NOT USE NEGATIVE.
C              XLATLL = LATITUDE OF LOWER LEFT (1,1) CORNER POINT OF
C                       THE GRID.  USE NEGATIVE FOR SOUTHERN
C                       HEMISPHERE.
C              XLONLL = WEST LONGITUDE OF LOWER LEFT (1,1) CORNER POINT
C                       OF THE GRID.  DO NOT USE NEGATIVE.
C
C            OUTPUT
C                ALAT = NORTH LATITUDE IN DEGREES OF THE XI,JY POINT.
C                ALON = WEST LONGITUDE IN DEGREES OF THE XI,JY POINT.
C
C            INTERNAL
C                  PI = PI.  (SET BY PARAMETER)
C               RERTH = RADIUS OF THE EARTH IN METERS.  (SET BY
C                       PARAMETER)
C              RADPDG = NUMBER OF RADIANS PER DEGREE.  (SET BY
C                       PARAMETER)
C              DEGPRA = DEGREES PER RADIAN.  (SET BY PARAMETER)
C               RXLAT = XLAT CONVERTED TO RADIANS.
C              REBYDX = RADIUS OF THE EARTH DIVIDED BY MESH LENGTH.
C              REFLON = REFERENCE LONGITUDE.
C              RLATLL = XLATLL CONVERTED TO RADIANS.
C              RLONLL = WEST LONGITUDE XLONLL CONVERTED TO RADIANS
C                       EAST LONGITUDE.
C               POLEI = IX N POLE POSITION, RELATIVE TO LL CORNER.
C               POLEJ = JY N POLE POSITION, RELATIVE TO LL CORNER.
C        1         2         3         4         5         6         7 X
C
C        NONSYSTEM ROUTINES CALLED
C            NONE 
C
      PARAMETER (PI = 3.14159,
     1           RERTH = 6371200.,
     2           RADPDG = PI/180.,
     3           DEGPRA = 180./PI)
C
      IF(XMESHL.LE.0..OR.ORIENT.LT.0..OR.XLAT.LT.0..OR.XLONLL.LT.0.)THEN
         WRITE(KFILDO,100)XMESHL,ORIENT,XLAT,XLONLL
 100     FORMAT(/' ****PROBLEM WITH EITHER'/
     1           '     XMESHL =',F12.4,','/
     2           '     ORIENT =',F12.4,','/
     3           '     XLAT   =',F12.4,', OR'/
     4           '     XLONLL =',F12.4,'.'/
     5           '     STOP IN PSIJLL AT 100.')
         STOP 100
      ENDIF
C
      RXLAT = XLAT * RADPDG
      RLATLL = XLATLL * RADPDG
      REFLON = 90. - ORIENT
C        ORIENT IS WEST LONGITUDE, REFLON IS EAST LONGITUDE.
      REBYDX = RERTH/XMESHL
C
C        RADIUS TO LOWER LEFT HAND (LL) CORNER
C
      RMLL = REBYDX * COS(RLATLL) * (1.+SIN(RXLAT))/(1.+SIN(RLATLL))
C
C        USE LL POINT INFO TO LOCATE POLE POINT
C
      RLONLL = (360. - XLONLL - REFLON) * RADPDG
      POLEI = 1. - RMLL * COS(RLONLL)
      POLEJ = 1. - RMLL * SIN(RLONLL)
C
C        RADIUS TO THE I,J POINT (IN GRID UNITS)
C
      XX = XI - POLEI
      YY = YJ - POLEJ
      R2 =  XX**2 + YY**2
C
C        NOW THE MAGIC FORMULAE
C
      IF(R2.EQ.0.) THEN
C           THIS IS THE POLE.
         ALAT = 90.
         ALON = 0.
      ELSE
         GI2 = (REBYDX * (1. + SIN(RXLAT)))**2
         ALAT = DEGPRA * ASIN((GI2 - R2)/(GI2 + R2))
C
         IF(YY.GT.0) THEN
C              TAKES CARE OF WHEN THE POINT IS OVER THE POLE.
            ALON = REFLON + DEGPRA * ACOS(XX/SQRT(R2))
         ELSE
            ALON = REFLON - DEGPRA * ACOS(XX/SQRT(R2))
         ENDIF
C
      ENDIF
C
      IF(ALON.LT.0.) ALON = ALON + 360.
C        ABOVE MAKES EAST LONGITUDE ALWAYS POSITIVE.
      ALON = 360. - ALON
C        ABOVE CHANGES EAST LONGITUDE, ON WHICH NCEP ROUTINES ARE
C        BASED, TO WEST LONGITUDE.
C
CD     WRITE(KFILDO,200)XI,YJ,XMESHL,ORIENT,XLAT,
CD    1                 XLATLL,XLONLL,ALAT,ALON
CD200  FORMAT(/' IN PSIJLL--XI,YJ,XMESHL,ORIENT,XLAT,',
CD    1        'XLATLL,XLONLL,ALAT,ALON',2F6.0,7F8.3)
      RETURN
      END
