      SUBROUTINE PACK1D(KFILDO,A,IC,NSTA,IS0,IS1,IS2,IS4,
     1                  ND7,XMISSP,XMISSS,IPACK,ND5,
     2                  MINPK,LX,IOCTET,L3264B,IER)
C
C        DECEMBER 1994   GLAHN   TDL   MOS-2000
C        JUNE     1995   GLAHN   ADDED MINPK DIAGNOSTIC.
C        JULY     1996   GLAHN   ADDED XMISSS AND BINARY SCALING
C        MARCH    1997   GLAHN   ADDED TESTS FOR NO MISSING VALUES
C        MARCH    1997   GLAHN   CHANGED DEFAULT MINPKL FROM 15 TO 14.
C        MARCH    2000   DALLAVALLE   MODIFIED FORMAT STATEMENTS TO
C                                     CONFORM TO FORTRAN 90 STANDARDS
C                                     ON THE IBM-SP; ALSO REPLACED
C                                     OCTAL CONSTANT WITH DECIMAL VALUE
C 
C        PURPOSE 
C            SUBROUTINE TO PACK DATA AT "UNITS" RESOLUTION PROVIDED
C            IN 1-DIMENSIONAL ARRAY A( ) AFTER MULTIPLYING BY
C            [10**IS1(17)]*[2**IS1(18)].  THE DECIMAL AND 
C            BINARY SCALING VALUES IN IS1(17) AND IS1(18) ARE
C            SIMILAR TO THE WMO GRIB DEFINITIONS FOR BYTES 27 AND 28
C            IN SECTION 1 AND BYTES 5 AND 6 OF SECTION 4,
C            RESPECTIVELY.  HOWEVER, THEY ARE NOT APPLIED IN
C            THE SAME WAY (SEE CHAPTER 5 "DATA RECORD STRUCTURE" IN 
C            TDL OFFICE NOTE "MOS 2000."  THE SMALLEST VALUE IS
C            SUBTRACTED TO MAKE ALL VALUES POSITIVE.  ADDITIONAL
C            VALUES ARE TAKEN OUT AT NONUNIFORM STEPS WITH A
C            MINIMUM GROUP SIZE OF MINPK.  XMISSP (XMISSS) IS THE
C            VALUE THAT REPRESENTS A PRIMARY (SECONDARY) MISSING
C            VALUE, UNLESS IT IS ZERO, IN WHICH CASE NO MISSING
C            VALUE CAN BE PRESENT.  A CHECK IS MADE SUCH THAT IF
C            NO PRIMARY (SECONDARY) MISSING VALUE IS ACTUALLY
C            PRESENT (WHEN XMISSP (XMISSS) NE 0) THE PRIMARY
C            (SECONDARY) MISSING VALUE FURNISHED TO PACK WILL
C            BE ZERO.  2ND ORDER (SPATIAL)  DIFFERENCES ARE NOT
C            CALCULATED OR CONSIDERED BECAUSE IT IS NOT EXPECTED
C            THAT VECTOR DATA WILL HAVE VALUES ORDERED IN
C            SUCH A WAY TO MAKE THAT PROFITABLE.  SUBROUTINE 
C            PACK IS CALLED TO DO THE ACTUAL PACKING ONCE THE
C            DATA ARE SCALED AND PUT INTO THE INTEGER ARRAY IC( ). 
C
C        DATA SET USE 
C           KFILDO - UNIT NUMBER FOR OUTPUT (PRINT) FILE. (OUTPUT) 
C
C        VARIABLES 
C              KFILDO = UNIT NUMBER FOR OUTPUT (PRINT) FILE.  (INPUT) 
C                A(J) = ARRAY FOR ORIGINIAL INPUT DATA (J=1,NSTA).
C                       (INPUT)
C               IC(J) = ARRAY FOR SCALED AND ROUNDED DATA (J=1,NSTA).
C                       (INTERNAL)
C                NSTA = THE NUMBER OF VALUES IN A( ).  ALSO TREATED
C                       AS THE DIMENSIONS OF A( ), AND IC( ).  (INPUT)
C              IS0(L) = HOLDS THE VALUES TO FURNISH FOR GRIB
C                       SECTION 0 (L=1,ND7).  (INPUT)
C              IS1(L) = HOLDS THE VALUES TO FURNISH FOR GRIB
C                       SECTION 1 (L=1,ND7).  (INPUT)
C              IS2(L) = HOLDS THE VALUES FOR GRIB SECTION 2 (L=1,ND7).
C                       NOT USED FOR 1-D PACKING, BUT MUST BE FURNISHED
C                       TO SUBROUTINE PACK.  (INPUT)
C              IS4(L) = HOLDS THE VALUES FOR GRIB SECTION 4.  NONE OF 
C                       THE VALUES NEED BE FURNISHED BY THE USER.
C                       IS4(2) IS SET TO INDICATE NON-GRIDPOINT DATA,
C                       COMPLEX PACKING, ORIGINAL SCALED VALUES TO
C                       BE PACKED (NOT SECOND ORDER SPATIAL DIFFERENCES),
C                       AND MISSING VALUES OR NOT DEPENDING ON WHETHER OR
C                       NOT XMISS NE OR EQ ZERO, RESPECTIVELY.  (INTERNAL)
C                 ND7 = DIMENSION OF IS0( ), IS1( ), IS2( ), AND IS4( ).
C                       (INPUT)
C              XMISSP = WHEN MISSING POINTS CAN BE PRESENT IN THE DATA,
C                       THEY WILL HAVE THE VALUE XMISSP OR XMISSS.
C                       WHILE XMISSP AND XMISSS ARE REAL NUMBERS, THEY
C                       ARE CONVERTED TO INTEGER, SO THEY SHOULD BE 
C                       WHOLE NUMBERS.  XMISSP IS THE PRIMARY MISSING
C                       VALUE AND IS USUALLY 9999, AND 9999 IS HARDCODED
C                       IN SOME SOFTWARE.  XMISSS IS THE SECONDARY
C                       MISSING VALUE AND ACCOMMODATES THE 9997 PRODUCED
C                       BY SOME EQUATIONS FOR MOS FORECASTS.
C                       XMISSP = 0 INDICATES THAT NO MISSING VALUES
C                       (EITHER PRIMARY OR SECONDARY) ARE PRESENT.
C                       XMISSS = 0 INDICATES THAT NO SECONDARY MISSING
C                       VALUES ARE PRESENT.  (INPUT)
C              XMISSS = SECONDARY MISSING VALUE INDICATOR (SEE XMISSP).
C                       (INPUT)
C            IPACK(J) = THE ARRAY TO HOLD THE ACTUAL PACKED MESSAGE
C                       (J=1,MAX OF ND5).  (OUTPUT)
C                 ND5 = THE SIZE OF IPACK( ).  SINCE THE FULL ARRAY
C                       IPACK( ) IS ZEROED ON ENTRY, ND5 SHOULD NOT BE
C                       UNREALISTICALLY LARGE.  IT WILL NOT BE OVERFLOWED.
C                       (INPUT)  
C               MINPK = VALUES ARE PACKED IN GROUPS OF MINIMUM SIZE
C                       MINPK.  ONLY WHEN THE NUMBER OF BITS TO HANDLE
C                       A GROUP CHANGES WILL A NEW GROUP BE FORMED.  
C                       IF MINPK LE 0, A DIAGNOSTIC WILL BE OUTPUT AND
C                       THE LOCAL VALUE OF MINPK SET = 14.  (INPUT)
C                  LX = THE NUMBER OF GROUPS (THE NUMBER OF 2ND ORDER 
C                       MINIMA).  WHILE NEEDED ONLY IN SUBROUTINE PACK, IT IS
C                       OUTPUT IN THE ARGUMENT LIST IN CASE THE USER
C                       WANTS TO KNOW IT.  (OUTPUT)  
C              IOCTET = THE TOTAL MESSAGE SIZE IN OCTETS.  (OUTPUT)
C                 IER = STATUS RETURN.  (OUTPUT)
C                         0 = GOOD VALUE.
C                       134 = XMISSP AND XMISSS INCONSISTENT.
C                       OTHER VALUES COME FROM CALLED SUBROUTINE.
C               SCALE = SCALING PARAMETER = [10**IS1(17)]*[2**IS1(18)].
C                       (INTERNAL)
C              SECOND = SET TO FALSE FOR SUBROUTINE PACK.  THIS INDICATES
C                       2ND ORDER DIFFERENCES ARE NOT TO BE PACKED.  IT
C                       HAS NO REAL MEANING FOR STATION DATA.  TIME
C                       SERIES DATA, IF PACKED, COULD BENEFIT.  (LOGICAL) 
C                       (INTERNAL)
C              MINPKL = LOCAL VALUE OF MINPK.  (INTERNAL)
C               MISSP = INTEGER VERSION OF XMISSP = NINT(XMISSP*10000.)
C                       THIS IS SET TO A LARGE VALUE TO MINIMIZE THE
C                       CHANCE THAT A SCALED INTEGER VALUE WILL EQUAL
C                       THIS MISSING INDICATOR.  (INTERNAL)
C               MISSS = INTEGER VERSION OF XMISSS = NINT(XMISSP*10000.)
C                       SEE MISSP.  (INTERNAL)
C 
C        NON SYSTEM SUBROUTINES CALLED 
C           PACK
C
      LOGICAL SECOND
C
      DIMENSION A(NSTA),IC(NSTA)
      DIMENSION IPACK(ND5)
      DIMENSION IS0(ND7),IS1(ND7),IS2(ND7),IS4(ND7) 
C
D     CALL TIMPR(KFILDO,KFILDO,'START PACK1D        ')
C
C        PROVIDE LOCAL VALUE OF MINPK IN CASE IT NEEDS TO BE
C        CHANGED.
C
      MINPKL=MINPK
      IF(MINPKL.LE.0)THEN
         MINPKL=14
         WRITE(KFILDO,100)
 100     FORMAT(/,' ****MINPK WAS LE 0 IN PACK1D.  CHANGED TO 14.')
      ENDIF
C
C        CHECK CONSISTENCY OF XMISSP AND XMISSS.
C
      IF(XMISSP.EQ.0..AND.XMISSS.NE.0.)THEN
         WRITE(KFILDO,101)XMISSS
 101     FORMAT(/,' ****XMISSP EQ 0 AND XMISSS NE 0 IN PACK1D.',
     1           '  XMISSS =',F10.4,' IS TREATED AS ZERO.')
      IER=134
      ENDIF
C         
C        IPACK( ) MUST BE ZEROED.
C
      DO 102 K=1,ND5
      IPACK(K)=0
 102  CONTINUE
C
C        DATA ARE IN A( ).  NOW SCALE THEM INTO IC( ).  LOOPS
C        ARE ARRANGED FOR MAXIMUM EFFICIENCY BY NOT CHECKING
C        FOR MISSING VALUES UNLESS NECESSARY.
C
      SCALE=(10.**IS1(17))*(2.**IS1(18))
      IS4(4)=NINT(XMISSP)
      IS4(5)=NINT(XMISSS)
C        THE UNSCALLED MISSING VALUES ARE PUT INTO IS4(4) 
C        AND IS4(5) IN CASE THE USER WANTS THEM THERE.
      MISSP=NINT(XMISSP*10000.)
      MISSS=NINT(XMISSS*10000.)
C        MISSP AND MISSS ARE MADE LARGE TO MINIMIZE THE RISK
C        OF SCALED VALUES BEING EQUAL TO THE MISSING VALUE.
C        NORMALLY, MISSP WILL EQUAL 99,990,000.
      IF(MISSP.EQ.0)MISSS=0
C        A SECONDARY MISSING CANNOT BE INDICATED UNLESS 
C        A PRIMARY MISSING IS INDICATED.
C
      IF(MISSP.EQ.0)THEN
C        THIS LOOP IS USED WHEN MISSING VALUES NEED NOT BE
C        CONSIDERED.  NOTE THAT SECONDARY MISSING VALUES
C        CANNOT BE PRESENT UNLESS PRIMARY ONES CAN.
C
         DO 103 J=1,NSTA
         IC(J)=NINT(A(J)*SCALE)
 103     CONTINUE
C
      ELSEIF(MISSS.EQ.0)THEN
C        THIS LOOP IS USED WHEN ONLY PRIMARY MISSING VALUES
C        MAY BE PRESENT.
C
         MISSPC=0
C
         DO 113 J=1,NSTA
         IF(A(J).EQ.XMISSP)THEN
            IC(J)=MISSP
            MISSPC=1
         ELSE
            IC(J)=NINT(A(J)*SCALE)
            IF(IC(J).EQ.MISSP)IC(J)=IC(J)-1
C              THE ABOVE STATEMENT NECESSARY IN CASE THE 
C              SCALED VALUE IS EQUAL TO THE MISSING VALUE.
C              OTHERWISE, THE PACKER WILL THINK THE VALUE
C              IS ACTUALLY THE MISSING VALUE.  THIS SHOULD
C              BE EXTREMELY RARE.
         ENDIF
 113     CONTINUE
C
         IF(MISSPC.EQ.0)MISSP=0
         IS4(4)=MISSP
C
      ELSE
C
C        THIS LOOP IS USED WHEN BOTH PRIMARY AND SECONDARY 
C        MISSING VALUES MAY PRESENT.  IF NO SECONDARY
C        MISSING VALUE IS ACTUALLY PRESENT, MISSS IS SET
C        TO ZERO.
C
         MISSPC=0
         MISSSC=0
C
         DO 115 J=1,NSTA
         IF(A(J).EQ.XMISSP)THEN
            IC(J)=MISSP
            MISSPC=1
         ELSEIF(A(J).EQ.XMISSS)THEN
            IC(J)=MISSS
            MISSSC=1
         ELSE
            IC(J)=NINT(A(J)*SCALE)
            IF(IC(J).EQ.MISSP)IC(J)=IC(J)-1
            IF(IC(J).EQ.MISSS)IC(J)=IC(J)-1
C              THE ABOVE STATEMENTS NECESSARY IN CASE THE 
C              SCALED VALUE IS EQUAL TO THE MISSING VALUE.
C              OTHERWISE, THE PACKER WILL THINK THE VALUE
C              IS ACTUALLY THE MISSING VALUE.  THIS SHOULD
C              BE EXTREMELY RARE.       
         ENDIF
 115     CONTINUE
C
         IF(MISSSC.EQ.0)THEN
            MISSS=0
            IS4(5)=MISSS
            IF(MISSPC.EQ.0)THEN
               MISSP=0
               IS4(4)=MISSP
C                 DO NOT MESS WITH MISSP UNLESS MISSS = 0.
            ENDIF
C
         ENDIF
C
      ENDIF
C           
C***D     WRITE(KFILDO,116)(IC(J),J=1,NSTA)
C***D116  FORMAT(/' ORIGINAL SCALED VALUES WITH MISSINGS',
C***D    1        ' MULTIPLIED BY 10000'/(' '20I6))
C 
      IS4(2)=24
C        IS4(2) INDICATES COMPLEX PACKING AND NON-GRIDPOINT DATA.
C        IN THE PREVIOUS STATEMENT THE OCTAL CONSTANT 30B WAS 
C        REPLACED BY THE DECIMAL VALUE 24 TO CONFORM TO FORTRAN 90
C        STANDARDS ON THE IBM-SP.  24 (or 30B) CORRESPONDS TO
C        BINARY 011000
C
      IF(MISSP.NE.0)THEN
         IS4(2)=IOR(IS4(2),2)
C           PRIMARY MISSING VALUES MAY BE PRESENT.
         IF(MISSS.NE.0)IS4(2)=IOR(IS4(2),1)
C           SECONDARY MISSING VALUES MAY BE PRESENT.
      ENDIF
C
      SECOND=.FALSE.
      CALL PACK(KFILDO,IC,NSTA,IS0,IS1,IS2,IS4,ND7,
     1          IPACK,ND5,SECOND,IFIRST,IFOD,MISSP,MISSS,
     2          MINPKL,LX,IOCTET,L3264B,IER)
D     WRITE(KFILDO,117)(IS0(J),J=1,8)
D117  FORMAT(/,' PACK1D, IS0( )',/,(O12,7I12))
D     WRITE(KFILDO,118)(IS1(J),J=1,IS1(1))
D118  FORMAT(/,' PACK1D, IS1( )',/,(10I12))
D     WRITE(KFILDO,120)(IS4(J),J=1,21)
D120  FORMAT(/,' PACK1D, IS4( )',/,(10I12))
D     CALL TIMPR(KFILDO,KFILDO,'END PACK1D          ') 
      RETURN
      END
