      SUBROUTINE FLOPNM(KFILDO,KFILX,CFILX,IRW,NT,L3264B,IRAEND,IER) 
C 
C        NOVEMBER 1996   GLAHN   TDL   MOS-2000 
C        JANUARY  1997   GLAHN   ADDED NW TO CALL TO RDKEYM 
C        MARCH    1998   GLAHN   CHANGED NW FROM 15 TO 300
C        AUGUST   1999   MCE     CHANGED READONLY TO ACTION=READ
C                                FOR COMPILATION ON IBM
C        APRIL    2000   JPD     MODIFIED FORMAT STATEMENTS TO
C                                CONFORM TO FORTRAN 90 STANDARDS
C                                ON THE IBM SP
C        JUNE     2006   GLAHN   CHANGED NW FROM 300 TO 840
C        DECEMBER 2006   GLAHN   COMMENT CHANGE                               
C        JULY     2012   ENGLE      ADDED CONVERTX; ADDED CALL TO
C                                   CKRAEND TO CHECK ENDIAN OF RAMDOM
C                                   ACCESS FILE; CHANGED LINE STATEMENT
C                                   200 TO CALL TO CKRAEND. THIS WILL ENSURE
C                                   THAT CKRAEND IS ALWAYS CALLED; MODIFIED
C                                   OPEN STATEMENT TO INCLUDE CONVERT=
C                                   SPECIFIER.
C        AUGUST   2012   ENGLE      ADDED IRAEND AND MODIFIED CALLING
C                                   SEQUENCE TO INCLUDE IRAEND.
C        SEPT     2012   ENGLE,     ADDED NRAEND TO COMMON ARG; MODIFIED
C                        J. WAGNER  CALL TO ARINIT;
C
C        NOTE: ADDING THE CONVERT= SPECIFIER WILL BREAK THIS ROUTINE
C              USING IBM XL FORTRAN.
C 
C        PURPOSE 
C            TO PREPARE FOR READING OR WRITING A MOS-2000 EXTERNAL
C            DIRECT ACCESS FILE.  THIS INCLUDES, WHEN NECESSARY,
C            OPENING THE FILE AND READING THE MASTER KEY RECORD INTO 
C            MASTER( , ).  THE FILE IS OPENED TO A RECORD SIZE IN 
C            BYTES EQUIVALENT TO 6 COMPUTER WORDS, WHICH IS
C            SUFFICIENT TO READ THE MASTER KEY RECORD.  THE MASTER
C            KEY RECORD IS READ TO DETERMINE THE RECORD SIZE, THEN
C            THE FILE IS CLOSED AND REOPENED TO THE CORRECT SIZE.
C            A LIST OF MAXFIL FILE NAMES IS KEPT SO THAT IF A FILE
C            IS CLOSED AND REOPENED, IT WILL BE KNOWN WHAT THE 
C            CORRECT SIZE IS.  A KEY RECORD IS READ IF NECESSARY.
C 
C        DATA SET USE. 
C            KFILDO - UNIT NUMBER FOR OUTPUT (PRINT) FILE.  (OUTPUT) 
C            KFILX  - UNIT NUMBER FOR MOS-2000 FILE.  (INPUT) 
C 
C        VARIABLES 
C              KFILDO = UNIT NUMBER FOR OUTPUT (PRINT) FILE.  (INPUT)
C               KFILX = UNIT NUMBER FOR MOS-2000 FILE.  (INPUT)
C               CFILX = THE FILE NAME OF THE FILE TO OPEN.  (CHARACTER*1024)
C                       (INPUT)
C                 IRW = READ/WRITE INDICATOR. 
C                       1 = READING IS EXPECTED.  THE FIRST KEY RECORD IS 
C                           READ UNLESS THE FILE HAS BEEN USED PREVIOUSLY 
C                           AND IS STILL OPEN. 
C                       2 = WRITING IS EXPECTED.  THE LAST KEY RECORD IS 
C                           READ UNLESS THE FILE HAS BEEN USED PREVIOUSLY 
C                           AND IS STILL OPEN. 
C                       IF THE FILE IS OPEN, THE KEY RECORD LAST USED IS 
C                       READ.  THIS PARAMETER IS FOR EFFICIENCY ONLY. 
C                       (INPUT)
C                  NT = THE NUMBER OF THE ENTRY IN NOPEN( ), ETC.  (OUTPUT) 
C              L3264B = 32 FOR THE 32-BIT WORD WORKSTATIONS; 64 FOR THE CRAY.
C                       (INPUT) 
C                 IER = STATUS CODE 
C                         0 = GOOD RETURN
C                       151 = NRW NOT 1 OR 2
C                       154 = ARRAY SIZE NOT LARGE ENOUGH IN READING
C                             MASTER KEY RECORD.  FULL PHYSICAL RECORDS
C                             MUST BE ACCOMMODATED.
C                       OTHER VALUES FROM SYSTEM AND CALLED ROUTINES.
C                       (OUTPUT)
C                LREC = THE RECORD IN WHICH KEY STARTS.  (INTERNAL)
C              IFIRST = 0 INITIALLY, SET BY DATA STATEMENT.  ONCE FLOPNM
C                       IS ENTERED, IT IS SET = 1.  (INTERNAL)
C
C            DIRECT ACCESS FILE INFORMATION
C                       NO ATTEMPT IS MADE TO MAKE A FILE WRITTEN ON
C                       THE CRAY READABLE ON THE HP, AND VICE VERSA.
C                       WHILE THIS IS POSSIBLE FOR THE DATA PORTIONS 
C                       OF THE FILE (IN THE SAME MANNER AS FOR SEQUENTIAL
C                       FILES) THE WORD LENGTH DIFFERENCE WOULD MAKE 
C                       "UNPACKING" OF KEY RECORDS NECESSARY.  THIS SEEMS
C                       TO BE MORE TROUBLE THAT COMPATIBILITY IS WORTH.
C                       CONSTANT FILES, WHICH IN MANY CASES WILL BE USER
C                       SPECIFIC AND BE CREATED AND USED ON ONLY ONE 
C                       MACHINE, CAN BE CREATED ON THE MACHINE ON WHICH
C                       THEY ARE TO BE USED.  FORECAST FILES PRODUCED BY
C                       U900 SHOULD BE NECESSARY ONLY ON THE CRAY.
C
C            THE FOLLOWING ARE IN THE COMMON BLOCK ARGC.  THIS COMMON 
C            BLOCK NEED BE ONLY IN FLOPNM, WRTDLM, RDTDLM AND CLFILM
C            (ALSO TDLPRM IF USED FOR DIAGNOSTICS).  HOWEVER, 
C            CREATION OF THE FILES BY U350 MUST BE CONSISTENT WITH 
C            THE PARAMETER NW.
C
C            NOPEN(N) = THE FORTRAN UNIT NUMBER CURRENTLY ASSOCIATED
C                       WITH AN OPEN FILE FOR EACH OF MAXOPN FILES
C                       (N=1,MAXOPN).  IF A FILE IS NOT OPEN FOR N,
C                       NOPEN(N) = 9999.
C          LSTRD(J,N) = THE RECORD NUMBER OF THE KEY RECORD LAST USED 
C                       (J=1) AND THE NUMBER OF THE ENTRY IN THE KEY
C                       RECORD LAST USED (J=2) FOR EACH OF THE MAXOPN
C                       FILES (N=1,MAXOPN).
C            CFILE(N) = THE FILE NAME ASSOCIATED WITH THE UNIT NUMBER
C                       IN NOPEN(N) FOR EACH OF MAXOPN FILES
C                       (N=1,MAXOPN).  (CHARACTER*1024)
C             KUSE(N) = RECORDS THE LAST USE OF EACH OF THE OPEN FILES
C                       BY STORING KOUNT WHENEVER FLOPNM IS ENTERED.
C                       (N=1,MAXOPN).
C             NIRW(N) = SET TO 1 WHEN FILE IS OPEN FOR READING ONLY AND
C                       SET TO 2 WHEN FILE IS OPEN FOR READING AND
C                       WRITING, FOR EACH OF OPEN FILES (N=1,MAXOPN).
C         MASTER(J,N) = 6 WORDS (J=1,6) OF THE MASTER KEY RECORD PLUS
C                       AN EXTRA WORD (J=7) INDICATING WHETHER (1) OR
C                       NOT (0) THIS MASTER KEY RECORD NEED BE WRITTEN
C                       WHEN CLOSING THE FILE FOR EACH OF THE MAXOPN 
C                       FILES (N=1,MAXOPN).  THE WORDS ARE: 
C                       1 = RESERVED.  SET TO ZERO.
C                       2 = NUMBER OF INTEGER WORDS IN ID FOR EACH
C                           RECORD.  THIS IS 4 UNLESS CHANGES ARE
C                           MADE TO THE SOFTWARE.
C                       3 = THE NUMBER OF WORDS IN A PHYSICAL RECORD.
C                           THIS APPLIES TO A 32-BIT OR A 64-BIN 
C                           MACHINE.
C                       4 = NUMBER OF KEY RECORDS STORED IN THE FILE
C                           TO WHICH THIS MASTER KEY REFERS.
C                           INITIALLY = 1.
C                       5 = MAXIMUM NUMBER OF KEYS IN A KEY RECORD 
C                           FOR THIS FILE.
C                       6 = LOCATION OF WHERE THE FIRST PHYSICAL RECORD
C                           OF THE LAST LOGICAL KEY RECORD OF THE FILE
C                           IS LOCATED.
C                       7 = THIS MASTER KEY RECORD HAS (1) HAS NOT (0)
C                           BEEN MODIFIED.
C                       (INPUT-OUTPUT)
C         NOPREC(J,N) = 6 WORDS (J=1,6) USED BY THE FILE SYSTEM FOR EACH
C                       OF THE OPEN FILES (N=1,MAXOPN).  WORDS 3, 5,
C                       AND 6 ARE WRITTEN AS PART OF THE KEY RECORD.
C                       THE WORDS ARE:
C                       1 = IS THE KEY RECORD IN KEYREC( , , )?  IF NOT,
C                           THIS VALUE IS ZERO.  OTHERWISE, LOCATION 
C                           IN KEYREC( , ,N) OF THE KEY RECORD, RANGE OF
C                           1 TO MAXOPN.
C                       2 = LOCATION OF THIS KEY RECORD IN THE FILE.
C                       3 = NUMBER OF SLOTS FILLED IN THIS KEY.
C                       4 = INDICATES WHETHER (1) OR NOT (0) THE KEY
C                           RECORD HAS BEEN MODIFIED AND NEEDS TO BE
C                           WRITTEN.  ZERO INITIALLY.
C                       5 = NUMBER OF PHYSICAL RECORDS IT TAKES TO HOLD
C                           THIS LOGICAL KEY RECORD.  THIS IS FILLED BY
C                           WRKEYM.
C                       6 = THE RECORD NUMBER OF THE NEXT KEY RECORD IN
C                           THE FILE.  EQUALS 99999999 WHEN THIS IS THE
C                           LAST KEY RECORD IN THE FILE.
C       KEYREC(J,L,N) = HOLDS THE KEY RECORDS FOR UP TO MAXOPEN OPEN
C                       FILES (N=1,MAXOPN), EACH KEY HAVING UP TO 
C                       NW ENTRIES (L=1,NW).  THE WORDS ARE:
C                       1-4 = THE 4 MOS-2000 IDS.
C                         5 = THE NUMBER OF DATA WORDS IN THE RECORD.
C                         6 =  THE BEGINNING RECORD NUMBER OF THE DATA 
C                              RECORD IN THE FILE * 1000 +
C                              THE NUMBER OF PHYSICAL RECORDS IN THE LOGICAL
C                              RECORD.
C            CLIST(J) = THE LIST OF FILE NAMES THAT HAVE BEEN OPENED 
C                       (J=1,MAXFIL).
C           CFILSZ(J) = THE PHYSICAL RECORD SIZE IN BYTES OF THE FILES
C                       APPEARING IN CLIST(J) (J=1,MAXFIL).  INITIALLY,
C                       ALL VALUES ARE ZERO.  WHEN A FILE IS OPENED, IT
C                       IS ENTERED IN CLIST( ) AND CFILSZ( ) FROM THE TOP.
C               KOUNT = THE TOTAL NUMBER OF TIMES FLOPNM HAS BEEN ENTERED.
C              MAXOPN = THE MAXIMUM NUMBER OF DIRECT ACCESS FILES THAT
C                       CAN BE OPEN IN THIS MOS-2000 EXTERNAL DIRECT
C                       ACCESS FILE SYSTEM.  (SET BY PARAMETER)
C              MAXFIL = THE MAXIMUM NUMBER OF ENTRIES IN CLIST( ) AND
C                       CFILSZ( ).  (SET BY PARAMETER)
C                  NW = THE MAXIMUM NUMBER OF ENTRIES IN ANY KEY RECORD
C                       BEING USED IN THIS RUN. 840 WILL ACCOMMODATE A
C                       20,000 BYTE RECORD.  (SET BY PARAMETER)
C            CONVERTX = CHARACTER HOLDING THE KEYWORD USED TO OPEN
C                       RANDOM ACCESS FILE WITH THE CORRECT ENDIAN.
C                       (CHARACTER*20).
C              IRAEND = INTEGER VALUE THAT REPRESENTS THE ENDIAN OF
C                       A RANDOM ACCESS FILE.
C                        -1 = LITTLE-ENDIAN
C                         1 = BIG-ENDIAN
C           NRAEND(N) = HOLDS THE VALUE IRAEND FOR RA FILES THAT
C                       ARE OPEN, (N=1,MAXOPN).
C
C 
C        NON SYSTEM SUBROUTINES USED 
C            CKRAEND, CLFILM, WRKEYM, RDKEYM, TDLPRM (/D ONLY)
C 
      PARAMETER (MAXOPN=2,
     1           MAXFIL=20, 
     2           NW=840) 
C
      CHARACTER*1024 CFILX,CFILE,CLIST
C
      COMMON/ARGC/NOPEN(MAXOPN),LSTRD(2,MAXOPN),CFILE(MAXOPN),
     1            KUSE(MAXOPN),NIRW(MAXOPN),MASTER(7,MAXOPN),
     2            NOPREC(6,MAXOPN),KEYREC(6,NW,MAXOPN),
     3            CLIST(MAXFIL),NFILSZ(MAXFIL),KOUNT,
     4            NRAEND(MAXOPN)
C
      DATA IFIRST/0/
CINTEL
      CHARACTER(LEN=20) :: CONVERTX
      CONVERTX='BIG_ENDIAN'
CINTEL
C
      IER=0
C
C        IF THIS IS THE FIRST TIME INTO FLOPNM, INITIALIZE PORTIONS
C        OF COMMON BLOCK ARGC.
C
      IF(IFIRST.EQ.0)THEN
         CALL ARINIT(KFILDO,NOPEN,LSTRD,CFILE,KUSE,NIRW,MASTER,
     1               NOPREC,KEYREC,CLIST,NFILSZ,KOUNT,
     2               MAXOPN,MAXFIL,NW,NRAEND)
CD        CALL TDLPRM(KFILDO,'FLOP 00 ')
C
         IFIRST=1
      ENDIF 
C 
C        UPDATE KOUNT.  EVERY FILE ACCESS COMES THROUGH FLOPNM. 
C 
      KOUNT=KOUNT+1 
C        IT IS ASSUMED KOUNT DOES NOT EXCEED INTEGER LIMIT.
C 
C        INITIALIZE NRW TO IRW.  NRW IS MODIFIED IN FLOPNM, AND WE DON'T
C        WANT TO MODIFY IRW BECAUSE IT MAY BE A CONSTANT IN THE CALLING
C        PROGRAM.
C
      NRW=IRW
C        NRW = 1 WHEN READING IS EXPECTED.
C        NRW = 2 WHEN WRITING IS EXPTECTED.
C     
      DO 119 N=1,MAXOPN 
      IF(NOPEN(N).EQ.KFILX)GO TO 125 
 119  CONTINUE 
C 
      GO TO 160 
C 
C        KFILX IS IN USE FOR SLOT N.  IS IT FOR FILE TYPE IOPT? 
C 
 125  IF(CFILX.NE.CFILE(N))GO TO 140 
C        FILE NAME MATCHES.  DOES FILE HAVE TO BE REOPENED FOR WRITING?
C
      IF(NIRW(N).EQ.1.AND.IRW.EQ.2)GO TO 150
C        WHEN ABOVE TEST IS MET, FILE IS OPEN FOR READ ONLY AND WE NEED
C        TO WRITE.  MUST CLOSE AND REOPEN IT.
C
C        A TRANSFER TO 229 MEANS THE FILE NEEDED IS OPEN IN SLOT N AND
C        A MASTER KEY RECORD IS ASSUMED TO BE IN MASTER( ,N).  ANY FILE
C        OPEN WILL HAVE BOTH A MASTER KEY RECORD AND A KEY RECORD
C        IN KEYREC( , ,N) AVAILABLE.  ENTRIES WILL ALSO EXIST IN
C        NFILSZ( ) AND CLIST( ).
CINTEL
C        RETRIEVE THE ENDIAN FLAG OF THE RA FILE IN NRAEND(N)
      IRAEND=NRAEND(N)
CINTEL
      GO TO 229 
C 
C        MUST CLOSE FILE WITH NAME CFILE(N). 
C 
 140  KF=NOPEN(N)
C        DON'T USE NOPEN(N) IN CALL; IT IS MODIFIED IN CLFM. 
      CALL CLFM(KFILDO,KF,CFILE(N),NOPEN(N),NOPREC(1,N),MASTER(1,N),
     1          LSTRD(1,N),KEYREC(1,1,N),NW,IER) 
      IF(IER.NE.0)GO TO 902 
      NRW=NIRW(N)
      IF(IRW.EQ.2)NRW=2
C        ABOVE TWO STATEMENTS CAUSE OPENING OF FILE FOR BOTH READING
C        AND WRITING WHEN FILE WAS ALREADY OPEN FOR BOTH READING AND WRITING
C        OR 2) WRITING IS EXPPECTED BY CALLING PROGRAM. 
      GO TO 185 
C 
C        MUST CLOSE FILE ON UNIT NUMBER KFILX. 
C 
 150  CALL CLFM(KFILDO,KFILX,CFILE(N),NOPEN(N),NOPREC(1,N),MASTER(1,N),
     1          LSTRD(1,N),KEYREC(1,1,N),NW,IER)
      IF(IER.NE.0)GO TO 902 
      GO TO 185 
C 
C        UNIT KFILX IS NOT OPEN.  IS FILE NAME IN USE? 
C 
 160  DO 170 N=1,MAXOPN 
      IF(CFILX.NE.CFILE(N))GO TO 170 
C 
      GO TO 180 
 170  CONTINUE 
C 
      GO TO 185 
C 
C        CFILX FILE NAME IS IN USE.  CLOSE FILE. 
C 
 180  KF=NOPEN(N) 
C        DON'T USE NOPEN(N) IN CALL; IT IS MODIFIED IN CLFM. 
      CALL CLFM(KFILDO,KF,CFILE(N),NOPEN(N),NOPREC(1,N),MASTER(1,N),
     1          LSTRD(1,N),KEYREC(1,1,N),NW,IER) 
      IF(IER.NE.0)GO TO 902 
C 
C        FIND SLOT TO OPEN FILE INTO. 
C 
 185  DO 190 N=1,MAXOPN 
      IF(NOPEN(N).EQ.9999)GO TO 196 
 190  CONTINUE 
C 
C        MUST CLOSE A FILE.  CLOSE THE ONE WITH LOWEST USE COUNT. 
C 
      N=1 
      IF(MAXOPN.LE.1)GO TO 195 
      LOW=KUSE(1) 
C 
      DO 193 J=2,MAXOPN 
      IF(KUSE(J).GT.LOW)GO TO 193 
      N=J 
      LOW=KUSE(J) 
 193  CONTINUE 
C 
 195  KF=NOPEN(N) 
C        DON'T USE NOPEN(N) IN CALL; IT IS MODIFIED IN CLFM. 
      CALL CLFM(KFILDO,KF,CFILE(N),NOPEN(N),NOPREC(1,N),MASTER(1,N),
     1          LSTRD(1,N),KEYREC(1,1,N),NW,IER) 
      IF(IER.NE.0)GO TO 902 
C 
C        OPEN FILE CFILE ON UNIT KFILX.  N IS SLOT.  DETERMINE,
C        IF THE FILE HAS BEEN OPENED, WHAT THE PHYSICAL RECORD
C        SIZE IS.  IF NOT, USE A SIZE SUFFICIENT TO READ
C        THE MASTER KEY RECORD.  THIS MEANS THAT EACH FILE,
C        READ FOR THE FIRST TIME, MUST BE OPENED TWICE.
C
 196  DO 197 J=1,MAXFIL
      IF(NFILSZ(J).EQ.0)GO TO 198
C        ENTRIES TO NFILSZ( ) AND CLIST( ) ARE MADE FROM THE TOP.
C        WHENEVER NFILSZ( ) = 0 IS FOUND, THE LIST OF FILES THAT
C        HAVE BEEN OPENED IS ABOVE THAT.
C
      IF(CFILX.EQ.CLIST(J))THEN
         NBYTES=NFILSZ(J)
         GO TO 200
      ENDIF
C
 197  CONTINUE
C
C        COULD NOT FIND RECORD SIZE.  PUNT.
CINTEL
 198  NBYTES=6*L3264B/8      
C
C        CHECK ENDIAN OF RA FILE.
C
 200  CALL CKRAEND(KFILDO,KFILX,CFILX,ISYSEND,IRAEND,
     1             CONVERTX,IER)
      NRAEND(N)=IRAEND
CINTEL
C        USE THE ABOVE VALUE UNTIL THE CORRECT ONE IS READ.
C
      IF(NRW.EQ.1)THEN
C 200  IF(NRW.EQ.1)THEN
CD        WRITE(KFILDO,2002)KFILX,NBYTES,CFILX
CD2002    FORMAT(' OPENING FILE ON UNIT NO. =',I3,
CD    1          ' FOR READ ONLY IN FLOPNM, PHYSICAL RECORD',
CD    2          ' SIZE IN BYTES =',I6/'    FILE NAME = ',A60)
         OPEN(UNIT=KFILX,FILE=CFILX,CONVERT=CONVERTX,
     1      STATUS='OLD',ACCESS='DIRECT',RECL=NBYTES, 
     2      ACTION='READ',IOSTAT=IOS,ERR=890)
C
      ELSEIF(NRW.EQ.2)THEN
CD        WRITE(KFILDO,2003)KFILX,NBYTES,CFILX
CD2003    FORMAT(' OPENING FILE ON UNIT NO. =',I3,
CD    1          ' FOR READWRITE IN FLOPNM, PHYSICAL RECORD',
CD    2          ' SIZE IN BYTES =',I6/'    FILE NAME = ',A60)
         OPEN(UNIT=KFILX,FILE=CFILX,CONVERT=CONVERTX,
     1      STATUS='OLD',ACCESS='DIRECT',RECL=NBYTES,
     2      IOSTAT=IOS,ERR=890)
      ELSE
         WRITE(KFILDO,2005)NRW
 2005    FORMAT(/' ****NRW =',I4,' IN FLOPNM NOT CORRECT VALUE.',
     1           '  IT MUST BE 1 OR 2.  FILE NOT OPENED.')
         IER=151
         WRITE(KFILDO,2006)NRW
 2006    FORMAT(/' ****NRW =',I4,' IN FLOPNM NE 1 OR 2.')
         GO TO 902
C
      ENDIF   
C
      CFILE(N)=CFILX 
      NOPEN(N)=KFILX 
      NOPREC(1,N)=0
      NIRW(N)=NRW
C 
C        READ MASTER KEY RECORD.  IT IS ASSUMED THE RECORD SIZE IS GE 
C        6 INTEGER WORDS. 
C 
      READ(KFILX,REC=1,IOSTAT=IOS,ERR=900)(MASTER(J,N),J=1,6) 
      MASTER(7,N)=0 
      LBYTES=MASTER(3,N)*L3264B/8
      IF(LBYTES.EQ.NBYTES)GO TO 220
      WRITE(KFILDO,219)KFILX,NBYTES,LBYTES
 219  FORMAT(/' FILE ON UNIT NO.',I5,' OPENED WITH A RECORD SIZE =',I8,
     1        ' BYTES.'/
     2        '   WILL CLOSE FILE AND REOPEN WITH A RECORD SIZE =',I8,
     3        ' BYTES.')
      CLOSE(KFILX)
      NBYTES=LBYTES
      GO TO 200
C
C        MAKE ENTRY INTO NFILSZ( ) AND CLIST( ), WHEN NEEDED.
C
 220  DO 2200 J=1,MAXFIL
C
      IF(CFILX.EQ.CLIST(J))GO TO 221
C
      IF(NFILSZ(J).EQ.0)THEN
         NFILSZ(J)=NBYTES
         CLIST(J)=CFILX
         GO TO 221
      ENDIF
C
 2200 CONTINUE
C
C        NO ROOM LEFT IN NFILSZ( ) AND CLIST( ).  MUST BE NEAR THE
C        END OF THE RUN.  ASSUME THE FILE WILL REMAIN OPEN AND
C        DON'T REPLACE ONE OF THE ITEMS.
      WRITE(KFILDO,2205)
 2205 FORMAT(/' ****NO OPEN SLOTS IN CLIST( ) ARE AVAILABLE.',
     1        '  THIS IS NO REAL PROBLEM UNLESS IT HAPPENS MANY TIMES.')
C
C        ARRANGE FOR A KEY RECORD TO BE IN KEYREC( , ,N). 
C
 221  IF(NRW.EQ.1)LREC=2
C        WHEN READING IS EXPECTED, READ THE FIRST KEY RECORD.
      IF(NRW.EQ.2)LREC=MASTER(6,N)
C        WHEN WRITING IS EXPECTED, READ THE LAST KEY RECORD.
C        NRW MUST BE 1 OR 2, AND WILL NOT GET HERE UNLESS THIS IS SO. 
C     WRITE(KFILDO,2248)IRW,LREC,((MASTER(M1,M2),M1=2,7),M2=1,MAXOPN)
C2248 FORMAT(' FLOPNM',2I8/(6I5,6X,6I5))
      CALL RDKEYM(KFILDO,KFILX,LREC,NOPREC(1,N),KEYREC(1,1,N),
     1            MASTER(5,N)*6,NW,MASTER(3,N),'FLOPNM ',IER) 
      IF(IER.NE.0)GO TO 902 
C
      LSTRD(1,N)=LREC
      LSTRD(2,N)=0
      NOPREC(1,N)=N
      NOPREC(2,N)=LREC
      NOPREC(4,N)=0
C        NOPREC(3,N), NOPREC(5,N), AND NOPREC(6,N) ARE
C        FILLED BY RDKEY. 
 229  KUSE(N)=KOUNT
      NT=N 
CD     CALL TDLPRM(KFILDO,'FLOP 09 ')
      GO TO 902 
C 
C        THIS SECTION FOR SYSTEM ERROR DIAGNOSTICS. 
C
 890  WRITE(KFILDO,891)IOS,CFILX
 891  FORMAT(/' ****ERROR IOSTAT =',I5,' IN FLOPNM OPENING FILE',
     1        ' WITH NAME ',A60)
      IER=IOS
      GO TO 902
C 
 900  WRITE(KFILDO,901)IOS,CFILX
 901  FORMAT(/' ****ERROR IOSTAT =',I5,' IN FLOPNM READING FILE',
     1        ' WITH NAME ',A60)
      IER=IOS
C
 902  RETURN  
      END 
