# coding: utf-8

"""
    Persons Registry API

    This is a API to Persons Registry  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: info@sysnet.cz
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from persons.api_client import ApiClient


class PublicApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_individual(self, identifier, **kwargs):  # noqa: E501
        """odstraní registrační dokument jednotlivce s daným identifikátorem (cruD)  # noqa: E501

        Na základě identifikátoru odstraní registrační dokument jednotlivce Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_individual(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param bool softdelete: Vratné odstranění
        :param bool undelete: Obnoví vratně odstraněný dokument
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_individual_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_individual_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def delete_individual_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """odstraní registrační dokument jednotlivce s daným identifikátorem (cruD)  # noqa: E501

        Na základě identifikátoru odstraní registrační dokument jednotlivce Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_individual_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param bool softdelete: Vratné odstranění
        :param bool undelete: Obnoví vratně odstraněný dokument
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'softdelete', 'undelete']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_individual" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `delete_individual`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'softdelete' in params:
            query_params.append(('softdelete', params['softdelete']))  # noqa: E501
        if 'undelete' in params:
            query_params.append(('undelete', params['undelete']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/individual/{identifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='bool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_person(self, identifier, **kwargs):  # noqa: E501
        """odstraní registrační dokument subjektu s daným identifikátorem (cruD)  # noqa: E501

        Na základě identifikátoru odstraní registrační dokument subjektu Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_person(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param bool softdelete: Vratné odstranění
        :param bool undelete: Obnoví vratně odstraněný dokument
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_person_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_person_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def delete_person_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """odstraní registrační dokument subjektu s daným identifikátorem (cruD)  # noqa: E501

        Na základě identifikátoru odstraní registrační dokument subjektu Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_person_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param bool softdelete: Vratné odstranění
        :param bool undelete: Obnoví vratně odstraněný dokument
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'softdelete', 'undelete']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_person" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `delete_person`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'softdelete' in params:
            query_params.append(('softdelete', params['softdelete']))  # noqa: E501
        if 'undelete' in params:
            query_params.append(('undelete', params['undelete']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/person/{identifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='bool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_role(self, identifier, **kwargs):  # noqa: E501
        """odstraní roli s daným identifikátorem (cruD)  # noqa: E501

        Na základě identifikátoru odstraní dokument typu evidenční list Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param bool softdelete: Vratné odstranění
        :param bool undelete: Obnoví vratně odstraněný dokument
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_role_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_role_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def delete_role_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """odstraní roli s daným identifikátorem (cruD)  # noqa: E501

        Na základě identifikátoru odstraní dokument typu evidenční list Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_role_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param bool softdelete: Vratné odstranění
        :param bool undelete: Obnoví vratně odstraněný dokument
        :return: bool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'softdelete', 'undelete']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `delete_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'softdelete' in params:
            query_params.append(('softdelete', params['softdelete']))  # noqa: E501
        if 'undelete' in params:
            query_params.append(('undelete', params['undelete']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/role/{identifier}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='bool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_context(self, identifier, **kwargs):  # noqa: E501
        """vrací kontext jednotlivce  # noqa: E501

        Na základě identifikátoru vrací kontext jednotlivce  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_context(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátor jednotlivce (required)
        :return: ContextType
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_context_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_context_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_context_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """vrací kontext jednotlivce  # noqa: E501

        Na základě identifikátoru vrací kontext jednotlivce  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_context_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátor jednotlivce (required)
        :return: ContextType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_context" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_context`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/context/{identifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ContextType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_individual(self, identifier, **kwargs):  # noqa: E501
        """vrací registrační dokument jednotlivce s daným identifikátorem (cRud)  # noqa: E501

        Na základě identifikátoru vrátí dokument typu individual Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_individual(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid, v případě verze ID verze (required)
        :return: IndividualType
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_individual_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_individual_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_individual_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """vrací registrační dokument jednotlivce s daným identifikátorem (cRud)  # noqa: E501

        Na základě identifikátoru vrátí dokument typu individual Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_individual_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid, v případě verze ID verze (required)
        :return: IndividualType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_individual" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_individual`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/individual/{identifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IndividualType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_individual_list(self, **kwargs):  # noqa: E501
        """vrací seznam jednotlivců (autocomplete)  # noqa: E501

        Vrátí dokumenty typu inividual odpovádající klíči nebo fulltextovému dotazu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_individual_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Vyhledání podle klíče - autocomplete
        :param str tag: Vyhledání podle tagu
        :param str reference: Vyhledání podle reference (CRŽP)
        :param str search: Textové vyhledávání
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_individual_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_individual_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_individual_list_with_http_info(self, **kwargs):  # noqa: E501
        """vrací seznam jednotlivců (autocomplete)  # noqa: E501

        Vrátí dokumenty typu inividual odpovádající klíči nebo fulltextovému dotazu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_individual_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Vyhledání podle klíče - autocomplete
        :param str tag: Vyhledání podle tagu
        :param str reference: Vyhledání podle reference (CRŽP)
        :param str search: Textové vyhledávání
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key', 'tag', 'reference', 'search', 'start', 'page_size', 'page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_individual_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'reference' in params:
            query_params.append(('reference', params['reference']))  # noqa: E501
        if 'search' in params:
            query_params.append(('search', params['search']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/individual', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentEntryList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_person(self, identifier, **kwargs):  # noqa: E501
        """vrací registrační dokument subjektu s daným identifikátorem (cRud)  # noqa: E501

        Na základě identifikátoru vrátí dokument typu person Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_person(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid, v případě verze ID verze (required)
        :return: PersonType
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_person_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_person_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_person_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """vrací registrační dokument subjektu s daným identifikátorem (cRud)  # noqa: E501

        Na základě identifikátoru vrátí dokument typu person Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_person_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid, v případě verze ID verze (required)
        :return: PersonType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_person" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_person`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/person/{identifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PersonType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_person_list(self, **kwargs):  # noqa: E501
        """vrací seznam subjektů (autocomplete)  # noqa: E501

        Vrátí dokumenty typu person odpovádající klíči nebo fulltextovému dotazu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_person_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Vyhledání podle klíče - autocomplete
        :param str tag: Vyhledání podle tagu
        :param str search: Textové vyhledávání
        :param str reference: Vyhledání podle reference (CRŽP)
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_person_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_person_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_person_list_with_http_info(self, **kwargs):  # noqa: E501
        """vrací seznam subjektů (autocomplete)  # noqa: E501

        Vrátí dokumenty typu person odpovádající klíči nebo fulltextovému dotazu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_person_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Vyhledání podle klíče - autocomplete
        :param str tag: Vyhledání podle tagu
        :param str search: Textové vyhledávání
        :param str reference: Vyhledání podle reference (CRŽP)
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key', 'tag', 'search', 'reference', 'start', 'page_size', 'page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_person_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'search' in params:
            query_params.append(('search', params['search']))  # noqa: E501
        if 'reference' in params:
            query_params.append(('reference', params['reference']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/person', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentEntryList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_role(self, identifier, **kwargs):  # noqa: E501
        """vrací roli s daným identifikátorem (cRud)  # noqa: E501

        Na základě identifikátoru vrátí dokument typu role Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid, v případě verze ID verze (required)
        :param bool items: Vrací seznam nositelů role
        :return: RoleType
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_role_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_role_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_role_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """vrací roli s daným identifikátorem (cRud)  # noqa: E501

        Na základě identifikátoru vrátí dokument typu role Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid, v případě verze ID verze (required)
        :param bool items: Vrací seznam nositelů role
        :return: RoleType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'items']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'items' in params:
            query_params.append(('items', params['items']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/role/{identifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_role_list(self, **kwargs):  # noqa: E501
        """vrací seznam rolí (autocomplete)  # noqa: E501

        Vrátí dokumenty typu role odpovádající klíči nebo fulltextovému dotazu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Vyhledání podle klíče - autocomplete
        :param str tag: Vyhledání podle tagu
        :param str reference: Vyhledání podle reference (CRŽP)
        :param str search: Textové vyhledávání
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_role_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_role_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_role_list_with_http_info(self, **kwargs):  # noqa: E501
        """vrací seznam rolí (autocomplete)  # noqa: E501

        Vrátí dokumenty typu role odpovádající klíči nebo fulltextovému dotazu  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_role_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str key: Vyhledání podle klíče - autocomplete
        :param str tag: Vyhledání podle tagu
        :param str reference: Vyhledání podle reference (CRŽP)
        :param str search: Textové vyhledávání
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :return: DocumentEntryList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['key', 'tag', 'reference', 'search', 'start', 'page_size', 'page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_role_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'reference' in params:
            query_params.append(('reference', params['reference']))  # noqa: E501
        if 'search' in params:
            query_params.append(('search', params['search']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/role', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentEntryList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tag_list(self, **kwargs):  # noqa: E501
        """vrací seznam tagů v systému (autocomplete)  # noqa: E501

        Vrátí všechny tagy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tag_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tag: Vyhledání podle tagu
        :param str search: Textové vyhledávání
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :return: list[TagItemType]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tag_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_tag_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_tag_list_with_http_info(self, **kwargs):  # noqa: E501
        """vrací seznam tagů v systému (autocomplete)  # noqa: E501

        Vrátí všechny tagy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tag_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tag: Vyhledání podle tagu
        :param str search: Textové vyhledávání
        :param int start: První dokument na stránce
        :param int page_size: Velikost stránky při stránkovaném výstupu
        :param int page: Číslo stránky výstupu
        :return: list[TagItemType]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tag', 'search', 'start', 'page_size', 'page']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tag_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'search' in params:
            query_params.append(('search', params['search']))  # noqa: E501
        if 'start' in params:
            query_params.append(('start', params['start']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/tag', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TagItemType]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_individual(self, **kwargs):  # noqa: E501
        """vytvoří nový egistrační záznam jednotlivého uživatele  (Crud)  # noqa: E501

        Vytvoří nový dokument typu individual  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_individual(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IndividualType body:
        :return: IndividualType
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_individual_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.post_individual_with_http_info(**kwargs)  # noqa: E501
            return data

    def post_individual_with_http_info(self, **kwargs):  # noqa: E501
        """vytvoří nový egistrační záznam jednotlivého uživatele  (Crud)  # noqa: E501

        Vytvoří nový dokument typu individual  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_individual_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param IndividualType body:
        :return: IndividualType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_individual" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/individual', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IndividualType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_person(self, **kwargs):  # noqa: E501
        """vytvoří nový registrační záznam subjektu (Crud)  # noqa: E501

        Vytvoří nový dokument typu person  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_person(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PersonType body:
        :return: PersonType
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_person_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.post_person_with_http_info(**kwargs)  # noqa: E501
            return data

    def post_person_with_http_info(self, **kwargs):  # noqa: E501
        """vytvoří nový registrační záznam subjektu (Crud)  # noqa: E501

        Vytvoří nový dokument typu person  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_person_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PersonType body:
        :return: PersonType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_person" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/person', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PersonType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_role(self, **kwargs):  # noqa: E501
        """vytvoří novou roli  (Crud)  # noqa: E501

        Vytvoří nový dokument typu role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_role(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RoleType body:
        :return: RoleType
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_role_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.post_role_with_http_info(**kwargs)  # noqa: E501
            return data

    def post_role_with_http_info(self, **kwargs):  # noqa: E501
        """vytvoří novou roli  (Crud)  # noqa: E501

        Vytvoří nový dokument typu role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_role_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RoleType body:
        :return: RoleType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_role" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/role', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_individual(self, identifier, **kwargs):  # noqa: E501
        """aktualizuje registrační dokument jednotlivce s daným identifikátorem (crUd)  # noqa: E501

        Na základě identifikátoru aktualizuje dokument typu role Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_individual(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param IndividualType body:
        :return: IndividualType
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_individual_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.put_individual_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def put_individual_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """aktualizuje registrační dokument jednotlivce s daným identifikátorem (crUd)  # noqa: E501

        Na základě identifikátoru aktualizuje dokument typu role Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_individual_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param IndividualType body:
        :return: IndividualType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_individual" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `put_individual`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/individual/{identifier}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IndividualType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_person(self, identifier, **kwargs):  # noqa: E501
        """aktualizuje registrační dokument subjektu s daným identifikátorem (crUd)  # noqa: E501

        Na základě identifikátoru aktualizuje dokument typu subjekt Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_person(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param PersonType body:
        :return: IndividualType
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_person_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.put_person_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def put_person_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """aktualizuje registrační dokument subjektu s daným identifikátorem (crUd)  # noqa: E501

        Na základě identifikátoru aktualizuje dokument typu subjekt Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_person_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param PersonType body:
        :return: IndividualType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_person" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `put_person`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/person/{identifier}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IndividualType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_role(self, identifier, **kwargs):  # noqa: E501
        """aktualizuje roli s daným identifikátorem (crUd)  # noqa: E501

        Na základě identifikátoru aktualizuje dokument typu role Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_role(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param RoleType body:
        :return: RoleType
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_role_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.put_role_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def put_role_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """aktualizuje roli s daným identifikátorem (crUd)  # noqa: E501

        Na základě identifikátoru aktualizuje dokument typu role Identifikátorem může být PID, UNID nebo uuid|   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_role_with_http_info(identifier, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str identifier: Identifikátorem může být PID, UNID nebo uuid (required)
        :param RoleType body:
        :return: RoleType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `put_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/role/{identifier}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RoleType',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
