# persons
This is a API to Persons Registry

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import persons 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import persons
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import persons
from persons.rest import ApiException
from pprint import pprint

# Configure API key authorization: apiKey
configuration = persons.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = persons.AdminsApi(persons.ApiClient(configuration))
name = 'name_example' # str | Název tagu

try:
    # odstraní definici tagu  (cruD)
    api_response = api_instance.delete_tag(name)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->delete_tag: %s\n" % e)

# Configure API key authorization: apiKey
configuration = persons.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = persons.AdminsApi(persons.ApiClient(configuration))

try:
    # získá konfiguraci konektoru
    api_response = api_instance.get_config()
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->get_config: %s\n" % e)

# Configure API key authorization: apiKey
configuration = persons.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = persons.AdminsApi(persons.ApiClient(configuration))
name = 'name_example' # str | Název tagu

try:
    # vrací definici tagu (cRud)
    api_response = api_instance.get_tag(name)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->get_tag: %s\n" % e)

# Configure API key authorization: apiKey
configuration = persons.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = persons.AdminsApi(persons.ApiClient(configuration))
tag = 'tag_example' # str | Vyhledání podle tagu (optional)
search = 'search_example' # str | Textové vyhledávání (optional)
start = 56 # int | První dokument na stránce (optional)
page_size = 56 # int | Velikost stránky při stránkovaném výstupu (optional)
page = 56 # int | Číslo stránky výstupu (optional)

try:
    # vrací seznam tagů v systému (autocomplete)
    api_response = api_instance.get_tag_list(tag=tag, search=search, start=start, page_size=page_size, page=page)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->get_tag_list: %s\n" % e)

# Configure API key authorization: apiKey
configuration = persons.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = persons.AdminsApi(persons.ApiClient(configuration))
body = persons.TagItemType() # TagItemType |  (optional)

try:
    # vytvoří nový tag (Crud)
    api_response = api_instance.post_tag(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->post_tag: %s\n" % e)

# Configure API key authorization: apiKey
configuration = persons.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = persons.AdminsApi(persons.ApiClient(configuration))
body = persons.ConfigBody() # ConfigBody |  (optional)

try:
    # aktualizuje hlavní konfiguraci konektoru
    api_response = api_instance.put_config(body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->put_config: %s\n" % e)

# Configure API key authorization: apiKey
configuration = persons.Configuration()
configuration.api_key['X-API-KEY'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['X-API-KEY'] = 'Bearer'

# create an instance of the API class
api_instance = persons.AdminsApi(persons.ApiClient(configuration))
name = 'name_example' # str | Název tagu
body = persons.TagItemType() # TagItemType |  (optional)

try:
    # aktualizuje definici tagu (crUd)
    api_response = api_instance.put_tag(name, body=body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling AdminsApi->put_tag: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://service.sysnet.cz/persons/1.0.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AdminsApi* | [**delete_tag**](docs/AdminsApi.md#delete_tag) | **DELETE** /tag/{name} | odstraní definici tagu  (cruD)
*AdminsApi* | [**get_config**](docs/AdminsApi.md#get_config) | **GET** /config | získá konfiguraci konektoru
*AdminsApi* | [**get_tag**](docs/AdminsApi.md#get_tag) | **GET** /tag/{name} | vrací definici tagu (cRud)
*AdminsApi* | [**get_tag_list**](docs/AdminsApi.md#get_tag_list) | **GET** /tag | vrací seznam tagů v systému (autocomplete)
*AdminsApi* | [**post_tag**](docs/AdminsApi.md#post_tag) | **POST** /tag | vytvoří nový tag (Crud)
*AdminsApi* | [**put_config**](docs/AdminsApi.md#put_config) | **PUT** /config | aktualizuje hlavní konfiguraci konektoru
*AdminsApi* | [**put_tag**](docs/AdminsApi.md#put_tag) | **PUT** /tag/{name} | aktualizuje definici tagu (crUd)
*DevelopersApi* | [**info_api**](docs/DevelopersApi.md#info_api) | **GET** /info | vrací servisní informace
*PublicApi* | [**delete_individual**](docs/PublicApi.md#delete_individual) | **DELETE** /individual/{identifier} | odstraní registrační dokument jednotlivce s daným identifikátorem (cruD)
*PublicApi* | [**delete_person**](docs/PublicApi.md#delete_person) | **DELETE** /person/{identifier} | odstraní registrační dokument subjektu s daným identifikátorem (cruD)
*PublicApi* | [**delete_role**](docs/PublicApi.md#delete_role) | **DELETE** /role/{identifier} | odstraní roli s daným identifikátorem (cruD)
*PublicApi* | [**get_context**](docs/PublicApi.md#get_context) | **GET** /context/{identifier} | vrací kontext jednotlivce
*PublicApi* | [**get_individual**](docs/PublicApi.md#get_individual) | **GET** /individual/{identifier} | vrací registrační dokument jednotlivce s daným identifikátorem (cRud)
*PublicApi* | [**get_individual_list**](docs/PublicApi.md#get_individual_list) | **GET** /individual | vrací seznam jednotlivců (autocomplete)
*PublicApi* | [**get_person**](docs/PublicApi.md#get_person) | **GET** /person/{identifier} | vrací registrační dokument subjektu s daným identifikátorem (cRud)
*PublicApi* | [**get_person_list**](docs/PublicApi.md#get_person_list) | **GET** /person | vrací seznam subjektů (autocomplete)
*PublicApi* | [**get_role**](docs/PublicApi.md#get_role) | **GET** /role/{identifier} | vrací roli s daným identifikátorem (cRud)
*PublicApi* | [**get_role_list**](docs/PublicApi.md#get_role_list) | **GET** /role | vrací seznam rolí (autocomplete)
*PublicApi* | [**get_tag_list**](docs/PublicApi.md#get_tag_list) | **GET** /tag | vrací seznam tagů v systému (autocomplete)
*PublicApi* | [**post_individual**](docs/PublicApi.md#post_individual) | **POST** /individual | vytvoří nový egistrační záznam jednotlivého uživatele  (Crud)
*PublicApi* | [**post_person**](docs/PublicApi.md#post_person) | **POST** /person | vytvoří nový registrační záznam subjektu (Crud)
*PublicApi* | [**post_role**](docs/PublicApi.md#post_role) | **POST** /role | vytvoří novou roli  (Crud)
*PublicApi* | [**put_individual**](docs/PublicApi.md#put_individual) | **PUT** /individual/{identifier} | aktualizuje registrační dokument jednotlivce s daným identifikátorem (crUd)
*PublicApi* | [**put_person**](docs/PublicApi.md#put_person) | **PUT** /person/{identifier} | aktualizuje registrační dokument subjektu s daným identifikátorem (crUd)
*PublicApi* | [**put_role**](docs/PublicApi.md#put_role) | **PUT** /role/{identifier} | aktualizuje roli s daným identifikátorem (crUd)

## Documentation For Models

 - [CodeValueType](docs/CodeValueType.md)
 - [ConfigBody](docs/ConfigBody.md)
 - [ContactType](docs/ContactType.md)
 - [ContextType](docs/ContextType.md)
 - [ContextTypePersons](docs/ContextTypePersons.md)
 - [ContextTypeRoles](docs/ContextTypeRoles.md)
 - [DepartmentType](docs/DepartmentType.md)
 - [DocumentEntry](docs/DocumentEntry.md)
 - [DocumentEntryList](docs/DocumentEntryList.md)
 - [DocumentMetadataType](docs/DocumentMetadataType.md)
 - [GeoPointJtskType](docs/GeoPointJtskType.md)
 - [GeoPointType](docs/GeoPointType.md)
 - [IndividualType](docs/IndividualType.md)
 - [IssuingType](docs/IssuingType.md)
 - [LocationType](docs/LocationType.md)
 - [MailAddressType](docs/MailAddressType.md)
 - [MemberType](docs/MemberType.md)
 - [PersonLinkType](docs/PersonLinkType.md)
 - [PersonListItem](docs/PersonListItem.md)
 - [PersonType](docs/PersonType.md)
 - [PhoneNumberType](docs/PhoneNumberType.md)
 - [ReferenceRegistry](docs/ReferenceRegistry.md)
 - [RoleCategoryType](docs/RoleCategoryType.md)
 - [RoleListItem](docs/RoleListItem.md)
 - [RoleType](docs/RoleType.md)
 - [TagItemType](docs/TagItemType.md)
 - [TagType](docs/TagType.md)

## Documentation For Authorization


## apiKey

- **Type**: API key
- **API key parameter name**: X-API-KEY
- **Location**: HTTP header


## Author

info@sysnet.cz
