import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGitlabGroupHookConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID or full path of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_hook#group DataGitlabGroupHook#group}
    */
    readonly group: string;
    /**
    * The id of the group hook.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_hook#hook_id DataGitlabGroupHook#hook_id}
    */
    readonly hookId: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/d/group_hook#id DataGitlabGroupHook#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/d/group_hook gitlab_group_hook}
*/
export declare class DataGitlabGroupHook extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "gitlab_group_hook";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/d/group_hook gitlab_group_hook} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGitlabGroupHookConfig
    */
    constructor(scope: Construct, id: string, config: DataGitlabGroupHookConfig);
    get confidentialIssuesEvents(): cdktf.IResolvable;
    get confidentialNoteEvents(): cdktf.IResolvable;
    get deploymentEvents(): cdktf.IResolvable;
    get enableSslVerification(): cdktf.IResolvable;
    private _group?;
    get group(): string;
    set group(value: string);
    get groupInput(): string | undefined;
    get groupId(): number;
    private _hookId?;
    get hookId(): number;
    set hookId(value: number);
    get hookIdInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get issuesEvents(): cdktf.IResolvable;
    get jobEvents(): cdktf.IResolvable;
    get mergeRequestsEvents(): cdktf.IResolvable;
    get noteEvents(): cdktf.IResolvable;
    get pipelineEvents(): cdktf.IResolvable;
    get pushEvents(): cdktf.IResolvable;
    get pushEventsBranchFilter(): string;
    get releasesEvents(): cdktf.IResolvable;
    get subgroupEvents(): cdktf.IResolvable;
    get tagPushEvents(): cdktf.IResolvable;
    get token(): string;
    get url(): string;
    get wikiPageEvents(): cdktf.IResolvable;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
