#! /usr/bin/python

from setuptools import setup, find_packages
import os.path

VERSION = "0.1.2"

with open(os.path.join(os.path.dirname(__file__), "README.md"), "r") as rf:
    with open(os.path.join(os.path.dirname(__file__), "pieshell", "README.md"), "w") as wf:
        wf.write(rf.read())

with open(os.path.join(os.path.dirname(__file__), "pieshell", "version.py"), "w") as wf:
    wf.write("version = '%s'\n" % (VERSION,)) 
    
setup(
    name = "pieshell",
    description = "Pieshell is a Python shell environment that combines the expressiveness of shell pipelines with the prower of python iterators. It can be used both as an interactive shell and as an ordinary python module replacing e.g. subprocess.Popen",
    keywords = "Python shell pipelines suprocess",
    install_requires = ["signalfd"],
    version = VERSION,
    author = "Egil Moeller",
    author_email = "egil.moller@piratpartiet.se",
    license = "GPL",
    url = "https://github.com/redhog/pieshell",
    packages = find_packages(),
    package_data={'pieshell': ['*.md']},
    entry_points={
        'console_scripts': [
            'pieshell = pieshell.shell:main',
        ],
    },
    scripts = ["contrib/get_completions"]
)
