#!/usr/bin/env python
# -*- coding: utf8 -*-

import sys
import os
import re
import json
from collections import defaultdict
from datetime import datetime
import numpy

from fmqlutils.cacher.cacherUtils import SCHEMA_LOCN_TEMPL 
from fmqlutils.reporter.reportUtils import MarkdownTable, reportPercent, reportAbsAndPercent

from ..webReportUtils import SITE_DIR_TEMPL, TOP_MD_TEMPL

"""
Institutions: https://www.va.gov/directory/Guide/fac_list_by_state.cfm?State=OH&dnum=All

TODO: some lookup of name + DESCRIBE TYPE for 3.081 supplies last day
"""

TEMPL = """## Introduction

Today the Veterans Administration (VA) provides and manages veteran care using <span style='yellowIt'>130</span> deployments of their in-house VistA system. Each VistA is an integrated suite of over one hundred applications sharing a single hierarchal database, FileMan. In deployed VistAs, FileMan holds up to <span style='yellowIt'>2 billion</span> interlinked records of over <span style='yellowIt'>4000</span> different types.

As well as the vast majority of Veteran clinical data, FileMan holds profiles of VA users, financial information, connected device descriptions, interface definitions and usage logs. The integrated and comprehensive nature of FileMan data makes it an ideal target for analysis to inform the migration of veteran care from VistA and into EHRM.

This __\"VistA by the Numbers\"__ report is one of a series, each of which captures the activity of a specific active VA VistA system. Each is generated by a framework for VistA analytics that first caches relevant data from a FileMan and then generates appropriate system descriptions. Such automation ensures common criteria for analysis and the ability to cover all <span style='yellowIt'>130</span> systems deployed in VA even as additional criteria are added to the framework over time.

This report describes __{}__ which has VA identifier or station number {}. Specifically, it describes a clone cut on {} and housed in the VAEC.
"""

def webReportIntro(stationNo):

    systemName = "{NEED NAME}" # ex/ Mann Grandstaff (Spokane) VistA
    
    lastSignInDay = "" # NEED DESCRIBE TYPE of 3.081 with "lastIEN"

    mu = TEMPL.format(
        systemName,
        stationNo,
        lastSignInDay
    )

# ################################# DRIVER #######################
               
def main():

    assert sys.version_info >= (3, 4)

    try:
        stationNo = sys.argv[1]
    except IndexError:
        raise SystemExit("Usage _EXE_ STATIONNO")

    userSiteDir = SITE_DIR_TEMPL.format(stationNo)
    if not os.path.isdir(userSiteDir):
        raise SystemExit("Expect User Site to already exist with its basic contents")

    webReportIntro(stationNo)
    
if __name__ == "__main__":
    main()
