// Copyright (c) Mito
import React from 'react';
import DefaultTaskpane from '../DefaultTaskpane/DefaultTaskpane';
import PivotTableKeySelection from './PivotTableKeySelection';
import PivotTableValueSelection from './PivotTableValueSelection';
import { getPivotFrontendParamsFromBackendParams, getPivotBackendParamsFromFrontendParams, getDefaultPivotParams } from './pivotUtils';
import { AggregationType, StepType } from '../../../types';
import DefaultTaskpaneHeader from '../DefaultTaskpane/DefaultTaskpaneHeader';
import DefaultTaskpaneBody from '../DefaultTaskpane/DefaultTaskpaneBody';
import DefaultEmptyTaskpane from '../DefaultTaskpane/DefaultEmptyTaskpane';
import DataframeSelect from '../../elements/DataframeSelect';
import useLiveUpdatingParams from '../../../hooks/useLiveUpdatingParams';
const PivotTaskpane = (props) => {
    const { params, setParams } = useLiveUpdatingParams(() => getDefaultPivotParams(props.sheetDataArray, props.sourceSheetIndex, props.existingPivotParams), StepType.Pivot, props.mitoAPI, props.analysisData, 0, {
        getBackendFromFrontend: getPivotBackendParamsFromFrontendParams,
        getFrontendFromBackend: getPivotFrontendParamsFromBackendParams
    }, {
        // If we have a destination sheet index, we make sure to not overwrite the pivot
        // that is there by default
        doNotSendDefaultParams: props.destinationSheetIndex !== undefined,
    });
    if (params === undefined) {
        return React.createElement(DefaultEmptyTaskpane, { setUIState: props.setUIState });
    }
    const addPivotValueAggregation = (columnID) => {
        setParams(oldPivotParams => {
            const newPivotValuesIDs = [...oldPivotParams.pivotValuesColumnIDsArray];
            newPivotValuesIDs.push([columnID, AggregationType.COUNT]);
            return Object.assign(Object.assign({}, oldPivotParams), { pivotValuesColumnIDsArray: newPivotValuesIDs });
        });
    };
    const removePivotValueAggregation = (valueIndex) => {
        setParams(oldPivotParams => {
            const newPivotValuesIDs = [...oldPivotParams.pivotValuesColumnIDsArray];
            newPivotValuesIDs.splice(valueIndex, 1);
            return Object.assign(Object.assign({}, oldPivotParams), { pivotValuesColumnIDsArray: newPivotValuesIDs });
        });
    };
    const editPivotValueAggregation = (valueIndex, newAggregationType, newColumnID) => {
        setParams(oldPivotParams => {
            const newPivotValuesIDs = [...oldPivotParams.pivotValuesColumnIDsArray];
            newPivotValuesIDs[valueIndex] = [newColumnID, newAggregationType];
            return Object.assign(Object.assign({}, oldPivotParams), { pivotValuesColumnIDsArray: newPivotValuesIDs });
        });
    };
    const addKey = (rowOrColumn, columnID) => {
        setParams(oldPivotParams => {
            const newColumnIDs = rowOrColumn === 'row' ? [...params.pivotRowColumnIDs] : [...params.pivotColumnsColumnIDs];
            const key = rowOrColumn === 'row' ? 'pivotRowColumnIDs' : 'pivotColumnsColumnIDs';
            newColumnIDs.push(columnID);
            return Object.assign(Object.assign({}, oldPivotParams), { [key]: newColumnIDs });
        });
    };
    const removeKey = (rowOrColumn, keyIndex) => {
        setParams(oldPivotParams => {
            const newColumnIDs = rowOrColumn === 'row' ? [...params.pivotRowColumnIDs] : [...params.pivotColumnsColumnIDs];
            const key = rowOrColumn === 'row' ? 'pivotRowColumnIDs' : 'pivotColumnsColumnIDs';
            newColumnIDs.splice(keyIndex, 1);
            return Object.assign(Object.assign({}, oldPivotParams), { [key]: newColumnIDs });
        });
    };
    const editKey = (rowOrColumn, keyIndex, newColumnID) => {
        setParams(oldPivotParams => {
            const newColumnIDs = rowOrColumn === 'row' ? [...params.pivotRowColumnIDs] : [...params.pivotColumnsColumnIDs];
            const key = rowOrColumn === 'row' ? 'pivotRowColumnIDs' : 'pivotColumnsColumnIDs';
            newColumnIDs[keyIndex] = newColumnID;
            return Object.assign(Object.assign({}, oldPivotParams), { [key]: newColumnIDs });
        });
    };
    const sheetData = props.sheetDataArray[params.sourceSheetIndex];
    const columnIDsMap = props.columnIDsMapArray[params.sourceSheetIndex] || {}; // Make sure it's not undefined
    return (React.createElement(DefaultTaskpane, null,
        React.createElement(DefaultTaskpaneHeader, { header: props.destinationSheetIndex ?
                `Edit Pivot Table ${props.dfNames[props.destinationSheetIndex]}`
                : `Create Pivot Table ${props.dfNames[props.dfNames.length - 1]}`, setUIState: props.setUIState }),
        React.createElement(DefaultTaskpaneBody, null,
            React.createElement(DataframeSelect, { title: 'Dataframe to pivot', sheetDataArray: props.sheetDataArray, sheetIndex: params.sourceSheetIndex, onChange: (newSheetIndex) => {
                    // Set the selected index, and reset to the default params (taking no existing params)
                    const newParams = getDefaultPivotParams(props.sheetDataArray, newSheetIndex, undefined);
                    setParams(prevParams => {
                        return newParams || prevParams;
                    });
                }, sheetIndexToIgnore: props.destinationSheetIndex }),
            React.createElement("div", { className: 'default-taskpane-body-section-div' },
                React.createElement(PivotTableKeySelection, { sectionTitle: 'Rows', columnIDsMap: columnIDsMap, selectedColumnIDs: params.pivotRowColumnIDs, addKey: (columnID) => { addKey('row', columnID); }, removeKey: (keyIndex) => { removeKey('row', keyIndex); }, editKey: (keyIndex, newColumnID) => { editKey('row', keyIndex, newColumnID); }, mitoAPI: props.mitoAPI, rowOrColumn: 'row' })),
            React.createElement("div", { className: 'default-taskpane-body-section-div' },
                React.createElement(PivotTableKeySelection, { sectionTitle: 'Columns', sectionSubtext: 'For best performance, select columns with a small number of unique values.', columnIDsMap: columnIDsMap, selectedColumnIDs: params.pivotColumnsColumnIDs, addKey: (columnID) => { addKey('column', columnID); }, removeKey: (keyIndex) => { removeKey('column', keyIndex); }, editKey: (keyIndex, newColumnID) => { editKey('column', keyIndex, newColumnID); }, mitoAPI: props.mitoAPI, rowOrColumn: 'column' })),
            React.createElement("div", { className: 'default-taskpane-body-section-div' },
                React.createElement(PivotTableValueSelection, { sheetData: sheetData, columnIDsMap: columnIDsMap, pivotValuesColumnIDsArray: params.pivotValuesColumnIDsArray, addPivotValueAggregation: addPivotValueAggregation, removePivotValueAggregation: removePivotValueAggregation, editPivotValueAggregation: editPivotValueAggregation, mitoAPI: props.mitoAPI })))));
};
export default PivotTaskpane;
//# sourceMappingURL=PivotTaskpane.js.map