// Copyright (c) Saga Inc.
import React from 'react';
import LabelAndColor from '../../../pro/graph/LabelAndColor';
import DropdownItem from '../../elements/DropdownItem';
import Input from '../../elements/Input';
import Select from '../../elements/Select';
import Toggle from '../../elements/Toggle';
import Col from '../../layout/Col';
import CollapsibleSection from '../../layout/CollapsibleSection';
import Row from '../../layout/Row';
export var AxisType;
(function (AxisType) {
    AxisType["DEFAULT"] = "default";
    AxisType["LINEAR"] = "linear";
    AxisType["LOG"] = "log";
    AxisType["CATEGORY"] = "category";
    AxisType["DATE"] = "date";
})(AxisType || (AxisType = {}));
/*
    Contains all of the options for styling graphs,
    like setting the title and axis labels
*/
function GraphStyleTab(props) {
    const graphStylingParams = props.graphParams.graphStyling;
    return (React.createElement("div", { className: 'graph-sidebar-toolbar-content' },
        React.createElement(CollapsibleSection, { title: 'Titles' },
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", null, "Graph Title")),
                React.createElement(Input, { value: graphStylingParams.title.title || '', placeholder: "Default Graph Title", onChange: (e) => {
                        props.setGraphParams(prevGraphParams => {
                            const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                            // We set it to undefined so that the backend knows we're not trying to set a custom axis label 
                            const newTitle = e.target.value !== '' ? e.target.value : undefined;
                            return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { title: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.title), { title: newTitle }) }) });
                        });
                        props.setGraphUpdatedNumber(old => old + 1);
                    } })),
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", null, "X Axis Title")),
                React.createElement(Input, { value: graphStylingParams.xaxis.title || '', placeholder: "Default X Axis", onChange: (e) => {
                        props.setGraphParams(prevGraphParams => {
                            const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                            // We set it to undefined so that the backend knows we're not trying to set a custom axis label 
                            const newTitle = e.target.value !== '' ? e.target.value : undefined;
                            return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { xaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.xaxis), { title: newTitle }) }) });
                        });
                        props.setGraphUpdatedNumber(old => old + 1);
                    } })),
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", null, "Y Axis Title")),
                React.createElement(Input, { value: graphStylingParams.yaxis.title || '', placeholder: "Default Y Axis", onChange: (e) => {
                        props.setGraphParams(prevGraphParams => {
                            const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                            const newTitle = e.target.value !== '' ? e.target.value : undefined;
                            return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { yaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.yaxis), { title: newTitle }) }) });
                        });
                        props.setGraphUpdatedNumber(old => old + 1);
                    } })),
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", null, "Display Title")),
                React.createElement(Toggle, { value: graphStylingParams.title.visible, onChange: () => {
                        props.setGraphParams(prevGraphParams => {
                            const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                            return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { title: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.title), { visible: !graphParamsCopy.graphStyling.title.visible }) }) });
                        });
                        props.setGraphUpdatedNumber(old => old + 1);
                    } })),
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", null, "Display X Axis Title")),
                React.createElement(Toggle, { value: graphStylingParams.xaxis.visible, onChange: () => {
                        props.setGraphParams(prevGraphParams => {
                            const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                            return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { xaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.xaxis), { visible: !graphParamsCopy.graphStyling.xaxis.visible }) }) });
                        });
                        props.setGraphUpdatedNumber(old => old + 1);
                    } })),
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", null, "Display Y Axis Title")),
                React.createElement(Toggle, { value: graphStylingParams.yaxis.visible, onChange: () => {
                        props.setGraphParams(prevGraphParams => {
                            const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                            return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { yaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.yaxis), { visible: !graphParamsCopy.graphStyling.yaxis.visible }) }) });
                        });
                        props.setGraphUpdatedNumber(old => old + 1);
                    } }))),
        React.createElement(CollapsibleSection, { title: 'Axis Transformations' },
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", null, "X Axis Transform")),
                React.createElement(Select, { value: props.graphParams.graphStyling.xaxis.type || 'default', onChange: (xAxisType) => {
                        const newXAxisType = xAxisType !== AxisType.DEFAULT ? xAxisType : undefined;
                        props.setGraphParams(prevGraphParams => {
                            const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                            return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { xaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.xaxis), { type: newXAxisType }) }) });
                        });
                        props.setGraphUpdatedNumber(old => old + 1);
                    }, width: 'small', dropdownWidth: 'medium' },
                    React.createElement(DropdownItem, { title: AxisType.DEFAULT }),
                    React.createElement(DropdownItem, { title: AxisType.LINEAR }),
                    React.createElement(DropdownItem, { title: AxisType.LOG }),
                    React.createElement(DropdownItem, { title: AxisType.DATE }),
                    React.createElement(DropdownItem, { title: AxisType.CATEGORY }))),
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", null, "Y Axis Transform")),
                React.createElement(Select, { value: props.graphParams.graphStyling.yaxis.type || 'default', onChange: (yAxisType) => {
                        const newYAxisType = yAxisType !== AxisType.DEFAULT ? yAxisType : undefined;
                        props.setGraphParams(prevGraphParams => {
                            const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                            return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { yaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.yaxis), { type: newYAxisType }) }) });
                        });
                        props.setGraphUpdatedNumber(old => old + 1);
                    }, width: 'small', dropdownWidth: 'medium' },
                    React.createElement(DropdownItem, { title: AxisType.DEFAULT }),
                    React.createElement(DropdownItem, { title: AxisType.LINEAR }),
                    React.createElement(DropdownItem, { title: AxisType.LOG }),
                    React.createElement(DropdownItem, { title: AxisType.DATE }),
                    React.createElement(DropdownItem, { title: AxisType.CATEGORY })))),
        React.createElement(CollapsibleSection, { title: 'Colors' },
            !props.userProfile.isPro &&
                React.createElement(Row, { justify: 'space-between', align: 'center' },
                    React.createElement("p", { className: 'text-body-1' },
                        "Want to set the colors of your graph? ",
                        React.createElement("a", { href: 'https://trymito.io/plans', target: '_blank', rel: "noreferrer" },
                            React.createElement("span", { className: 'text-body-1-link' }, "Upgrade to Mito Pro.")))),
            props.userProfile.isPro &&
                React.createElement(React.Fragment, null,
                    React.createElement(LabelAndColor, { label: 'Plot Background Color', color: graphStylingParams.plot_bgcolor, onChange: (newColor) => {
                            props.setGraphParams(prevGraphParams => {
                                const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { plot_bgcolor: newColor }) });
                            });
                            props.setGraphUpdatedNumber(old => old + 1);
                        } }),
                    React.createElement(LabelAndColor, { label: 'Paper Background Color', color: graphStylingParams.paper_bgcolor, onChange: (newColor) => {
                            props.setGraphParams(prevGraphParams => {
                                const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { paper_bgcolor: newColor }) });
                            });
                            props.setGraphUpdatedNumber(old => old + 1);
                        } }),
                    React.createElement(LabelAndColor, { label: 'Title color', color: graphStylingParams.title.title_font_color, onChange: (newColor) => {
                            props.setGraphParams(prevGraphParams => {
                                const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { title: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.title), { title_font_color: newColor }) }) });
                            });
                            props.setGraphUpdatedNumber(old => old + 1);
                        } }),
                    React.createElement(LabelAndColor, { label: 'X axis title color', color: graphStylingParams.xaxis.title_font_color, onChange: (newColor) => {
                            props.setGraphParams(prevGraphParams => {
                                const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { xaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.xaxis), { title_font_color: newColor }) }) });
                            });
                            props.setGraphUpdatedNumber(old => old + 1);
                        } }),
                    React.createElement(LabelAndColor, { label: 'Y axis title color', color: graphStylingParams.yaxis.title_font_color, onChange: (newColor) => {
                            props.setGraphParams(prevGraphParams => {
                                const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                                return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { yaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.yaxis), { title_font_color: newColor }) }) });
                            });
                            props.setGraphUpdatedNumber(old => old + 1);
                        } }))),
        React.createElement(CollapsibleSection, { title: 'Legend and Zoom' },
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", null, "Display Legend")),
                React.createElement(Toggle, { value: graphStylingParams.showlegend, onChange: () => {
                        props.setGraphParams(prevGraphParams => {
                            const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                            return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { showlegend: !graphParamsCopy.graphStyling.showlegend }) });
                        });
                        props.setGraphUpdatedNumber(old => old + 1);
                    } })),
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", null, "Display range slider")),
                React.createElement(Toggle, { value: graphStylingParams.xaxis.rangeslider.visible, onChange: () => {
                        props.setGraphParams(prevGraphParams => {
                            const graphParamsCopy = JSON.parse(JSON.stringify(prevGraphParams));
                            return Object.assign(Object.assign({}, graphParamsCopy), { graphStyling: Object.assign(Object.assign({}, graphParamsCopy.graphStyling), { xaxis: Object.assign(Object.assign({}, graphParamsCopy.graphStyling.xaxis), { rangeslider: {
                                            visible: !graphParamsCopy.graphStyling.xaxis.rangeslider.visible
                                        } }) }) });
                        });
                        props.setGraphUpdatedNumber(old => old + 1);
                    } })))));
}
export default GraphStyleTab;
//# sourceMappingURL=GraphStyleTab.js.map