// Copyright (c) Mito
import React, { useState } from 'react';
import '../../../css/layout/CollapsibleSection.css';
import DownArrowIcon from '../icons/DownArrowIcon';
import UpArrowIcon from '../icons/UpArrowIcon';
import Col from './Col';
import Row from './Row';
/**
 * A section that has a title and can be collapsed or expanded
 */
const CollapsibleSection = (props) => {
    const [open, setOpen] = useState(false); // todo allow you to pass this through
    if (open) {
        return (React.createElement("div", { className: 'mito-collapsible-section' },
            React.createElement(Row, { justify: 'space-between', align: 'center', onClick: () => { setOpen(false); } },
                React.createElement(Col, null,
                    React.createElement("div", { className: 'text-header-3' }, props.title)),
                React.createElement(Col, null,
                    React.createElement(UpArrowIcon, null))),
            props.children));
    }
    else {
        return (React.createElement("div", { className: 'mito-collapsible-section', onClick: () => { setOpen(true); } },
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("div", { className: 'text-header-3' }, props.title)),
                React.createElement(Col, null,
                    React.createElement(DownArrowIcon, null)))));
    }
};
export default CollapsibleSection;
//# sourceMappingURL=CollapsibleSection.js.map