// Copyright (c) Mito
import React from 'react';
import '../../../css/layout/Col.css';
import { classNames } from '../../utils/classNames';
/**
 * A Col in a container element that should always be the child of a <Row> component.
 * It takes up some number of the 24 total units of space within a Row, and can be used
 * to create very consistent and stable layouts.
 */
const Col = (props) => {
    const width = props.span ? `${props.span / 24 * 100}%` : undefined;
    const marginLeft = props.offset ? `${props.offset / 24 * 100}%` : undefined;
    const marginRight = props.offsetRight ? `${props.offsetRight / 24 * 100}%` : undefined;
    return (React.createElement("div", { className: classNames('spacing-col', props.className), style: {
            width: width,
            marginLeft: marginLeft,
            marginRight: marginRight,
            flex: props.flex
        }, onClick: props.onClick, title: props.title }, props.children));
};
export default Col;
//# sourceMappingURL=Col.js.map