# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/docindex.ipynb (unless otherwise specified).

__all__ = ['build_index', 'mdglob']

# Cell
from nbdev.export import nbglob, get_config
from functools import partial
from fastcore.utils import Path
from fastcore.test import test_eq
import re

_re_name = re.compile(r'<DocSection type="\S+" name="(\S+)"')
_re_slug = re.compile(r'---.*slug: (\S+).*---', flags=re.DOTALL)

# Cell
mdglob = partial(nbglob, recursive=True, extension='.md', config_key='doc_path')

def build_index(path=None):
    "Build an index of names generated with `ShowDoc` to document paths."
    cfg = get_config()
    if path:
        path = Path(path)
    else:
        path = cfg['doc_path']

    doc_host = cfg['doc_host']
    base_url = cfg['doc_baseurl']

    if doc_host.endswith('/'): doc_host = doc_host[:-1]
    if not base_url.startswith('/'): base_url = '/' + base_url
    if not base_url.endswith('/'): base_url += '/'
    doc_url = doc_host + base_url

    files = mdglob(path) if path else mdglob(config_key='doc_path')
    reverse_idx = {}
    for f in files:
        txt = f.read_text()
        names = _re_name.findall(txt)
        slug_match = _re_slug.search(txt)

        if slug_match:
            doc_path = slug_match.group(1)
        else:
            doc_path = str(f.relative_to(path).with_suffix(''))

        for n in names: reverse_idx[n] = doc_url + doc_path
    return reverse_idx