import copy
from typing import Any, Callable, Dict, Iterable, List, TypeVar

from ..typing import DEFAULT_LIFECYCLE_NAMES, T_Dispatcher

T = TypeVar("T")
I = TypeVar("I")

LF_COPY_TEMPLATE = {i: list() for i in DEFAULT_LIFECYCLE_NAMES}


class DII_NestableIterable:
    iterable: Iterable[T]
    indexes: List[I]

    def __init__(self, iterable: Iterable[T]) -> None:
        self.iterable = iterable
        self.indexes = [[0, 0]]

    def __iter__(self):
        dis_set_index, dis_index = self.indexes[-1]
        dis_set_index_offset = dis_set_index + bool(dis_set_index)
        dis_index_offset = dis_index + bool(dis_index)

        current_indexes = [dis_set_index_offset, dis_index_offset]
        self.indexes.append(current_indexes)

        for content in self.iterable[dis_set_index_offset:]:
            for i in content[dis_index_offset:]:
                yield i
                current_indexes[1] += 1
            current_indexes[0] += 1

        self.indexes.pop()


class ExecutionContext:
    __slots__ = {"event", "_index", "lifecycle_refs", "dispatchers"}

    _index: int
    lifecycle_refs: Dict[str, List[Callable]]
    dispatchers: List[T_Dispatcher]

    def __init__(self, dispatchers: List[T_Dispatcher]) -> None:
        self._index = 0
        self.dispatchers = dispatchers

        self.lifecycle_refs = copy.copy(LF_COPY_TEMPLATE)


class ParameterContext:
    __slots__ = {"name", "annotation", "default", "dispatchers", "path"}

    name: str
    annotation: Any
    default: Any

    dispatchers: List[T_Dispatcher]

    def __init__(self, name, annotation, default, dispatchers, using_path) -> None:
        self.name = name
        self.annotation = annotation
        self.default = default
        self.dispatchers = dispatchers
        self.path = DII_NestableIterable(using_path)

    def __repr__(self) -> str:
        return (
            "<ParameterContext name={0} annotation={1} default={2} locald={3}".format(
                self.name, self.annotation, self.default, self.dispatchers
            )
        )


from .event import Dispatchable
