# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501

    The version of the OpenAPI document: 2020-09-14_1.0.11
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class LiabilitiesObject(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'credit': 'list[CreditCardLiability]',
        'mortgage': 'list[MortgageLiability]',
        'student': 'list[StudentLoan]'
    }

    attribute_map = {
        'credit': 'credit',
        'mortgage': 'mortgage',
        'student': 'student'
    }

    def __init__(self, credit=None, mortgage=None, student=None, local_vars_configuration=None):  # noqa: E501
        """LiabilitiesObject - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._credit = None
        self._mortgage = None
        self._student = None
        self.discriminator = None

        self.credit = credit
        self.mortgage = mortgage
        self.student = student

    @property
    def credit(self):
        """Gets the credit of this LiabilitiesObject.  # noqa: E501

        The credit accounts returned. If no credit accounts are returned, `credit` will not be present in the schema.  # noqa: E501

        :return: The credit of this LiabilitiesObject.  # noqa: E501
        :rtype: list[CreditCardLiability]
        """
        return self._credit

    @credit.setter
    def credit(self, credit):
        """Sets the credit of this LiabilitiesObject.

        The credit accounts returned. If no credit accounts are returned, `credit` will not be present in the schema.  # noqa: E501

        :param credit: The credit of this LiabilitiesObject.  # noqa: E501
        :type credit: list[CreditCardLiability]
        """

        self._credit = credit

    @property
    def mortgage(self):
        """Gets the mortgage of this LiabilitiesObject.  # noqa: E501

        The mortgage accounts returned. If no mortgage accounts are returned, `mortgage` will not be present in the schema.  # noqa: E501

        :return: The mortgage of this LiabilitiesObject.  # noqa: E501
        :rtype: list[MortgageLiability]
        """
        return self._mortgage

    @mortgage.setter
    def mortgage(self, mortgage):
        """Sets the mortgage of this LiabilitiesObject.

        The mortgage accounts returned. If no mortgage accounts are returned, `mortgage` will not be present in the schema.  # noqa: E501

        :param mortgage: The mortgage of this LiabilitiesObject.  # noqa: E501
        :type mortgage: list[MortgageLiability]
        """

        self._mortgage = mortgage

    @property
    def student(self):
        """Gets the student of this LiabilitiesObject.  # noqa: E501

        The student loan accounts returned. If no student loan accounts are returned, `student` will not be present in the schema.  # noqa: E501

        :return: The student of this LiabilitiesObject.  # noqa: E501
        :rtype: list[StudentLoan]
        """
        return self._student

    @student.setter
    def student(self, student):
        """Sets the student of this LiabilitiesObject.

        The student loan accounts returned. If no student loan accounts are returned, `student` will not be present in the schema.  # noqa: E501

        :param student: The student of this LiabilitiesObject.  # noqa: E501
        :type student: list[StudentLoan]
        """

        self._student = student

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LiabilitiesObject):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, LiabilitiesObject):
            return True

        return self.to_dict() != other.to_dict()
