# coding: utf-8

"""
    The Plaid API

    The Plaid REST API. Please see https://plaid.com/docs/api for more details.  # noqa: E501

    The version of the OpenAPI document: 2020-09-14_1.0.11
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from plaid.generated_plaid.configuration import Configuration


class AssetReportItem(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'item_id': 'str',
        'institution_name': 'str',
        'institution_id': 'str',
        'date_last_updated': 'str',
        'accounts': 'list[AccountAssets]'
    }

    attribute_map = {
        'item_id': 'item_id',
        'institution_name': 'institution_name',
        'institution_id': 'institution_id',
        'date_last_updated': 'date_last_updated',
        'accounts': 'accounts'
    }

    def __init__(self, item_id=None, institution_name=None, institution_id=None, date_last_updated=None, accounts=None, local_vars_configuration=None):  # noqa: E501
        """AssetReportItem - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._item_id = None
        self._institution_name = None
        self._institution_id = None
        self._date_last_updated = None
        self._accounts = None
        self.discriminator = None

        if item_id is not None:
            self.item_id = item_id
        if institution_name is not None:
            self.institution_name = institution_name
        if institution_id is not None:
            self.institution_id = institution_id
        if date_last_updated is not None:
            self.date_last_updated = date_last_updated
        if accounts is not None:
            self.accounts = accounts

    @property
    def item_id(self):
        """Gets the item_id of this AssetReportItem.  # noqa: E501

        The `item_id` of the Item associated with this webhook, warning, or error  # noqa: E501

        :return: The item_id of this AssetReportItem.  # noqa: E501
        :rtype: str
        """
        return self._item_id

    @item_id.setter
    def item_id(self, item_id):
        """Sets the item_id of this AssetReportItem.

        The `item_id` of the Item associated with this webhook, warning, or error  # noqa: E501

        :param item_id: The item_id of this AssetReportItem.  # noqa: E501
        :type item_id: str
        """

        self._item_id = item_id

    @property
    def institution_name(self):
        """Gets the institution_name of this AssetReportItem.  # noqa: E501

        The full financial institution name associated with the Item.  # noqa: E501

        :return: The institution_name of this AssetReportItem.  # noqa: E501
        :rtype: str
        """
        return self._institution_name

    @institution_name.setter
    def institution_name(self, institution_name):
        """Sets the institution_name of this AssetReportItem.

        The full financial institution name associated with the Item.  # noqa: E501

        :param institution_name: The institution_name of this AssetReportItem.  # noqa: E501
        :type institution_name: str
        """

        self._institution_name = institution_name

    @property
    def institution_id(self):
        """Gets the institution_id of this AssetReportItem.  # noqa: E501

        The id of the financial institution associated with the Item.  # noqa: E501

        :return: The institution_id of this AssetReportItem.  # noqa: E501
        :rtype: str
        """
        return self._institution_id

    @institution_id.setter
    def institution_id(self, institution_id):
        """Sets the institution_id of this AssetReportItem.

        The id of the financial institution associated with the Item.  # noqa: E501

        :param institution_id: The institution_id of this AssetReportItem.  # noqa: E501
        :type institution_id: str
        """

        self._institution_id = institution_id

    @property
    def date_last_updated(self):
        """Gets the date_last_updated of this AssetReportItem.  # noqa: E501

        The date and time when this Item’s data was last retrieved from the financial institution, in ISO 8601 format.  # noqa: E501

        :return: The date_last_updated of this AssetReportItem.  # noqa: E501
        :rtype: str
        """
        return self._date_last_updated

    @date_last_updated.setter
    def date_last_updated(self, date_last_updated):
        """Sets the date_last_updated of this AssetReportItem.

        The date and time when this Item’s data was last retrieved from the financial institution, in ISO 8601 format.  # noqa: E501

        :param date_last_updated: The date_last_updated of this AssetReportItem.  # noqa: E501
        :type date_last_updated: str
        """

        self._date_last_updated = date_last_updated

    @property
    def accounts(self):
        """Gets the accounts of this AssetReportItem.  # noqa: E501

        Data about each of the accounts open on the Item.  # noqa: E501

        :return: The accounts of this AssetReportItem.  # noqa: E501
        :rtype: list[AccountAssets]
        """
        return self._accounts

    @accounts.setter
    def accounts(self, accounts):
        """Sets the accounts of this AssetReportItem.

        Data about each of the accounts open on the Item.  # noqa: E501

        :param accounts: The accounts of this AssetReportItem.  # noqa: E501
        :type accounts: list[AccountAssets]
        """

        self._accounts = accounts

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AssetReportItem):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AssetReportItem):
            return True

        return self.to_dict() != other.to_dict()
