from dataclasses import dataclass
from typing import Optional, List

@dataclass
class DatasetEntry:
    dataset: str
    dataset_key: str
    citation_key: str
    citation: str
    anthology: Optional[str]
    languages: List[str]
    license: str

DATASETS: List[DatasetEntry] = [
    DatasetEntry(
        dataset="CaLMQA",
        dataset_key="shanearora/CaLMQA",
        citation_key="arora2024calmqa",
        citation="""@misc{arora2024calmqa,
      title={CaLMQA: Exploring culturally specific long-form question answering across 23 languages}, 
      author={Shane Arora and Marzena Karpinska and Hung-Ting Chen and Ipsita Bhattacharjee and Mohit Iyyer and Eunsol Choi},
      year={2024},
      eprint={2406.17761},
      archivePrefix={arXiv},
      primaryClass={cs.CL},
      url={https://arxiv.org/abs/2406.17761}, 
}""",
        anthology="o",
        languages=["EN", "KO"],
        license="MIT"
    ),
    DatasetEntry(
        dataset="BLEnD",
        dataset_key="nayeon212/BLEnD",
        citation_key="myung2024blend",
        citation="""@misc{myung2025blend,
      title={BLEnD: A Benchmark for LLMs on Everyday Knowledge in Diverse Cultures and Languages}, 
      author={Junho Myung and Nayeon Lee and Yi Zhou and Jiho Jin and Rifki Afina Putri and Dimosthenis Antypas and Hsuvas Borkakoty and Eunsu Kim and Carla Perez-Almendros and Abinew Ali Ayele and Víctor Gutiérrez-Basulto and Yazmín Ibáñez-García and Hwaran Lee and Shamsuddeen Hassan Muhammad and Kiwoong Park and Anar Sabuhi Rzayev and Nina White and Seid Muhie Yimam and Mohammad Taher Pilehvar and Nedjma Ousidhoum and Jose Camacho-Collados and Alice Oh},
      year={2025},
      eprint={2406.09948},
      archivePrefix={arXiv},
      primaryClass={cs.CL},
      url={https://arxiv.org/abs/2406.09948}, 
}""",
        anthology="o",
        languages=["KO"],
        license="cc-by-sa-4.0"
    ),
    DatasetEntry(
        dataset="KBL",
        dataset_key="lbox/kbl",
        citation_key="kimyeeun-etal-2024-developing",
        citation="""@inproceedings{kimyeeun-etal-2024-developing,
    title = "Developing a Pragmatic Benchmark for Assessing {K}orean Legal Language Understanding in Large Language Models",
    author = "Kim, Yeeun  and Choi, Youngrok  and Choi, Eunkyung  and Choi, JinHwan  and Park, Hai Jin  and Hwang, Wonseok",
    editor = "Al-Onaizan, Yaser  and Bansal, Mohit  and Chen, Yun-Nung",
    booktitle = "Findings of the Association for Computational Linguistics: EMNLP 2024",
    month = nov,
    year = "2024",
    address = "Miami, Florida, USA",
    publisher = "Association for Computational Linguistics",
    url = "https://aclanthology.org/2024.findings-emnlp.319/",
    doi = "10.18653/v1/2024.findings-emnlp.319",
    pages = "5573--5595"
}""",
        anthology="kimyeeun-etal-2024-developing",
        languages=["KO"],
        license="cc-by-nc-4.0"
    ),
    DatasetEntry(
        dataset="KorMedMCQA",
        dataset_key="sean0042/KorMedMCQA",
        citation_key="kweon2024kormedmcqa",
        citation="""@misc{kweon2024kormedmcqa,
      title={KorMedMCQA: Multi-Choice Question Answering Benchmark for Korean Healthcare Professional Licensing Examinations}, 
      author={Sunjun Kweon and Byungjin Choi and Gyouk Chu and Junyeong Song and Daeun Hyeon and Sujin Gan and Jueon Kim and Minkyu Kim and Rae Woong Park and Edward Choi},
      year={2024},
      eprint={2403.01469},
      archivePrefix={arXiv},
      primaryClass={cs.CL},
      url={https://arxiv.org/abs/2403.01469}, 
}""",
        anthology=None,
        languages=["KO"],
        license="cc-by-nc-2.0"
    ),
    DatasetEntry(
        dataset="KMMLU",
        dataset_key="HAERAE-HUB/KMMLU",
        citation_key="son-etal-2025-kmmlu",
        citation="""@inproceedings{son-etal-2025-kmmlu,
    title = "{KMMLU}: Measuring Massive Multitask Language Understanding in {K}orean",
    author = "Son, Guijin  and Lee, Hanwool  and Kim, Sungdong  and Kim, Seungone  and Muennighoff, Niklas  and Choi, Taekyoon  and Park, Cheonbok  and Yoo, Kang Min  and Biderman, Stella",
    editor = "Chiruzzo, Luis  and Ritter, Alan  and Wang, Lu",
    booktitle = "Proceedings of the 2025 Conference of the Nations of the Americas Chapter of the Association for Computational Linguistics: Human Language Technologies (Volume 1: Long Papers)",
    month = apr,
    year = "2025",
    address = "Albuquerque, New Mexico",
    publisher = "Association for Computational Linguistics",
    url = "https://aclanthology.org/2025.naacl-long.206/",
    pages = "4076--4104",
    ISBN = "979-8-89176-189-6"
}""",
        anthology="son-etal-2025-kmmlu",
        languages=["KO"],
        license="cc-by-nd-4.0"
    ),
    DatasetEntry(
        dataset="HRM8K",
        dataset_key="HAERAE-HUB/HRM8K",
        citation_key="ko2025understand",
        citation="""@misc{ko2025understand,
      title={Understand, Solve and Translate: Bridging the Multilingual Mathematical Reasoning Gap}, 
      author={Hyunwoo Ko and Guijin Son and Dasol Choi},
      year={2025},
      eprint={2501.02448},
      archivePrefix={arXiv},
      primaryClass={cs.CL},
      url={https://arxiv.org/abs/2501.02448}, 
}""",
        anthology=None,
        languages=["KO"],
        license="MIT"
    ),
    DatasetEntry(
        dataset="KoBBQ",
        dataset_key="naver-ai/kobbq",
        citation_key="jin-etal-2024-kobbq",
        citation="""@article{jin-etal-2024-kobbq,
    title = "{K}o{BBQ}: {K}orean Bias Benchmark for Question Answering",
    author = "Jin, Jiho  and Kim, Jiseon  and Lee, Nayeon  and Yoo, Haneul  and Oh, Alice  and Lee, Hwaran",
    journal = "Transactions of the Association for Computational Linguistics",
    volume = "12",
    year = "2024",
    address = "Cambridge, MA",
    publisher = "MIT Press",
    url = "https://aclanthology.org/2024.tacl-1.28/",
    doi = "10.1162/tacl_a_00661",
    pages = "507--524"
}""",
        anthology="jin-etal-2024-kobbq",
        languages=["KO"],
        license="MIT"
    ),
    DatasetEntry(
        dataset="KULTURE Bench",
        dataset_key="KULTUREBench",
        citation_key="wang2024kulture",
        citation="""@misc{wang2024kulture,
      title={KULTURE Bench: A Benchmark for Assessing Language Model in Korean Cultural Context}, 
      author={Xiaonan Wang and Jinyoung Yeo and Joon-Ho Lim and Hansaem Kim},
      year={2024},
      eprint={2412.07251},
      archivePrefix={arXiv},
      primaryClass={cs.CL},
      url={https://arxiv.org/abs/2412.07251}, 
}""",
        anthology=None,
        languages=["KO"],
        license="Apache-2.0"
    ),
    DatasetEntry(
        dataset="HAE-RAE Bench",
        dataset_key="HAERAE-HUB/HAE_RAE_BENCH_1.1",
        citation_key="son-etal-2024-hae",
        citation="""@inproceedings{son-etal-2024-hae,
    title = "{HAE}-{RAE} Bench: Evaluation of {K}orean Knowledge in Language Models",
    author = "Son, Guijin  and Lee, Hanwool  and Kim, Suwan  and Kim, Huiseo  and Lee, Jae cheol  and Yeom, Je Won  and Jung, Jihyu  and Kim, Jung woo  and Kim, Songseong",
    editor = "Calzolari, Nicoletta  and Kan, Min-Yen  and Hoste, Veronique  and Lenci, Alessandro  and Sakti, Sakriani  and Xue, Nianwen",
    booktitle = "Proceedings of the 2024 Joint International Conference on Computational Linguistics, Language Resources and Evaluation (LREC-COLING 2024)",
    month = may,
    year = "2024",
    address = "Torino, Italia",
    publisher = "ELRA and ICCL",
    url = "https://aclanthology.org/2024.lrec-main.704/",
    pages = "7993--8007"
}""",
        anthology="son-etal-2024-hae",
        languages=["KO"],
        license="cc-by-nc-nd-4.0"
    ),
    DatasetEntry(
        dataset="CLIcK",
        dataset_key="EunsuKim/CLIcK",
        citation_key="kim-etal-2024-click",
        citation="""@inproceedings{kim-etal-2024-click,
    title = "{CLI}c{K}: A Benchmark Dataset of Cultural and Linguistic Intelligence in {K}orean",
    author = "Kim, Eunsu  and Suk, Juyoung  ￼and Oh, Philhoon  and Yoo, Haneul  and Thorne, James  and Oh, Alice",
    editor = "Calzolari, Nicoletta  and Kan, Min-Yen  and Hoste, Veronique  and Lenci, Alessandro  and Sakti, Sakriani  and Xue, Nianwen",
    booktitle = "Proceedings of the 2024 Joint International Conference on Computational Linguistics, Language Resources and Evaluation (LREC-COLING 2024)",
    month = may,
    year = "2024",
    address = "Torino, Italia",
    publisher = "ELRA and ICCL",
    url = "https://aclanthology.org/2024.lrec-main.296/",
    pages = "3335--3346"
}""",
        anthology="kim-etal-2024-click",
        languages=["KO"],
        license="cc-by-nd-4.0"
    ),
    DatasetEntry(
        dataset="HRMCR",
        dataset_key="HAERAE-HUB/HRMCR",
        citation_key="son-etal-2025-multi",
        citation="""@inproceedings{son-etal-2025-multi,
    title = "Multi-Step Reasoning in {K}orean and the Emergent Mirage",
    author = "Son, Guijin  and Ko, Hyunwoo  and Choi, Dasol",
    editor = "Prabhakaran, Vinodkumar  and Dev, Sunipa  and Benotti, Luciana  and Hershcovich, Daniel  and Cao, Yong  and Zhou, Li  and Cabello, Laura  and Adebara, Ife",
    booktitle = "Proceedings of the 3rd Workshop on Cross-Cultural Considerations in NLP (C3NLP 2025)",
    month = may,
    year = "2025",
    address = "Albuquerque, New Mexico",
    publisher = "Association for Computational Linguistics",
    url = "https://aclanthology.org/2025.c3nlp-1.2/",
    pages = "10--21",
    ISBN = "979-8-89176-237-4"
}""",
        anthology="son-etal-2025-multi",
        languages=["KO"],
        license="apache-2.0"
    ),
    DatasetEntry(
        dataset="KoSBi",
        dataset_key="nayohan/KoSBi",
        citation_key="lee-etal-2023-kosbi",
        citation="""@inproceedings{lee-etal-2023-kosbi,
    title = "{K}o{SBI}: A Dataset for MITigating Social Bias Risks Towards Safer Large Language Model Applications",
    author = "Lee, Hwaran  and Hong, Seokhee  and Park, Joonsuk  and Kim, Takyoung  and Kim, Gunhee  and Ha, Jung-woo",
    editor = "Sitaram, Sunayana  and Beigman Klebanov, Beata  and Williams, Jason D",
    booktitle = "Proceedings of the 61st Annual Meeting of the Association for Computational Linguistics (Volume 5: Industry Track)",
    month = jul,
    year = "2023",
    address = "Toronto, Canada",
    publisher = "Association for Computational Linguistics",
    url = "https://aclanthology.org/2023.acl-industry.21/",
    doi = "10.18653/v1/2023.acl-industry.21",
    pages = "208--224"
}""",
        anthology="lee-etal-2023-kosbi",
        languages=["KO"],
        license="MIT"
    )
]
