## 🔍 평가방법 (Evaluation)

### String / Partial Match Evaluation
모델의 예측값(prediction)과 참조값(reference)이 '완전 일치(exact match)하는지 / 부분 일치(Partial Match)하는지' 평가하는 방식을 선택합니다.

  1. 텍스트 정규화 (Normalization)
모델의 출력(prediction)과 정답(reference) 또는 선택지(options)를 비교하기 전에, 다음과 같은 정규화를 수행할 수 있도록 구현되었습니다:
( 대소문자 무시 (ignore_case=True): 모든 텍스트를 소문자로 변환하여 비교합니다.
구두점 제거 (ignore_punctuation=False): 옵션에 따라 구두점(.,!?)을 제거할 수 있습니다.
숫자 제거 (ignore_numbers=False): 옵션에 따라 숫자를 제거할 수 있습니다.
정규표현식 필터링 (regexes_to_ignore): 특정 패턴을 제거할 수 있습니다.
공백 정규화: 여러 개의 공백을 하나로 통일합니다. )

  2. 최종 답변 추출 (Final Answer Extraction)
모델의 출력에서 "Answer:" 이후의 텍스트만 추출하여 평가할 수도 있습니다. 이는 모델 출력에 reasoning chain(추론 과정)이 포함된 경우 유용합니다.

📖 사용 예시
<완전 일치 String Match>
예를 들어, 참조값(reference)이 "서울특별시"이고 모델의 예측값(prediction)이 "서울특별시"라면, 두 값이 정확히 동일하므로 String Match 기준에서는 정답으로 처리됩니다. 또한 MCQA 모드에서 선택지가 ["서울", "부산", "대구"]이고 모델의 예측이 "부산"이라면, "부산"이라는 선택지가 예측 결과와 정확히 일치하므로 정답으로 인정됩니다.

<부분 일치 Partial Match>
예를 들어, 참조값(reference)이 "서울특별시"이고 모델의 예측값(prediction)이 "대한민국 서울특별시 강남구"라면, 비록 정확히 일치하지는 않지만 참조값이 예측값에 포함되어 있으므로 Partial Match 기준에서는 정답으로 처리됩니다. 또한 MCQA 모드에서 선택지가 ["서울", "부산", "대구"]이고 모델의 예측이 "저는 서울에 가고 싶습니다."라면, "서울"이라는 선택지가 예측 결과에 부분적으로 포함되어 있으므로 정답으로 인정됩니다.

### Log Probability Evaluation (로그 확률 평가)
모델이 생성한 각 선택지의 로그 확률(log probability)을 기반으로 정답을 예측하고, 이를 참조값(reference)과 비교하여 정확도를 계산하는 평가 방법입니다. 이 방법은 단순히 모델의 출력(prediction)만을 사용하는 대신, 모델의 내부 확률 정보(로그 확률)를 활용하여 더 신뢰할 수 있는 평가를 수행합니다.

  1. 입력 데이터 구조
이 평가 방법은 다음과 같은 필드를 포함하는 샘플 데이터를 기대합니다:
  -options: 선택지 목록 (예: ["서울", "부산", "대구"])
  -logits: 선택지별 로그 확률 정보를 포함하는 딕셔너리
  -option_log_probs: 각 선택지에 대한 로그 확률 값의 리스트 (예: [-1.2, -0.5, -2.3])
  -reference: 정답 선택지 (예: "부산")
  (선택적) prediction: 모델이 직접 생성한 예측값 (로그 확률 기반 예측이 불가능할 때 사용)

  2. 로그 확률 기반 예측
모델이 제공한 각 선택지의 로그 확률 값(option_log_probs)을 사용하여 가장 높은 확률을 가진 선택지를 예측값으로 결정합니다:
  -최고 로그 확률 선택: 로그 확률 값 중 최댓값을 찾아 해당 선택지를 예측값으로 설정합니다.
  -예: option_log_probs = [-1.2, -0.5, -2.3]이라면, 두 번째 선택지("부산")가 가장 높은 로그 확률(-0.5)을 가지므로 이를 예측값으로 설정.
  -Fallback (대체 방식): 만약 로그 확률 값이 없거나 유효하지 않은 경우, 사전에 저장된 prediction 필드를 사용해 예측합니다.

  3. 정확도 계산
로그 확률 기반으로 결정된 예측값(predicted_option)을 참조값(reference)과 비교하여 정확도를 계산합니다: 예측값이 참조값과 동일하면 정답으로 간주하며, 전체 샘플 중 정답 비율(accuracy)을 반환.

### Math Match Evaluation (수학적 일치 평가)
모델의 출력과 참조값을 수학적으로 동등한지 비교하여 평가합니다. 단순한 문자열 비교 대신, 수학적 표현의 수학적 동등성을 확인하는 데 초점을 맞춥니다.
즉, 모델이 생성한 수학적 표현(예측값, prediction)과 참조값(reference) 간의 수학적 동등성을 평가하는 방법으로서, 다음과 같은 특징을 가집니다:
  -문자열 일치가 아닌 수학적 동등성 비교: 두 표현이 동일한 결과를 나타내는지 확인합니다.
  -LaTeX 및 일반 수학 표현 지원: LaTeX 형식이나 일반 수학 표현 모두 처리 가능합니다.
  -추론 과정 포함 가능: Chain-of-Thought(CoT) 방식의 출력에서 최종 답변만 추출하여 평가할 수 있습니다.

  1. 입력 데이터 구조
이 평가 방법은 다음과 같은 필드를 포함하는 샘플 데이터를 기대합니다:
  -prediction: 모델이 생성한 수학적 표현 (예: "정답은 \\boxed{1,2,3}")
  -reference: 정답으로 제공된 수학적 표현 (예: "${1,2} \\cup {3}")

  2. 최종 답변 추출
모델 출력에 추론 과정이 포함된 경우, 정규식 패턴을 사용하여 최종 답변만 추출합니다:
  -예: "정답은 \\boxed{1,2,3}" → "\\boxed{1,2,3}"
   (추출은 다음과 같은 패턴을 기반으로 수행됩니다):
  -정답\s*:\s*(.*?)(?:\n|$)
  -Answer\s*:\s*(.*?)(?:\n|$)

  3. 수학적 표현 파싱
math_verify 라이브러리를 사용하여 LaTeX 또는 일반 수학 표현을 파싱합니다:
  -예: \\boxed{1,2,3} → 내부적으로 수학적 객체로 변환.
  -파싱 실패 시 해당 샘플은 평가에서 제외되며 실패율(parse_failure_rate)로 기록됩니다.

  4. 수학적 동등성 검증
파싱된 두 표현(예측값과 참조값)이 동일한 결과를 나타내는지 확인합니다:

  -예: {1,2} \\cup {3}와 {3,1,2}는 동일한 집합을 나타내므로 동등성 검증에서 성공(True)으로 처리됩니다.
  -검증 실패 시 해당 샘플은 실패율(verify_failure_rate)로 기록됩니다.

  5. 정확도 계산
  -모든 샘플 중 동등성 검증에 성공한 비율을 정확도(accuracy)로 반환합니다.

  📖 사용 예시
<샘플 정의>
```python
samples = [
    {
        "prediction": "정답은 \\boxed{1,2,3} 입니다.",
        "reference": "{1,2} \\cup {3}"
    },
    {
        "prediction": "Answer: x^2 + 2x + 1",
        "reference": "(x+1)^2"
    }
]
```

## Scaling_method (선택적임, 반복으로 인해 장시간 소요될 수 있음)
- self_consistency: LLM이 같은 질문에 대해 여러 번 답변한 후, 가장 자주 등장하는 답변을 선택하는 기법
- greedy: 가장 확률이 높은 단어를 반복해서 선택하는 단순한 방식. (단점: 다양성이 부족함)
- beam_search: 여러 개의 가능성을 동시에 고려하면서 가장 좋은 문장을 찾는 방식. (좀 더 안정적인 결과 제공)
- top_k: 확률이 높은 상위 k개의 단어 중에서 랜덤하게 선택 (텍스트 다양성 증가)
- top_p: 확률의 누적 합이 p 이상이 되는 단어 집합에서 선택 (더 자연스러운 생성 가능)
- temperature_sampling:	확률 분포를 조정하여 더 창의적인 결과를 생성 (온도 높을수록 다양성 증가)