from enum import Enum

class FontFamily(Enum):

    ARIAL = 0
    TAHOMA = 1
    TIMES_NEW_ROMAN = 2
    VERDANA = 3

class FontSize(Enum):

    EIGHT = 0
    f8 = 0
    NINE = 1
    f9 = 1
    TEN = 2
    f10 = 2
    TWELVE = 3
    f12 = 3
    FOURTEEN = 4
    f14 = 4
    SIXTEEN = 5
    f16 = 5
    EIGHTEEN = 6
    f18 = 6
    TWENTY = 7
    f20 = 7
    TWENTYFOUR = 8
    f24 = 8
    TWENTYEIGHT = 9
    f28 = 9
    THIRTYTWO = 10
    f32 = 10
    THIRTYSIX = 11
    f36 = 11

class FormatSetting(Enum):

    NONE = 0
    OFF = 0
    FALSE = 0
    NO = 0
    ON = 1
    TRUE = 1
    YES = 1

class HorizontalAlign(Enum):
    
    DEFAULT = 0
    LEFT = 1
    CENTER = 2
    RIGHT = 3

class VerticalAlign(Enum):

    DEFAULT = 0
    TOP = 1
    MIDDLE = 2
    BOTTOM = 3

class Color(Enum):

    NONE = 0
    c000000 = 1
    BLACK = 1
    x8y1 = 1
    cFFFFFF = 2
    WHITE = 2
    x8y5 = 2
    TRANSPARENT = 3
    cFFEBEE = 4
    RED_1 = 4
    RED_LIGHT = 4
    x1y1 = 4
    cFFF3DF = 5
    ORANGE_1 = 5
    ORANGE_LIGHT = 5
    x2y1 = 5
    cFFFEE6 = 6
    x3y1 = 6
    YELLOW_1 = 6
    YELLOW_LIGHT = 6
    cE7F5E9 = 7
    GREEN_1 = 7
    GREEN_LIGHT = 7
    x4y1 = 7
    cE2F2FE = 8
    BLUE_1 = 8
    BLUE_LIGHT = 8
    x5y1 = 8
    cF4E4F5 = 9
    PURPLE_1 = 9
    PURPLE_LIGHT = 9
    x6y1 = 9
    cF2E8DE = 10
    BROWN_1 = 10
    BROWN_LIGHT = 10
    x7y1 = 10
    cFFCCD2 = 11
    RED_2 = 11
    RED_LIGHT_MID = 11
    RED_MID_LIGHT = 11
    x1y2 = 11
    cFFE1AF = 12
    ORANGE_2 = 12
    ORANGE_LIGHT_MID = 12
    ORANGE_MID_LIGHT = 12
    x2y2 = 12
    cFEFF85 = 13
    x3y2 = 13
    YELLOW_2 = 13
    YELLOW_LIGHT_MID = 13
    YELLOW_MID_LIGHT = 13
    cC6E7C8 = 14
    GREEN_2 = 14
    GREEN_LIGHT_MID = 14
    GREEN_MID_LIGHT = 14
    x4y2 = 14
    cB9DDFC = 15
    BLUE_2 = 15
    BLUE_LIGHT_MID = 15
    BLUE_MID_LIGHT = 15
    x5y2 = 15
    cEBC7EF = 16
    PURPLE_2 = 16
    PURPLE_LIGHT_MID = 16
    PURPLE_MID_LIGHT = 16
    x6y2 = 16
    cEEDCCA = 17
    BROWN_2 = 17
    BROWN_LIGHT_MID = 17
    BROWN_MID_LIGHT = 17
    x7y2 = 17
    cE5E5E5 = 18
    GRAY_1 = 18
    GRAY_2 = 18
    GRAY_LIGHT = 18
    GRAY_LIGHT_MID = 18
    GRAY_MID_LIGHT = 18
    GREY_1 = 18
    GREY_2 = 18
    GREY_LIGHT = 18
    GREY_LIGHT_MID = 18
    GREY_MID_LIGHT = 18
    LIGHT_GRAY = 18
    LIGHT_GREY = 18
    x8y2 = 18
    cF87E7D = 19
    RED = 19
    RED_3 = 19
    RED_MID = 19
    x1y3 = 19
    cFFCD7A = 20
    ORANGE = 20
    ORANGE_3 = 20
    ORANGE_MID = 20
    x2y3 = 20
    cFEFF00 = 21
    x3y3 = 21
    YELLOW = 21
    YELLOW_3 = 21
    YELLOW_MID = 21
    c7ED085 = 22
    GREEN = 22
    GREEN_3 = 22
    GREEN_MID = 22
    x4y3 = 22
    c5FB3F9 = 23
    BLUE = 23
    BLUE_3 = 23
    BLUE_MID = 23
    x5y3 = 23
    cD190DA = 24
    PURPLE = 24
    PURPLE_3 = 24
    PURPLE_MID = 24
    x6y3 = 24
    cD0AF8F = 25
    BROWN = 25
    BROWN_3 = 25
    BROWN_MID = 25
    x7y3 = 25
    cBDBDBD = 26
    GRAY = 26
    GRAY_3 = 26
    GRAY_MID = 26
    GREY = 26
    GREY_3 = 26
    GREY_MID = 26
    x8y3 = 26
    cEA352E = 27
    RED_4 = 27
    RED_DARK_MID = 27
    RED_MID_DARK = 27
    x1y4 = 27
    cFF8D00 = 28
    ORANGE_4 = 28
    ORANGE_DARK_MID = 28
    ORANGE_MID_DARK = 28
    x2y4 = 28
    cFFED00 = 29
    x3y4 = 29
    YELLOW_4 = 29
    YELLOW_DARK_MID = 29
    YELLOW_MID_DARK = 29
    c40B14B = 30
    GREEN_4 = 30
    GREEN_DARK_MID = 30
    GREEN_MID_DARK = 30
    x4y4 = 30
    c1061C3 = 31
    BLUE_4 = 31
    BLUE_DARK_MID = 31
    BLUE_MID_DARK = 31
    x5y4 = 31
    c9210AD = 32
    PURPLE_4 = 32
    PURPLE_DARK_MID = 32
    PURPLE_MID_DARK = 32
    x6y4 = 32
    c974C00 = 33
    BROWN_4 = 33
    BROWN_DARK_MID = 33
    BROWN_MID_DARK = 33
    x7y4 = 33
    c757575 = 34
    GRAY_4 = 34
    GRAY_5 = 34
    GRAY_DARK = 34
    GRAY_DARK_MID = 34
    GRAY_MID_DARK = 34
    GREY_4 = 34
    GREY_5 = 34
    GREY_DARK = 34
    GREY_DARK_MID = 34
    GREY_MID_DARK = 34
    x8y4 = 34
    c991310 = 35
    RED_5 = 35
    RED_DARK = 35
    x1y5 = 35
    cEA5000 = 36
    ORANGE_5 = 36
    ORANGE_DARK = 36
    x2y5 = 36
    cEBC700 = 37
    x3y5 = 37
    YELLOW_5 = 37
    YELLOW_DARK = 37
    c237F2E = 38
    GREEN_5 = 38
    GREEN_DARK = 38
    x4y5 = 38
    c0B347D = 39
    BLUE_5 = 39
    BLUE_DARK = 39
    x5y5 = 39
    c61058B = 40
    PURPLE_5 = 40
    PURPLE_DARK = 40
    x6y5 = 40
    c592C00 = 41
    BROWN_5 = 41
    BROWN_DARK = 41
    x7y5 = 41

class Currency(Enum):
    NONE = 0
    ARS = 1
    AUD = 2
    BRL = 3
    CAD = 4
    CLP = 5
    EUR = 6
    GBP = 7
    ILS = 8
    INR = 9
    JPY = 10
    MXN = 11
    RUB = 12
    USD = 13
    ZAR = 14
    CHF = 15
    CNY = 16
    DKK = 17
    HKD = 18
    KRW = 19
    NOK = 20
    NZD = 21
    SEK = 22
    SGD = 23

class DecimalCount(Enum):
    ZERO = 0
    ONE = 1
    TWO = 2
    THREE = 3
    FOUR = 4
    FIVE = 5

class NumberFormat(Enum):
    NONE = 0
    NUMBER = 1
    CURRENCY = 2
    PERCENT = 3

class DateFormat(Enum):
    LOCALE_BASED = 0
    MMMM_D_YYYY = 1
    MMM_D_YYYY = 2
    D_MMM_YYYY = 3
    YYYY_MM_DD_HYPHEN = 4
    YYYY_MM_DD_DOT = 5
    DWWWW_MMMM_D_YYYY = 6
    DWWW_DD_MMM_YYYY = 7
    DWWW_MM_DD_YYYY = 8
    MMMM_D = 9
    D_MMMM = 10
