# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['l2hmc',
 'l2hmc.distributions',
 'l2hmc.distributions.pytorch',
 'l2hmc.distributions.tensorflow',
 'l2hmc.dynamics',
 'l2hmc.dynamics.pytorch',
 'l2hmc.dynamics.tensorflow',
 'l2hmc.group',
 'l2hmc.group.pytorch',
 'l2hmc.group.tensorflow',
 'l2hmc.lattice',
 'l2hmc.lattice.su3',
 'l2hmc.lattice.su3.numpy',
 'l2hmc.lattice.su3.pytorch',
 'l2hmc.lattice.su3.tensorflow',
 'l2hmc.lattice.u1.numpy',
 'l2hmc.lattice.u1.pytorch',
 'l2hmc.lattice.u1.tensorflow',
 'l2hmc.learning_rate.tensorflow',
 'l2hmc.loss',
 'l2hmc.loss.pytorch',
 'l2hmc.loss.tensorflow',
 'l2hmc.network',
 'l2hmc.network.jax',
 'l2hmc.network.pytorch',
 'l2hmc.network.tensorflow',
 'l2hmc.notebooks',
 'l2hmc.scripts',
 'l2hmc.scripts.pytorch',
 'l2hmc.scripts.tensorflow',
 'l2hmc.trackers',
 'l2hmc.trackers.pytorch',
 'l2hmc.trackers.tensorflow',
 'l2hmc.trainers',
 'l2hmc.trainers.pytorch',
 'l2hmc.trainers.tensorflow',
 'l2hmc.utils',
 'l2hmc.utils.pytorch',
 'l2hmc.utils.tensorflow']

package_data = \
{'': ['*'],
 'l2hmc': ['bin/*',
           'conf/*',
           'conf/accelerate/cpu/*',
           'conf/accelerate/gpu/*',
           'conf/annealing_schedule/*',
           'conf/conv/*',
           'conf/dynamics/*',
           'conf/learning_rate/*',
           'conf/logdir/*',
           'conf/loss/*',
           'conf/mode/*',
           'conf/net_weights/*',
           'conf/network/*',
           'conf/steps/*',
           'conf/sweeps/*']}

install_requires = \
['accelerate>=0.6.2,<0.7.0',
 'arviz>=0.12.0,<0.13.0',
 'bokeh>=2.4.2,<3.0.0',
 'celerite>=0.4.2,<0.5.0',
 'h5py>=3.6.0,<4.0.0',
 'horovod>=0.24.2,<0.25.0',
 'hydra-colorlog>=1.1.0,<2.0.0',
 'hydra-core>=1.1.1,<2.0.0',
 'ipython>=8.2.0,<9.0.0',
 'joblib>=1.1.0,<2.0.0',
 'matplotlib>=3.5.1,<4.0.0',
 'matplotx>=0.3.6,<0.4.0',
 'mpi4py>=3.1.3,<4.0.0',
 'nodejs>=0.1.1,<0.2.0',
 'numpy>=1.22.3,<2.0.0',
 'rich>=12.1.0,<13.0.0',
 'seaborn>=0.11.2,<0.12.0',
 'tensorflow>=2.8.0,<3.0.0',
 'torch>=1.11.0,<2.0.0',
 'wandb>=0.12.11,<0.13.0',
 'xarray>=2022.3.0,<2023.0.0']

setup_kwargs = {
    'name': 'l2hmc',
    'version': '0.7.0',
    'description': 'L2HMC algorithm for sampling in Lattice QCD',
    'long_description': None,
    'author': 'Sam Foreman',
    'author_email': 'saforem2@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.10,<3.11',
}


setup(**setup_kwargs)
