# Section History

Section History is a tool to find a specific section of code in a git repository and show that section's history. It was developed to search for a specific requirement in a project and see how it has changed over time. As a user you specify an identifyer of the section of text that is to be found and the git repository to be searched.


## Installation

1. Clone the git repo
2. Hatch is used as a project manager. To install hatch with pip run the following command in a terminal

    ```
    pip install hatch
    ```
3. Create the virtual environment by running the following command

    ```
    hatch create env
    ```

4. To activate the virtual environment, run the following command in the root directory of the repository, i.e. SectionHistory

    ```
    hatch shell
    ```

## Configuration

A configuration file named config.ini is required in the root of the target repository.

Content of config.ini:

```
[regex_section]
regex_val = my_regex
```

Where my_regex is the regex to match a desired section in the history of the repository. Example configuration files are provided in the folder config-files-examples.

## Usage

### Usage as a command line application

The history of different sections will be stored in a cache (which can be local or global). Thus, before retrieving the history of a specific section the cache has to be created.

1. The history of a specific section can be retrieved by running the following commmand:
    ```
    python -m section_history [Directory] --update-cache
    ```
    Where Directory is the directory in which the sections to be analysed are stored. The directory is expected to either be the root of a repository or a subdirectory within a repository. The Identifyer is the unique ID of the section. If the cache is empty or has not yet been created it will be created in a folder in the root of the repository which the specified directory above belongs to.

    In order to specify where the cache should be stored, i.e. if not in the repository indicated by the directory above, it must be added to the command as the following shows:
    ```
    python -m section_history [Directory] --update-cache --cache-path [Path]
    ```
    Where Path indicates where the cache should be stored, if not the target repository. This can be the case when a global cache is preferred.

    The folder storing the cache will be called .sectionHistory and we advise to include it in the .gitignore. The ID of each section found will be represented as directories within the folder. Inside each directory are json files named after the commit hashes where changes to the sections were made. The json files will contain the entry associated with this section in this commit, i.e. if it was changed.

2. To update the cache after the cache has been created the following command can be run:
    ```
    python -m section_history [Directory] [identifyer]
    ```
    Where Directory is again the directory in which the sections to be analysed are stored. This will also create the cache if it has not already been created, i.e. if either of the commands in the first step have not been run or if the cache was deleted.

    If the cache is stored in for example a global cache, the following command must be run:
    ```
    python -m section_history [Directory] [Identifyer] --cache-path [Path]
    ```
    Where Path specifies again where the cache should be stored, if not in the root of the target repository.

    To force update the cache, i.e. remove the content of the cache and add entries to it again, the following flag can be added:
    ```
    python -m section_history [Directory] --update-cache --force
    ```
    The shorthand -f is also applicable.

3. By default the output will highlight differences between entries of a specific requirement. There's an optional flag available to get the entries without diff highlighting.
    ```
    -- no-diff
    ```

The output is the history of a section with a unique ID. It shows a list of instances of the section since the creation of the git repository. Each instance represent a change since the last instance. Changes in spaces, newlines and tabs will not be presented.

![One instance of the section history](/assets/images/oneentry.png)

### Usage as a Python library


## Testing

Testing the Section history is made easy with hatch. Inside the hatch environment in the root of the git repository run

    pytest

or to also get a report for the test coverage

    hatch run cov

All tests from within the tests folder will be run.
