# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/02_utils.ipynb.

# %% auto 0
__all__ = ['isdunder', 'vvalue', 'newedict', 'getmembers', 'getnames', 'getmeminfo', 'pathabrv', 'epath']

# %% ../nbs/02_utils.ipynb 4
import os
from typing import Any
from enum import _EnumDict

# %% ../nbs/02_utils.ipynb 6
from .cons import (__MEMBERS__, __INHERITABLE_MEMBERS__, _MEMBER_NAMES_, VALUE,)
from .atyp import IterStr

# %% ../nbs/02_utils.ipynb 8
def isdunder(name: str) -> bool: 
    return name.startswith('__') and name.endswith('__')

def vvalue(v: Any) -> Any:
    '''v or v.value'''
    return v.value if hasattr(v, VALUE) else v

def newedict(name) -> _EnumDict:
    '''Create a new EnumDict and set mandatory `_cls_name` attribute'''
    newdict = _EnumDict()
    newdict._cls_name = name
    return newdict

def __restore__(cls):
    setattr(cls, _MEMBER_NAMES_, list(getattr(cls, __INHERITABLE_MEMBERS__, dict()).keys()))   
    return

def getmembers(bases) -> dict:
    # arg is cls or bases
    membs = dict()
    for base in bases:        
        if not hasattr(base, __MEMBERS__): continue
        membs.update(**getattr(base, __MEMBERS__))
    return membs

def getnames(bases) -> list:
    # arg is cls or bases
    names = list()
    for base in bases:
        if not hasattr(base, _MEMBER_NAMES_): continue
        names.extend(getattr(base, _MEMBER_NAMES_, []))
    return names

def getmeminfo(bases) -> (dict, list):
    return getmembers(bases), getnames(bases)

# %% ../nbs/02_utils.ipynb 9
def pathabrv(path: str) -> str:
    parts = path.strip('/').split('/')
    return parts[-1].upper()

def epath(*paths: IterStr) -> str:
    '''The absolute and user-expanded path
    
    Parameters
    ----------
    paths : Iterable[str]
        The path components to join and expand
    '''
    return os.path.abspath(os.path.expanduser(os.path.join(*paths)))
