# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/02_meta.ipynb.

# %% auto 0
__all__ = ['NBDirsEnumMeta']

# %% ../nbs/02_meta.ipynb 6
import os
from string import Template

# %% ../nbs/02_meta.ipynb 8
from typing import (
    Any, Dict, List, Self, Type, Tuple, Union, Callable, 
    Generator, Optional, Iterable, TypeAlias
)

# %% ../nbs/02_meta.ipynb 11
from atyp import StrQ, IterStr, PathLike, PathLikeQ, StrTmpl, Mixin as MixinType

from nchr import DOT, DOT as DROOT

from nlit.args import ABRV, VERBOSE
from nlit.path import (ROOT, ROOT_DIR as RDIR, NBS, EXAMPLES, DATA, RESULTS, FIGURES, ROOT)
from nlit.sund import _MEMBER_NAMES_
from nlit.dund import (__RESTORE__, __MEMBERS__, __METACLASS__, __INHERITABLE_MEMBERS__)

# %% ../nbs/02_meta.ipynb 13
# from chck.strs import isdunder
from xath import NamedPath

from inhum.core import Inhum, InhumMeta, Mixin
from inhum.core import enumdict, ASMEMBER

# %% ../nbs/02_meta.ipynb 15
from nbdirs.dirs import (
    RDIR, NBDir, 
    ROOT_DIR, NBKS_DIR, EXPL_DIR, 
    DATA_DIR, RSLT_DIR, FIGS_DIR
)

from .mxns import ROOT_MIXIN

# %% ../nbs/02_meta.ipynb 17
class NBDirsEnumMeta(InhumMeta):
    root: PathLikeQ = None
    mixins: List[MixinType] = [ROOT_MIXIN]
    def _check_for_existing_members_(class_name, bases): ...
    
    @classmethod
    def __getroot__(metacls, clsdict, **kwargs) -> PathLike:
        rkws = kwargs.get(ROOT,  None)
        edir = clsdict.get(ROOT, None)
        rdir = clsdict.get(RDIR, None)
        mdir = getattr(metacls, ROOT, None)
        root = rkws or edir or rdir or mdir or DOT
        return root
        
    @classmethod
    def __rootdir__(metacls, clsdict, **kwargs):
        root = metacls.__getroot__(clsdict, **kwargs)
        if isinstance(root, (str, PathLike)):
            root = NBDir(path=root, leaf=DOT, abrv=ROOT, desc='The root directory')
        return root

    @classmethod
    def __setroot__(metacls, clsdict, root):        
        for k in (ROOT, RDIR):
            if k not in clsdict.keys(): continue
            clsdict.__delitem__(k)
            clsdict._member_names.pop(k)

        setattr(clsdict, ROOT, root)
        clsdict = metacls.setmem(clsdict, RDIR, root)
        return clsdict
    
    def update_root(cls, root: str, inplace: bool = False):
        def update(v, *args, **kwargs):  
            if kwargs.get('__key') == RDIR: return
            path = kwargs.get('__val')
            path = path.value.update(path=root, inplace=False)                    
            return path
        kls = cls.update(update, root=root, inplace=inplace)
        kls.__members__.get(RDIR).value.update(path=root, inplace=True)
        return kls
    
    def __new__(metacls, name, bases, clsdict, *, root: PathLikeQ = None, **kwargs): 
        root = metacls.__rootdir__(clsdict, root=root, **kwargs)
        newdict = metacls.__copydict__(clsdict, root=root, **kwargs)
        newdict = metacls.__setroot__(newdict, root)
        newcls = super().__new__(metacls, name, bases, newdict)
        newcls.update_root(root, inplace=True)
        return newcls
    
    @classmethod
    def __prepare__(metacls, name: str, bases: tuple, **kwargs: Any):
        clsdict = super().__prepare__(name, bases, **kwargs)
        metacls.delkey(clsdict, RDIR)
        return clsdict
    
    @property
    def dirs(cls) -> dict: return {d: getattr(cls, d).value for d in sorted(list(cls.__members__.keys()))}
    @property
    def todict(cls) -> Dict[str, NBDir]: return {k: v.value for k, v in cls.__members__.items()}
    @property
    def clsname(cls) -> str: return cls.__name__
    @property
    def dirnames(cls) -> list: return sorted([attr for attr in list(cls.__members__.keys())])

    def __contains__(cls, key):
        return key in cls._member_map_ or key in cls._member_names_ or key in cls.dirs.values()
    
    def makedirs(self, verbose: bool = False):
        dirs = self.dirs
        for name, path in dirs.items():
            path.make(verbose=verbose)
        return dirs
