# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_dirs.ipynb.

# %% auto 0
__all__ = ['RDIR', 'ROOT_DIR', 'NBKS_DIR', 'EXPL_DIR', 'DATA_DIR', 'RSLT_DIR', 'FIGS_DIR', 'NBDir']

# %% ../nbs/00_dirs.ipynb 6
import os
from string import Template

# %% ../nbs/00_dirs.ipynb 8
from typing import (
    Any, Dict, List, Self, Type, Tuple, Union, Callable, 
    Generator, Optional, Iterable, TypeAlias
)

# %% ../nbs/00_dirs.ipynb 11
from atyp import StrQ, IterStr, PathLike, PathLikeQ, StrTmpl, Mixin

from nchr import DOT

from nlit.args import ABRV, VERBOSE
from nlit.path import (ROOT, ROOT_DIR, NBS, EXAMPLES, DATA, RESULTS, FIGURES, ROOT)
from nlit.dund import (__RESTORE__, __MEMBERS__, __METACLASS__, __INHERITABLE_MEMBERS__)

# %% ../nbs/00_dirs.ipynb 13
# from chck.strs import isdunder
from inhum.core import Inhum, InhumMeta, Mixin
from xath import NamedPath

# %% ../nbs/00_dirs.ipynb 15
RDIR = ROOT_DIR.upper()

# %% ../nbs/00_dirs.ipynb 17
# DIRTMPL = Template('The relative directory $path ($abrv) that will be accessible via $attr')

# %% ../nbs/00_dirs.ipynb 19
class NBDir(NamedPath):
    '''
    NBDev projects have a standard directory structure of:

    ```shell
    ├── project
    │   ├── .gitignore
    │   ├── nbs
    │   │   ├── 00_core.ipynb
    │   │   ├── 01_data.ipynb
    │   │   ...
    │   ├── .github
    │       ├── workflows
    ```

    Since users work under `nbs` we want to be able to use relative paths to determine the path to / make 
    some useful directories for example:

    ```shell
    ├── project
    │   ├── .gitignore
    │   ├── nbs
    │   ├── data
    │   ├── examples
    │   ├── figures
    │   ├── results
    │   │   ...
    │   ├── .github
    │       ├── workflows
    ```

    This class, given a base / root directory should generate at the very least the following directories:
    - `ROOT_DIR = '../'`: this project's root directory
    - `NBKS_DIR = 'nbs/'`: the directory containing all nbdev notebooks e.g. `ROOT_DIR / NBKS_DIR`

    All other directories are generated from these two. For example, the `DATA_DIR` should be
    `ROOT_DIR / DATA_DIR` and the `FIGURES_DIR` should be `ROOT_DIR / FIGURES_DIR`.
    '''
    def __init__(
        self,
        path: StrQ = None, leaf: StrQ = None, 
        abrv: StrQ = None, desc: StrQ = None, name: StrQ = None, *args, **kwargs        
    ):
        kwargs.update(leaf=leaf, name=name, abrv=abrv, desc=desc)
        super().__init__(path, *args, **kwargs)

    def make(self, **kwargs) -> 'NBDir': 
        verb = f'{self.abrv}:\n'
        verb += f'\t- path\t= {self.full}\n'
        verb += f'\t- desc\t= {self.desc}\n'
        if not self.exists:            
            os.makedirs(self.full)
            verb += '\t- made\t= {True}'
        if kwargs.get(VERBOSE, True): print(verb)
        return self

# %% ../nbs/00_dirs.ipynb 20
ROOT_DIR = NBDir(DOT,      '..',     'ROOT', 'The nbdev project\'s root directory.')
NBKS_DIR = NBDir(ROOT_DIR, NBS,      'NBKS', 'The directory containing all nbdev notebooks.')
EXPL_DIR = NBDir(ROOT_DIR, EXAMPLES, 'EXPL', 'The directory containing all example notebooks.')
DATA_DIR = NBDir(ROOT_DIR, DATA,     'DATA', 'The default directory for data files.')
RSLT_DIR = NBDir(ROOT_DIR, RESULTS,  'RSLT', 'The default directory for results.')
FIGS_DIR = NBDir(ROOT_DIR, FIGURES,  'FIGS', 'The default directory for figures.')
