# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_cons.ipynb.

# %% auto 0
__all__ = ['DIR', 'DROOT', 'MIXINS', 'INPLACE', 'VERBOSE', 'ASMEMBER', 'DIRTMPL', 'ROOT', 'RDIR', 'VALUE', 'NBDEV_DOC']

# %% ../nbs/01_cons.ipynb 4
from string import Template

# %% ../nbs/01_cons.ipynb 6
DIR = 'DIR'
DROOT = '.'
MIXINS = 'mixins'
INPLACE = 'inplace'
VERBOSE = 'verbose'
ASMEMBER = 'asmember'

DIRTMPL = Template('The relative directory $path ($abrv) that will be accessible via $attr')

# %% ../nbs/01_cons.ipynb 8
__RESTORE__ = '__restore__'
__MEMBERS__ = '__members__'
__METACLASS__ = '__metaclass__'
_MEMBER_NAMES_ = '_member_names_'
__INHERITABLE_MEMBERS__ = '__inheritable_members__'

ROOT = 'root'
RDIR = 'ROOT_DIR'
VALUE = 'value'

# %% ../nbs/01_cons.ipynb 10
NBDEV_DOC = '''
NBDev projects have a standard directory structure of:

```
├── project
│   ├── .gitignore
│   ├── nbs
│   │   ├── 00_core.ipynb
│   │   ├── 01_data.ipynb
│   │   ...
│   ├── .github
│       ├── workflows
```

Since users work under `nbs` we want to be able to use relative paths to determine the path to / make 
some useful directories for example:

```
├── project
│   ├── .gitignore
│   ├── nbs
│   ├── data
│   ├── examples
│   ├── figures
│   ├── results
│   │   ...
│   ├── .github
│       ├── workflows
```

This class, given a base / root directory should generate at the very least the following directories:
- `ROOT_DIR = '../'`: this project's root directory
- `NBKS_DIR = 'nbs/'`: the directory containing all nbdev notebooks e.g. `ROOT_DIR / NBKS_DIR`

All other directories are generated from these two. For example, the `DATA_DIR` should be
`ROOT_DIR / DATA_DIR` and the `FIGURES_DIR` should be `ROOT_DIR / FIGURES_DIR`.
'''
