# nbdirs

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

## Developer Guide

### Setup

``` sh
# create conda environment
$ mamba env create -f env.yml

# update conda environment
$ mamba env update -n nbdirs --file env.yml
```

### Install

``` sh
pip install -e .

# install from pypi
pip install nbdirs
```

### nbdev

``` sh
# activate conda environment
$ conda activate nbdirs

# make sure the nbdirs package is installed in development mode
$ pip install -e .

# make changes under nbs/ directory
# ...

# compile to have changes apply to the nbdirs package
$ nbdev_prepare
```

### Publishing

``` sh
# publish to pypi
$ nbdev_pypi

# publish to conda
$ nbdev_conda --build_args '-c conda-forge'
$ nbdev_conda --mambabuild --build_args '-c conda-forge -c dsm-72'
```

# Usage

## Installation

Install latest from the GitHub
[repository](https://github.com/dsm-72/nbdirs):

``` sh
$ pip install git+https://github.com/dsm-72/nbdirs.git
```

or from [conda](https://anaconda.org/dsm-72/nbdirs)

``` sh
$ conda install -c dsm-72 nbdirs
```

or from [pypi](https://pypi.org/project/nbdirs/)

``` sh
$ pip install nbdirs
```

## Documentation

Documentation can be found hosted on GitHub
[repository](https://github.com/dsm-72/nbdirs)
[pages](https://dsm-72.github.io/nbdirs/). Additionally you can find
package manager specific guidelines on
[conda](https://anaconda.org/dsm-72/nbdirs) and
[pypi](https://pypi.org/project/nbdirs/) respectively.

``` python
NBDirs.makedirs(verbose=True)
```

    DATA:
        - path  = /Users/solst/Projects/nbdirs/data
        - desc  = The default directory for data files.

    EXPL:
        - path  = /Users/solst/Projects/nbdirs/examples
        - desc  = The directory containing all example notebooks.

    FIGS:
        - path  = /Users/solst/Projects/nbdirs/figures
        - desc  = The default directory for figures.

    NBKS:
        - path  = /Users/solst/Projects/nbdirs/nbs
        - desc  = The directory containing all nbdev notebooks.

    root:
        - path  = /Users/solst/Projects/nbdirs/nbs
        - desc  = The root directory

    RSLT:
        - path  = /Users/solst/Projects/nbdirs/results
        - desc  = The default directory for results.

    {'DATA_DIR': NBDir(/Users/solst/Projects/nbdirs/data),
     'EXPL_DIR': NBDir(/Users/solst/Projects/nbdirs/examples),
     'FIGS_DIR': NBDir(/Users/solst/Projects/nbdirs/figures),
     'NBKS_DIR': NBDir(/Users/solst/Projects/nbdirs/nbs),
     'ROOT_DIR': NBDir(/Users/solst/Projects/nbdirs/nbs),
     'RSLT_DIR': NBDir(/Users/solst/Projects/nbdirs/results)}
