"""
Migration script to grow MySQL blobs.
"""

import logging

from sqlalchemy import MetaData

log = logging.getLogger(__name__)
metadata = MetaData()

BLOB_COLUMNS = [
    ("deferred_job", "params"),
    ("extended_metadata", "data"),
    ("form_definition", "fields"),
    ("form_definition", "layout"),
    ("form_values", "content"),
    ("history_dataset_association", "metadata"),
    ("job", "destination_params"),
    ("library_dataset_dataset_association", "metadata"),
    ("post_job_action", "action_arguments"),
    ("request", "notification"),
    ("sample", "workflow"),
    ("transfer_job", "params"),
    ("workflow_step", "tool_inputs"),
    ("workflow_step", "tool_errors"),
    ("workflow_step", "position"),
    ("workflow_step", "config"),
    ("tool_shed_repository", "metadata"),
    ("tool_shed_repository", "tool_shed_status"),
]


def upgrade(migrate_engine):
    print(__doc__)
    metadata.bind = migrate_engine
    metadata.reflect()

    if migrate_engine.name != "mysql":
        return

    for (table, column) in BLOB_COLUMNS:
        cmd = f"ALTER TABLE {table} MODIFY COLUMN {column} MEDIUMBLOB;"
        try:
            migrate_engine.execute(cmd)
        except Exception:
            log.exception("Failed to grow column %s.%s", table, column)


def downgrade(migrate_engine):
    pass
