"""Added importHash

Peek Plugin Database Migration Script

Revision ID: 56d805072d2a
Revises: 3a9cddaf05e5
Create Date: 2017-10-15 12:05:26.795359

"""

# revision identifiers, used by Alembic.
revision = "56d805072d2a"
down_revision = "3a9cddaf05e5"
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "InternalGroup",
        sa.Column("importHash", sa.String(length=50), nullable=True),
        schema="core_user",
    )
    op.create_index(
        "idx_InternalGroupTable_importHash",
        "InternalGroup",
        ["importHash"],
        unique=False,
        schema="core_user",
    )
    op.add_column(
        "InternalUser",
        sa.Column("importHash", sa.String(length=50), nullable=True),
        schema="core_user",
    )
    op.create_index(
        "idx_InternalUserTable_importHash",
        "InternalUser",
        ["importHash"],
        unique=False,
        schema="core_user",
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        "idx_InternalUserTable_importHash",
        table_name="InternalUser",
        schema="core_user",
    )
    op.drop_column("InternalUser", "importHash", schema="core_user")
    op.drop_index(
        "idx_InternalGroupTable_importHash",
        table_name="InternalGroup",
        schema="core_user",
    )
    op.drop_column("InternalGroup", "importHash", schema="core_user")
    # ### end Alembic commands ###
