"""added ldap table

Peek Plugin Database Migration Script

Revision ID: 2209cf338e6d
Revises: 5e33c6b788fd
Create Date: 2019-07-31 20:32:15.541766

"""

# revision identifiers, used by Alembic.
revision = "2209cf338e6d"
down_revision = "5e33c6b788fd"
branch_labels = None
depends_on = None

from alembic import op
import sqlalchemy as sa
import geoalchemy2


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "LdapSetting",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("ldapTitle", sa.String(), nullable=False),
        sa.Column("ldapDomain", sa.String(), nullable=False),
        sa.Column("ldapUri", sa.String(), nullable=False),
        sa.Column("ldapCNFolders", sa.String(), nullable=True),
        sa.Column("ldapOUFolders", sa.String(), nullable=True),
        sa.Column("adminEnabled", sa.Boolean(), server_default="0", nullable=False),
        sa.Column("desktopEnabled", sa.Boolean(), server_default="0", nullable=False),
        sa.Column("mobileEnabled", sa.Boolean(), server_default="0", nullable=False),
        sa.Column("ldapGroups", sa.String(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("ldapTitle"),
        schema="core_user",
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("LdapSetting", schema="core_user")
    # ### end Alembic commands ###
