/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.security;

public class NamePasswordCredential {
    private String name;
    private byte[] password;
    private String _ldapPath;
    private String _ldapPort;

    public NamePasswordCredential(String name, byte[] password, String domainController, String port) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Value cannot be null or empty." + System.lineSeparator() + "Parameter name: name");
        }
        if (password == null) {
            String emptyString = "";
            this.password = emptyString.getBytes();
        }
        this.name = name;
        if (domainController != null) {
            this._ldapPath = domainController;
        }
        if (port != null) {
            this._ldapPort = port;
        }
    }

    public NamePasswordCredential(String name, String password, String domainController, String port) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: name");
        }
        if (password == null) {
            password = "";
        }
        this.name = name;
        this.password = password.getBytes();
        if (domainController != null) {
            this._ldapPath = domainController;
        }
        if (port != null) {
            this._ldapPort = port;
        }
    }

    public final String getName() {
        return this.name;
    }

    public final byte[] getPasswordBytes() {
        return this.password;
    }

    public final String getPassword() {
        return new String(this.password, 0, this.password.length);
    }

    public final String getDomainController() {
        return this._ldapPath;
    }

    public final void setDomainController(String value) {
        this._ldapPath = value;
    }

    public final String getLdapPort() {
        return this._ldapPort;
    }

    public final void setLdapPort(String _ldapPort) {
        this._ldapPort = _ldapPort;
    }
}

