/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.jsr107.spi;

import com.alachisoft.ncache.jsr107.NCacheManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cache.CacheManager;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;

public class NCacheCachingProvider
implements CachingProvider {
    private static final URI URI_DEFAULT;
    protected final Map<ClassLoader, ConcurrentMap<URI, NCacheManager>> cacheManagers = new WeakHashMap<ClassLoader, ConcurrentMap<URI, NCacheManager>>();
    private Properties properties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        NCacheManager cacheManager;
        uri = uri == null ? this.getDefaultURI() : uri;
        classLoader = classLoader == null ? this.getDefaultClassLoader() : classLoader;
        Map<ClassLoader, ConcurrentMap<URI, NCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            ConcurrentMap<URI, NCacheManager> byURI = this.cacheManagers.get(classLoader);
            if (byURI == null) {
                byURI = new ConcurrentHashMap<URI, NCacheManager>();
                this.cacheManagers.put(classLoader, byURI);
            }
            if ((cacheManager = (NCacheManager)byURI.get(uri)) == null) {
                cacheManager = this.getCacheManagerInstance(uri, classLoader, properties);
                byURI.put(uri, cacheManager);
            }
        }
        return cacheManager;
    }

    protected NCacheManager getCacheManagerInstance(URI uri, ClassLoader classLoader, Properties properties) {
        return new NCacheManager(this, classLoader, uri, properties);
    }

    public ClassLoader getDefaultClassLoader() {
        return this.getClass().getClassLoader();
    }

    public URI getDefaultURI() {
        return URI_DEFAULT;
    }

    public Properties getDefaultProperties() {
        return this.properties;
    }

    public CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
        return this.getCacheManager(uri, classLoader, null);
    }

    public CacheManager getCacheManager() {
        return this.getCacheManager(this.getDefaultURI(), this.getDefaultClassLoader());
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ClassLoader classLoader) {
        Map<ClassLoader, ConcurrentMap<URI, NCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            ConcurrentMap<URI, NCacheManager> map2 = this.cacheManagers.remove(classLoader);
            if (map2 != null) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(URI uri, ClassLoader classLoader) {
        Map<ClassLoader, ConcurrentMap<URI, NCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            NCacheManager jCacheManager;
            ConcurrentMap<URI, NCacheManager> map2 = this.cacheManagers.get(classLoader);
            if (map2 != null && (jCacheManager = (NCacheManager)map2.remove(uri)) != null) {
                jCacheManager.close();
            }
        }
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        return optionalFeature == OptionalFeature.STORE_BY_REFERENCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(NCacheManager jCacheManager) {
        Map<ClassLoader, ConcurrentMap<URI, NCacheManager>> map = this.cacheManagers;
        synchronized (map) {
            ConcurrentMap<URI, NCacheManager> map2 = this.cacheManagers.get(jCacheManager.getClassLoader());
            if (map2.remove(jCacheManager.getURI()) != null) {
                jCacheManager.shutdown();
            }
        }
    }

    static {
        URI ur = null;
        Object uri = null;
        try {
            ur = new URI("default");
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(NCacheCachingProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        URI_DEFAULT = ur;
    }
}

